/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.rmi.RemoteException;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.ResourceContextImpl;
import org.globus.wsrf.impl.notification.SubscribeHelper;
import org.globus.wsrf.utils.FaultHelper;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsn.InvalidTopicExpressionFaultType;
import org.oasis.wsn.ResourceUnknownFaultType;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeCreationFailedFaultType;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicNotSupportedFaultType;
import org.oasis.wsn.TopicPathDialectUnknownFaultType;

public class SubscribeProvider {
    private static Log logger = LogFactory.getLog(SubscribeProvider.class.getName());
    private static I18n i18n = I18n.getI18n(Resources.class.getName());

    public SubscribeResponse subscribe(Subscribe request) throws RemoteException, ResourceUnknownFaultType, SubscribeCreationFailedFaultType, TopicPathDialectUnknownFaultType, InvalidTopicExpressionFaultType, TopicNotSupportedFaultType {
        Resource resource = null;
        ResourceKey key = null;
        String homeLocation = null;
        ResourceContext ctx = null;
        try {
            ctx = ResourceContext.getResourceContext();
            key = ctx.getResourceKey();
            resource = ctx.getResource();
            homeLocation = ((ResourceContextImpl)ctx).getResourceHomeLocation();
        }
        catch (NoSuchResourceException e) {
            ResourceUnknownFaultType fault = new ResourceUnknownFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.addFaultCause(e);
            throw fault;
        }
        catch (Exception e) {
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.addFaultCause(e);
            faultHelper.setDescription(i18n.getMessage("resourceDisoveryFailed"));
            throw fault;
        }
        EndpointReferenceType reference = this.getSubscribeHelper(ctx, resource, key, homeLocation, request).subscribe();
        SubscribeResponse response = new SubscribeResponse();
        response.setSubscriptionReference(reference);
        return response;
    }

    protected SubscribeHelper getSubscribeHelper(ResourceContext context, Resource producerResource, ResourceKey producerKey, String producerHomeLocation, Subscribe request) {
        return new SubscribeHelper(context, producerResource, producerKey, producerHomeLocation, request);
    }
}

