/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.secureconv.service;

import commonj.timers.TimerListener;
import commonj.timers.TimerManager;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.impl.ResourceHomeImpl;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.security.authentication.secureconv.service.AuthenticationServiceConstants;
import org.globus.wsrf.impl.security.authentication.secureconv.service.ExpiredContextTimerListener;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.ietf.jgss.GSSContext;

public class SecurityContextHome
extends ResourceHomeImpl
implements AuthenticationServiceConstants {
    static Log logger = LogFactory.getLog((String)SecurityContextHome.class.getName());
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    public synchronized void initialize() throws Exception {
        super.initialize();
        logger.debug((Object)"Initializing timer");
        ExpiredContextTimerListener listener = new ExpiredContextTimerListener(this);
        int interval = ExpiredContextTimerListener.getInterval();
        InitialContext initialContext = new InitialContext();
        TimerManager timerManager = (TimerManager)initialContext.lookup("java:comp/env//timer/ContainerTimer");
        timerManager.schedule((TimerListener)listener, (long)interval, (long)interval);
    }

    public synchronized SimpleResourceKey create(GSSContext context) {
        String contextId = uuidGen.nextUUID();
        logger.debug((Object)("Context id " + contextId));
        SecurityContext secCtx = new SecurityContext(context, contextId);
        SimpleResourceKey key = new SimpleResourceKey(this.keyTypeName, contextId);
        this.add(key, secCtx);
        return key;
    }

    public synchronized void removeExpiredContexts() {
        logger.debug((Object)"scanning for expired contexts");
        Set entries = this.resources.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SecurityContext context = (SecurityContext)entry.getValue();
            if (!context.getContext().isEstablished() || context.getContext().getLifetime() > 0) continue;
            logger.debug((Object)"removing expired context");
            iterator.remove();
        }
    }
}

