/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators;

import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.operators.DeployerOperator;
import org.gcube.common.vremanagement.deployer.impl.operators.common.PackageAldreadyDeployedException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Report;
import org.gcube.common.vremanagement.deployer.impl.operators.common.UpdateException;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.Downloader;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.ExternalPackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.PackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.resources.BasePackage;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.Converter;
import org.gcube.common.vremanagement.deployer.impl.resources.KeyData;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.Deployable;
import org.gcube.common.vremanagement.deployer.impl.resources.undeployment.UndeployablePackage;
import org.gcube.common.vremanagement.deployer.impl.resources.undeployment.UndeployablePackageFactory;
import org.gcube.common.vremanagement.deployer.impl.state.DeployerResource;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;
import org.gcube.common.vremanagement.deployer.stubs.deployer.UpdateParameters;

public class UpdateOperator
extends GCUBEHandler<DeployerResource> {
    protected final GCUBELog logger = new GCUBELog(UpdateOperator.class);
    private UpdateParameters params;
    private PackageInfo[] deployPackages = null;
    private PackageInfo[] undeployPackages = null;
    private boolean rollback = false;
    private boolean restart = false;
    private GCUBEScope callerScope = null;
    private Set<GCUBEScope> updateScope = null;
    private DeployerResource resource = null;
    private String callbackID;
    private boolean cleanState = false;
    public static final String SINGLETON_DEPLOYER_RESOURCE_KEY = "DeployerState";

    public UpdateOperator(DeployerResource deployerResource, UpdateParameters params, GCUBEScope callerScope) {
        this.params = params;
        this.updateScope = new HashSet<GCUBEScope>();
        this.deployPackages = params.getDeployPackage();
        this.undeployPackages = params.getUndeployPackage();
        this.resource = deployerResource;
        this.cleanState = params.isCleanState();
        this.callbackID = params.getCallbackID() == null || params.getCallbackID().trim() == "" ? "DEFAULT" : params.getCallbackID();
    }

    public void run() throws Exception {
        PackageInfo[] undeployPackages = this.params.getUndeployPackage();
        PackageInfo[] deployPackages = this.params.getDeployPackage();
        DeployerOperator.deployLock.lock();
        Report finalreport = new Report(this.params.getEndpointReference(), this.params.getCallbackID(), undeployPackages.length, Report.TYPE.UPDATE, this.callerScope);
        this.resource.setLastDeployment(this.params.getCallbackID());
        for (int i = 0; i < undeployPackages.length; ++i) {
            PackageInfo deployable_package = undeployPackages[i];
            finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.WAITING, i, new String[0]);
        }
        this.restart = false;
        Report.PACKAGESTATUS deploymentStatus = null;
        Report.PACKAGESTATUS undeploymentStatus = null;
        for (int i = 0; i < undeployPackages.length; ++i) {
            this.logger.info((Object)("start undeployment phase, package: " + undeployPackages[i].getName()));
            PackageInfo undeployable_package = undeployPackages[i];
            undeploymentStatus = this.undeploy(undeployable_package, finalreport);
            this.logger.info((Object)("undeployment package " + undeployPackages[i].getName() + " terminated with status: " + (Object)((Object)undeploymentStatus)));
            PackageInfo deployable_package = null;
            if (this.isDeployable(undeploymentStatus)) {
                deployable_package = deployPackages[i];
                this.logger.info((Object)("start deployment phase package: " + deployable_package.getName()));
                deploymentStatus = this.deploy(deployable_package, i);
            } else {
                this.logger.info((Object)("deployment phase aborted: negative undeployment status " + (Object)((Object)undeploymentStatus)));
            }
            finalreport = this.fillReport(finalreport, undeploymentStatus, deploymentStatus, deployable_package, undeployable_package, i);
            deploymentStatus = null;
            undeploymentStatus = null;
        }
        if (this.rollback) {
            this.rollback();
        }
        if (this.restart) {
            finalreport.send();
            finalreport.save();
            GHNContext.getContext().restart(new String[0]);
            this.restart = false;
        } else {
            finalreport.close();
            finalreport.send();
            finalreport.save();
        }
        DeployerOperator.deployLock.unlock();
    }

    private Report fillReport(Report finalreport, Report.PACKAGESTATUS undeploymentStatus, Report.PACKAGESTATUS deploymentStatus, PackageInfo deployable_package, PackageInfo undeployable_package, int position) {
        Report.PACKAGESTATUS updateStatus = Report.PACKAGESTATUS.UPDATED;
        if (undeploymentStatus.equals((Object)Report.PACKAGESTATUS.NOTUNDEPLOYABLE) || undeploymentStatus.equals((Object)Report.PACKAGESTATUS.FAILED) || deploymentStatus.equals((Object)Report.PACKAGESTATUS.ALREADYDEPLOYED) || deploymentStatus.equals((Object)Report.PACKAGESTATUS.FAILED)) {
            updateStatus = Report.PACKAGESTATUS.FAILED;
        }
        String message = "";
        message = updateStatus.equals((Object)Report.PACKAGESTATUS.UPDATED) ? " package succesfully updated" : "package not updated: undeployment package " + undeployable_package.getName() + " with version " + undeployable_package.getVersion() + " has status " + (Object)((Object)undeploymentStatus) + " and deployment package " + deployable_package.getName() + " with version: " + deployable_package.getVersion() + " has status " + (Object)((Object)deploymentStatus);
        this.logger.info((Object)("fill report for package: " + deployable_package.getName() + " with message: " + message));
        finalreport.addPackage(deployable_package, updateStatus, position, message);
        return finalreport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Report.PACKAGESTATUS deploy(PackageInfo deployable_package, int i) {
        Report.PACKAGESTATUS status;
        block17: {
            status = null;
            this.logger.info((Object)("updating the package " + deployable_package.getName() + "... "));
            if (this.rollback) {
                status = Report.PACKAGESTATUS.SKIPPED;
                this.logger.warn((Object)("the package " + deployable_package.getName() + " could not be updated due to a previous error in another package"));
                return status;
            }
            try {
                this.logger.debug((Object)("initialising the downloader for package " + deployable_package.getName() + "... "));
                Downloader manager = new Downloader(deployable_package, true);
                manager.downloadPackage(new GCUBEScope[0]);
                Deployable pack = null;
                if (manager.getPackagetype() == Downloader.PackageType.SERVICEARCHIVE) {
                    pack = new PackageExtractor(manager).getPackage();
                } else if (manager.getPackagetype() == Downloader.PackageType.JAR) {
                    pack = new ExternalPackageExtractor(manager).getPackage();
                }
                if (pack != null) {
                    try {
                        if (!this.resource.isDeployed(pack.getSourcePackage())) {
                            PlatformDescription packagePlatform = pack.getTargetPlatform();
                            if (packagePlatform == null || packagePlatform.getName().equalsIgnoreCase("gCore")) {
                                pack.deploy(this.updateScope);
                                status = pack.verify() ? Report.PACKAGESTATUS.UPDATED : Report.PACKAGESTATUS.NOTVERIFIED;
                            }
                            this.logger.info((Object)("The package " + deployable_package.getName() + " has been successfully updated"));
                            this.logger.trace((Object)("Adding package " + pack.getSourcePackage().getKey() + " to the serialized state"));
                            this.resource.addPackage(pack.getSourcePackage());
                        } else {
                            this.logger.info((Object)("The package " + deployable_package.getName() + " has been already deployed"));
                            status = Report.PACKAGESTATUS.ALREADYDEPLOYED;
                            pack.getSourcePackage().setScopes(this.updateScope);
                            this.resource.addPackage(pack.getSourcePackage());
                        }
                    }
                    catch (PackageAldreadyDeployedException ade) {
                        this.logger.info((Object)("The package " + deployable_package.getName() + " has been already deployed"));
                        status = Report.PACKAGESTATUS.ALREADYDEPLOYED;
                        pack.getSourcePackage().setScopes(this.updateScope);
                        this.resource.addPackage(pack.getSourcePackage());
                    }
                    finally {
                        pack.clean();
                    }
                    if (pack.requireRestart()) {
                        this.restart = true;
                    }
                    break block17;
                }
                throw new Exception("unable to find the package description in the service profile");
            }
            catch (Exception e) {
                this.logger.warn((Object)("the package " + deployable_package.getName() + " has NOT been successfully updated"), (Throwable)e);
                status = Report.PACKAGESTATUS.FAILED;
                this.rollback = true;
                return status;
            }
        }
        return status;
    }

    private boolean isDeployable(Report.PACKAGESTATUS undeploymentStatus) {
        return !undeploymentStatus.equals((Object)Report.PACKAGESTATUS.FAILED) && !undeploymentStatus.equals((Object)Report.PACKAGESTATUS.NOTUNDEPLOYABLE);
    }

    private void rollback() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report.PACKAGESTATUS undeploy(PackageInfo packageInfo, Report finalreport) {
        Report.PACKAGESTATUS status;
        block14: {
            this.logger.debug((Object)("undeploy package: " + packageInfo.getName()));
            ((DeployerResource)((Object)this.getHandled())).setLastDeployment(this.callbackID);
            try {
                BasePackage baseP = Converter.toBasePackage(packageInfo);
                KeyData kd = baseP.getKey();
                this.logger.debug((Object)("Checking package name: " + kd.getPackageName()));
                BaseTypedPackage base = ((DeployerResource)((Object)this.getHandled())).getPackage(kd);
                this.logger.debug((Object)("Checking package " + base.getKey() + " for undeployment"));
                if (((DeployerResource)((Object)this.getHandled())).isUndeployable(base, this.updateScope)) {
                    if (base.getType() != BaseTypedPackage.TYPE.MAINPACKAGE) {
                        throw new UpdateException("The update operation is not implemented for this type of package: " + base.getType());
                    }
                    UndeployablePackage undeployablePackage = UndeployablePackageFactory.makeUndeployable(base);
                    PlatformDescription packagePlatform = undeployablePackage.getTargetPlatform();
                    if (packagePlatform == null || packagePlatform.getName().equalsIgnoreCase("gCore")) {
                        this.logger.info((Object)("The package " + undeployablePackage.getKey() + " is going to be undeployed"));
                        undeployablePackage.undeploy(this.updateScope, this.cleanState);
                        if (undeployablePackage.verify()) {
                            status = Report.PACKAGESTATUS.UNDEPLOYED;
                            this.logger.info((Object)("The package " + packageInfo.getName() + " has been successfully undeployed"));
                        } else {
                            status = Report.PACKAGESTATUS.NOTVERIFIED;
                            this.logger.info((Object)("The package " + packageInfo.getName() + " has been successfully undeployed, but not verified"));
                        }
                        ((DeployerResource)((Object)this.getHandled())).removePackage(undeployablePackage);
                    } else {
                        try {
                            undeployablePackage.undeploy(this.updateScope, this.cleanState);
                            status = Report.PACKAGESTATUS.UNDEPLOYED;
                            this.logger.info((Object)("The package " + packageInfo.getName() + " has been successfully undeployed"));
                        }
                        finally {
                            ((DeployerResource)((Object)this.getHandled())).removePackage(undeployablePackage);
                        }
                    }
                    if (undeployablePackage.requireRestart()) {
                        this.restart = true;
                    }
                    break block14;
                }
                this.logger.info((Object)("The package " + packageInfo.getName() + " cannot be undeployed"));
                base.removeScopes(this.updateScope);
                this.logger.info((Object)("The package has been removed from the target undeployment scope(s) " + this.updateScope));
                status = Report.PACKAGESTATUS.REMOVEDFROMSCOPE;
            }
            catch (DeployerResource.NoSuchPackageException e) {
                this.logger.warn((Object)("the package " + packageInfo.getName() + " cannot be undeployed: " + e.getMessage()));
                status = Report.PACKAGESTATUS.NOTUNDEPLOYABLE;
            }
            catch (Exception e) {
                this.logger.error((Object)("An error occurs while undeploying the package " + packageInfo.getName()), (Throwable)e);
                status = Report.PACKAGESTATUS.FAILED;
            }
        }
        return status;
    }
}

