/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.TestCase;
import ise.antelope.tasks.TestStatisticAccumulator;
import ise.library.ascii.MessageBox;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.types.FileSet;

public class Suite
extends Task
implements TaskContainer,
TestStatisticAccumulator {
    private String name = null;
    private Vector tasks = null;
    private Vector filesets = null;
    private int totalTestCount = 0;
    private int totalRanCount = 0;
    private int totalPassedCount = 0;
    private int totalFailedCount = 0;
    private int totalWarningCount = 0;
    private Vector failures = new Vector();
    private boolean showSummary = true;
    private boolean enabled = true;
    private boolean assertEnabled = true;
    private boolean failonerror = false;

    public void init() {
        super.init();
        this.setTaskName("suite");
    }

    public void addTestCase(TestCase tc) {
        this.addTask(tc);
    }

    public void addSuite(Suite s) {
        this.addTask(s);
    }

    public void addTask(Task task) {
        if (this.tasks == null) {
            this.tasks = new Vector();
        }
        this.tasks.addElement(task);
    }

    public void addFileset(FileSet fs) {
        if (this.tasks == null) {
            this.tasks = new Vector();
        }
        this.tasks.addElement(fs);
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public void setFailonerror(boolean f) {
        this.failonerror = f;
    }

    public boolean getFailonerror() {
        return this.failonerror;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public void setAssertsenabled(boolean b) {
        this.assertEnabled = b;
    }

    public void setShowsummary(boolean b) {
        this.showSummary = b;
    }

    public int getTestCaseCount() {
        return this.totalTestCount;
    }

    public int getRanCount() {
        return this.totalRanCount;
    }

    public int getPassedCount() {
        return this.totalPassedCount;
    }

    public int getFailedCount() {
        return this.totalFailedCount;
    }

    public Enumeration getFailures() {
        return this.failures.elements();
    }

    public int getWarningCount() {
        return this.totalWarningCount;
    }

    public void execute() {
        String ae;
        if (!this.enabled) {
            return;
        }
        String string = ae = this.assertEnabled ? "true" : "false";
        if (this.assertEnabled) {
            this.getProject().setProperty("ant.enable.asserts", ae);
        }
        try {
            Task task;
            Enumeration e;
            Target setUp = null;
            Target tearDown = null;
            Hashtable targets = this.getProject().getTargets();
            Enumeration en = targets.keys();
            while (en.hasMoreElements()) {
                String target_name = (String)en.nextElement();
                if (target_name.equals("setUp")) {
                    setUp = (Target)targets.get(target_name);
                    continue;
                }
                if (!target_name.equals("tearDown")) continue;
                tearDown = (Target)targets.get(target_name);
            }
            if (setUp != null) {
                setUp.execute();
            }
            Vector testcases = new Vector();
            if (this.tasks != null && this.tasks.size() > 0) {
                e = this.tasks.elements();
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    if (o instanceof FileSet) {
                        this.loadTestFiles((FileSet)o, testcases);
                        continue;
                    }
                    testcases.addElement(o);
                }
                e = testcases.elements();
                while (e.hasMoreElements()) {
                    task = (Task)e.nextElement();
                    task.perform();
                }
            }
            if (tearDown != null) {
                tearDown.execute();
            }
            e = testcases.elements();
            while (e.hasMoreElements()) {
                task = (Task)e.nextElement();
                if (!(task instanceof TestStatisticAccumulator)) continue;
                TestStatisticAccumulator acc = (TestStatisticAccumulator)((Object)task);
                this.totalTestCount += acc.getTestCaseCount();
                this.totalRanCount += acc.getRanCount();
                this.totalPassedCount += acc.getPassedCount();
                this.totalFailedCount += acc.getFailedCount();
                this.totalWarningCount += acc.getWarningCount();
                Enumeration fen = acc.getFailures();
                while (fen.hasMoreElements()) {
                    this.failures.add(fen.nextElement());
                }
            }
            if (this.showSummary) {
                this.log(this.getSummary());
            }
            if (this.failonerror && this.totalFailedCount > 0) {
                throw new BuildException("+++++ FAILED +++++\n" + this.getSummary());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BuildException(ex.getMessage());
        }
    }

    public String getSummary() {
        String title = (this.name == null ? "Suite" : this.name) + " Totals";
        StringBuffer msg = new StringBuffer();
        String ls = System.getProperty("line.separator");
        if (this.failures.size() > 0) {
            String error_title = "Errors";
            StringBuffer error_msg = new StringBuffer();
            Enumeration en = this.failures.elements();
            while (en.hasMoreElements()) {
                error_msg.append((String)en.nextElement()).append(ls);
            }
            int box_width = MessageBox.getMaxWidth();
            MessageBox.setMaxWidth(box_width - 8);
            msg.append(MessageBox.box(error_title, error_msg));
            MessageBox.setMaxWidth(box_width);
            msg.append(ls);
        }
        msg.append("Total Ran:      ").append(this.totalRanCount).append(" out of ").append(this.totalTestCount).append(" tests.").append(ls);
        msg.append("Total Passed:   ").append(this.totalPassedCount).append(ls);
        msg.append("Total Warnings: ").append(this.totalWarningCount).append(ls);
        msg.append("Total Failed:   ").append(this.totalFailedCount).append(ls);
        return MessageBox.box(title, msg);
    }

    protected void loadTestFiles(FileSet fs, Vector destination) {
        int j;
        File d = fs.getDir(this.getProject());
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        String[] files = ds.getIncludedFiles();
        String[] dirs = ds.getIncludedDirectories();
        if (files.length > 0) {
            for (j = 0; j < files.length; ++j) {
                File f = new File(d, files[j]);
                TestCase tc = this.createTestCase(f);
                destination.addElement(tc);
            }
        }
        if (dirs.length > 0) {
            for (j = dirs.length - 1; j >= 0; --j) {
                File dir = new File(d, dirs[j]);
                String[] dirFiles = dir.list();
                if (dirFiles == null || dirFiles.length <= 0) continue;
                for (int i = 0; i < dirFiles.length; ++i) {
                    File f = new File(dir, dirFiles[i]);
                    TestCase tc = this.createTestCase(f);
                    destination.addElement(tc);
                }
            }
        }
    }

    private TestCase createTestCase(File f) {
        TestCase tc = new TestCase();
        tc.init();
        tc.setFile(f);
        tc.setProject(this.getProject());
        return tc;
    }
}

