/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.WSHandlerConstants;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSAddTimestamp;
import org.apache.ws.security.message.WSEncryptBody;
import org.apache.ws.security.message.WSSAddSAMLToken;
import org.apache.ws.security.message.WSSAddUsernameToken;
import org.apache.ws.security.message.WSSignEnvelope;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.saml.SAMLIssuerFactory;
import org.apache.ws.security.util.StringUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.opensaml.SAMLAssertion;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WSS4JHandler
implements Handler {
    private HandlerInfo handlerInfo;
    static Log log = LogFactory.getLog((class$org$apache$ws$security$handler$WSS4JHandler == null ? (class$org$apache$ws$security$handler$WSS4JHandler = WSS4JHandler.class$("org.apache.ws.security.handler.WSS4JHandler")) : class$org$apache$ws$security$handler$WSS4JHandler).getName());
    static final WSSecurityEngine secEngine = new WSSecurityEngine();
    private boolean doDebug = true;
    private static Hashtable cryptos = new Hashtable(5);
    private SOAPMessageContext msgContext = null;
    Crypto sigCrypto = null;
    String sigPropFile = null;
    Crypto decCrypto = null;
    String decPropFile = null;
    protected int timeToLive = 300;
    private boolean noSerialization = false;
    private SOAPConstants soapConstants = null;
    String actor = null;
    String username = null;
    String pwType = null;
    String[] utElements = null;
    int sigKeyId = 0;
    String sigAlgorithm = null;
    Vector signatureParts = new Vector();
    Crypto encCrypto = null;
    int encKeyId = 0;
    String encSymmAlgo = null;
    String encKeyTransport = null;
    String encUser = null;
    Vector encryptParts = new Vector();
    X509Certificate encCert = null;
    static final String DEPLOYMENT = "deployment";
    static final String CLIENT_DEPLOYMENT = "client";
    static final String SERVER_DEPLOYMENT = "server";
    static /* synthetic */ Class class$org$apache$ws$security$handler$WSS4JHandler;

    public void init(HandlerInfo hi) {
        this.handlerInfo = hi;
    }

    public void destroy() {
    }

    public QName[] getHeaders() {
        return this.handlerInfo.getHeaders();
    }

    private void initialize() {
        this.signatureParts.removeAllElements();
        this.encryptParts.removeAllElements();
    }

    public boolean handleRequest(MessageContext mc) {
        return this.processMessage(mc, true);
    }

    public boolean handleResponse(MessageContext mc) {
        return this.processMessage(mc, false);
    }

    public boolean processMessage(MessageContext mc, boolean messageType) {
        String deployment = null;
        deployment = (String)this.handlerInfo.getHandlerConfig().get(DEPLOYMENT);
        if (deployment == null) {
            deployment = (String)this.msgContext.getProperty(DEPLOYMENT);
        }
        if (deployment == null) {
            throw new JAXRPCException("WSS4JHandler.processMessage: No deployment defined");
        }
        if (deployment.equals(CLIENT_DEPLOYMENT) ^ messageType) {
            return this.doReceiver(mc);
        }
        return this.doSender(mc);
    }

    public boolean doSender(MessageContext mc) {
        this.msgContext = (SOAPMessageContext)mc;
        this.initialize();
        this.noSerialization = false;
        Vector actions2 = new Vector();
        String action = null;
        action = (String)this.handlerInfo.getHandlerConfig().get("action");
        if (action == null) {
            action = (String)this.msgContext.getProperty("action");
        }
        if (action == null) {
            throw new JAXRPCException("WSS4JHandler: No action defined");
        }
        int doAction = WSS4JHandler.decodeAction(action, actions2);
        if (doAction == 0) {
            return true;
        }
        boolean mu = this.decodeMustUnderstand();
        this.actor = (String)this.handlerInfo.getHandlerConfig().get("actor");
        if (this.actor == null) {
            this.actor = (String)this.msgContext.getProperty("actor");
        }
        this.username = (String)this.handlerInfo.getHandlerConfig().get("user");
        if (this.username == null || this.username.equals("")) {
            this.username = (String)this.msgContext.getProperty("user");
            this.msgContext.setProperty("user", null);
        }
        if ((doAction & 0x43) != 0 && (this.username == null || this.username.equals(""))) {
            throw new JAXRPCException("WSS4JHandler: Empty username for specified action");
        }
        if (this.doDebug) {
            log.debug("Action: " + doAction);
            log.debug("Actor: " + this.actor + ", mu: " + mu);
        }
        Document doc = null;
        SOAPMessage message = this.msgContext.getMessage();
        SOAPPart sPart = message.getSOAPPart();
        doc = (Document)this.msgContext.getProperty("SND_SECURTIY");
        if (doc == null) {
            try {
                doc = WSS4JHandler.messageToDocument(message);
            }
            catch (Exception e) {
                throw new JAXRPCException("WSS4JHandler: cannot get SOAP envlope from message" + e);
            }
        }
        this.soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        if ((doAction & 1) == 1) {
            this.decodeUTParameter();
        }
        if ((doAction & 0x40) == 64) {
            this.decodeUTParameter();
            this.decodeSignatureParameter();
        }
        if ((doAction & 2) == 2) {
            this.decodeSignatureParameter();
        }
        if ((doAction & 0x10) == 16) {
            this.decodeSignatureParameter();
        }
        if ((doAction & 4) == 4) {
            this.encCrypto = this.loadEncryptionCrypto();
            this.decodeEncryptionParameter();
        }
        block16: for (int i = 0; i < actions2.size(); ++i) {
            int actionToDo = (Integer)actions2.get(i);
            if (this.doDebug) {
                log.debug("Performing Action: " + actionToDo);
            }
            switch (actionToDo) {
                case 1: {
                    this.performUTAction(actionToDo, mu, doc);
                    continue block16;
                }
                case 4: {
                    this.performENCRAction(mu, actionToDo, doc);
                    continue block16;
                }
                case 2: {
                    this.performSIGNAction(actionToDo, mu, doc);
                    continue block16;
                }
                case 16: {
                    this.performST_SIGNAction(actionToDo, mu, doc);
                    continue block16;
                }
                case 8: {
                    this.performSTAction(mu, doc);
                    continue block16;
                }
                case 32: {
                    this.performTSAction(mu, doc);
                    continue block16;
                }
                case 64: {
                    this.performUT_SIGNAction(actionToDo, mu, doc);
                    continue block16;
                }
                case 256: {
                    this.noSerialization = true;
                }
            }
        }
        if (this.noSerialization) {
            this.msgContext.setProperty("SND_SECURTIY", doc);
        } else {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            WSS4JHandler.documentToStream(doc, os);
            try {
                sPart.setContent(new StreamSource(new ByteArrayInputStream(os.toByteArray())));
            }
            catch (SOAPException se) {
                throw new JAXRPCException("Couldn't set content on SOAPPart" + se.getMessage());
            }
            if (this.doDebug) {
                String osStr = null;
                try {
                    osStr = os.toString("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    osStr = os.toString();
                }
                log.debug("Send request:");
                log.debug(osStr);
            }
            this.msgContext.setProperty("SND_SECURTIY", null);
        }
        if (this.doDebug) {
            log.debug("WSS4JHandler: exit invoke()");
        }
        return true;
    }

    public boolean doReceiver(MessageContext mc) {
        Timestamp timestamp;
        X509Certificate returnCert;
        this.msgContext = (SOAPMessageContext)mc;
        Vector actions2 = new Vector();
        String action = null;
        action = (String)this.handlerInfo.getHandlerConfig().get("action");
        if (action == null) {
            action = (String)this.msgContext.getProperty("action");
        }
        if (action == null) {
            throw new JAXRPCException("WSS4JHandler: No action defined");
        }
        int doAction = WSS4JHandler.decodeAction(action, actions2);
        String actor = (String)this.handlerInfo.getHandlerConfig().get("actor");
        SOAPMessage message = this.msgContext.getMessage();
        SOAPPart sPart = message.getSOAPPart();
        Document doc = null;
        try {
            doc = WSS4JHandler.messageToDocument(message);
        }
        catch (Exception ex) {
            throw new JAXRPCException("WSS4JHandler: cannot convert into document", ex);
        }
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        if (WSSecurityUtil.findElement(doc.getDocumentElement(), "Fault", soapConstants.getEnvelopeURI()) != null) {
            return false;
        }
        CallbackHandler cbHandler = null;
        if ((doAction & 5) != 0) {
            cbHandler = this.getPasswordCB();
        }
        if ((doAction & 2) == 2) {
            this.decodeSignatureParameter();
        }
        if ((doAction & 4) == 4) {
            this.decodeDecryptionParameter();
        }
        Vector wsResult = null;
        try {
            wsResult = secEngine.processSecurityHeader(doc, actor, cbHandler, this.sigCrypto, this.decCrypto);
        }
        catch (WSSecurityException ex) {
            ex.printStackTrace();
            throw new JAXRPCException("WSS4JHandler: security processing failed", ex);
        }
        if (wsResult == null) {
            if (doAction == 0) {
                return true;
            }
            throw new JAXRPCException("WSS4JHandler: Request does not contain required Security header");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WSS4JHandler.documentToStream(doc, os);
        try {
            sPart.setContent(new StreamSource(new ByteArrayInputStream(os.toByteArray())));
        }
        catch (SOAPException se) {
            throw new JAXRPCException("Couldn't set content on SOAPPart" + se.getMessage());
        }
        if (this.doDebug) {
            log.debug("Processed received SOAP request");
        }
        SOAPHeader sHeader = null;
        try {
            sHeader = message.getSOAPPart().getEnvelope().getHeader();
        }
        catch (Exception ex) {
            throw new JAXRPCException("WSS4JHandler: cannot get SOAP header after security processing", ex);
        }
        Iterator headers = sHeader.examineHeaderElements(actor);
        SOAPHeaderElement headerElement = null;
        while (headers.hasNext()) {
            SOAPHeaderElement hE = (SOAPHeaderElement)headers.next();
            if (!hE.getElementName().getLocalName().equals("Security") || !hE.getNamespaceURI().equals(WSConstants.WSSE_NS)) continue;
            headerElement = hE;
            break;
        }
        headerElement.setMustUnderstand(false);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(wsResult, 2);
        if (actionResult != null && (returnCert = actionResult.getCertificate()) != null && !this.verifyTrust(returnCert)) {
            throw new JAXRPCException("WSS4JHandler: The certificate used for the signature is not trusted");
        }
        actionResult = WSSecurityUtil.fetchActionResult(wsResult, 32);
        if (actionResult != null && (timestamp = actionResult.getTimestamp()) != null) {
            String ttl = null;
            ttl = (String)this.handlerInfo.getHandlerConfig().get("timeToLive");
            if (ttl == null) {
                ttl = (String)this.msgContext.getProperty("timeToLive");
            }
            int ttl_i = 0;
            if (ttl != null) {
                try {
                    ttl_i = Integer.parseInt(ttl);
                }
                catch (NumberFormatException e) {
                    ttl_i = this.timeToLive;
                }
            }
            if (ttl_i <= 0) {
                ttl_i = this.timeToLive;
            }
            if (!this.verifyTimestamp(timestamp, this.timeToLive)) {
                throw new JAXRPCException("WSS4JHandler: The timestamp could not be validated");
            }
        }
        int resultActions = wsResult.size();
        int size = actions2.size();
        if (size != resultActions) {
            throw new JAXRPCException("WSS4JHandler: security processing failed (actions number mismatch)");
        }
        for (int i = 0; i < size; ++i) {
            if (((Integer)actions2.get(i)).intValue() == ((WSSecurityEngineResult)wsResult.get(i)).getAction()) continue;
            throw new JAXRPCException("WSS4JHandler: security processing failed (actions mismatch)");
        }
        Vector<WSHandlerResult> results = null;
        results = (Vector<WSHandlerResult>)mc.getProperty("RECV_RESULTS");
        if (results == null) {
            results = new Vector<WSHandlerResult>();
            mc.setProperty("RECV_RESULTS", results);
        }
        WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
        results.add(0, rResult);
        if (this.doDebug) {
            log.debug("WSS4JHandler: exit invoke()");
        }
        return true;
    }

    private void performSIGNAction(int actionToDo, boolean mu, Document doc) throws JAXRPCException {
        String password = this.getPassword(this.username, actionToDo, "passwordCallbackClass", "passwordCallbackRef").getPassword();
        WSSignEnvelope wsSign = new WSSignEnvelope(this.actor, mu);
        if (this.sigKeyId != 0) {
            wsSign.setKeyIdentifierType(this.sigKeyId);
        }
        if (this.sigAlgorithm != null) {
            wsSign.setSignatureAlgorithm(this.sigAlgorithm);
        }
        wsSign.setUserInfo(this.username, password);
        if (this.signatureParts.size() > 0) {
            wsSign.setParts(this.signatureParts);
        }
        try {
            wsSign.build(doc, this.sigCrypto);
        }
        catch (WSSecurityException e) {
            throw new JAXRPCException("WSS4JHandler: Signature: error during message procesing" + e);
        }
    }

    public static String parseToString(Node node) throws JAXRPCException {
        StringBuffer buffer = new StringBuffer();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter stringWriter = new StringWriter(128);
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
            buffer = stringWriter.getBuffer();
        }
        catch (TransformerException te) {
            throw new JAXRPCException("WSS4JHandler: couldn't convert Node into String: ", te);
        }
        return buffer.toString();
    }

    private CallbackHandler getPasswordCB() throws JAXRPCException {
        String callback = null;
        CallbackHandler cbHandler = null;
        callback = (String)this.handlerInfo.getHandlerConfig().get("passwordCallbackClass");
        if (callback == null) {
            callback = (String)this.msgContext.getProperty("passwordCallbackClass");
        }
        if (callback != null) {
            Class<?> cbClass = null;
            try {
                cbClass = Class.forName(callback);
            }
            catch (ClassNotFoundException e) {
                throw new JAXRPCException("WSS4JHandler: cannot load password callback class: " + callback, e);
            }
            try {
                cbHandler = (CallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new JAXRPCException("WSS4JHandler: cannot create instance of password callback: " + callback, e);
            }
        }
        cbHandler = (CallbackHandler)this.msgContext.getProperty("passwordCallbackRef");
        if (cbHandler == null) {
            throw new JAXRPCException("WSS4JHandler: no reference in callback property");
        }
        return cbHandler;
    }

    private boolean verifyTrust(X509Certificate cert) throws JAXRPCException {
        X509Certificate[] certs;
        if (cert == null) {
            return false;
        }
        String[] aliases = null;
        String alias = null;
        String subjectString = cert.getSubjectDN().getName();
        String issuerString = cert.getIssuerDN().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        if (this.doDebug) {
            log.debug("WSS4JHandler: Transmitted certificate has subject " + subjectString);
            log.debug("WSS4JHandler: Transmitted certificate has issuer " + issuerString + " (serial " + issuerSerial + ")");
        }
        try {
            alias = this.sigCrypto.getAliasForX509Cert(issuerString, issuerSerial);
        }
        catch (WSSecurityException ex) {
            throw new JAXRPCException("WSS4JHandler: Could not get alias for certificate with " + subjectString, ex);
        }
        if (alias != null) {
            try {
                certs = this.sigCrypto.getCertificates(alias);
            }
            catch (WSSecurityException ex) {
                throw new JAXRPCException("WSS4JHandler: Could not get certificates for alias " + alias, ex);
            }
            if (certs != null && certs.length > 0 && cert.equals(certs[0])) {
                if (this.doDebug) {
                    log.debug("Direct trust for certificate with " + subjectString);
                }
                return true;
            }
        } else if (this.doDebug) {
            log.debug("No alias found for subject from issuer with " + issuerString + " (serial " + issuerSerial + ")");
        }
        try {
            aliases = this.sigCrypto.getAliasesForDN(issuerString);
        }
        catch (WSSecurityException ex) {
            throw new JAXRPCException("WSS4JHandler: Could not get alias for certificate with " + issuerString, ex);
        }
        if (aliases == null || aliases.length < 1) {
            if (this.doDebug) {
                log.debug("No aliases found in keystore for issuer " + issuerString + " of certificate for " + subjectString);
            }
            return false;
        }
        for (int i = 0; i < aliases.length; ++i) {
            alias = aliases[i];
            if (this.doDebug) {
                log.debug("Preparing to validate certificate path with alias " + alias + " for issuer " + issuerString);
            }
            try {
                certs = this.sigCrypto.getCertificates(alias);
            }
            catch (WSSecurityException ex) {
                throw new JAXRPCException("WSS4JHandler: Could not get certificates for alias " + alias, ex);
            }
            if (certs == null | certs.length < 1) {
                throw new JAXRPCException("WSS4JHandler: Could not get certificates for alias " + alias);
            }
            X509Certificate[] x509certs = new X509Certificate[certs.length + 1];
            x509certs[0] = cert;
            for (int j = 0; j < certs.length; ++j) {
                x509certs[certs.length + j] = cert = certs[i];
            }
            certs = x509certs;
            try {
                if (!this.sigCrypto.validateCertPath(certs)) continue;
                if (this.doDebug) {
                    log.debug("WSS4JHandler: Certificate path has been verified for certificate with subject " + subjectString);
                }
                return true;
            }
            catch (WSSecurityException ex) {
                throw new JAXRPCException("WSS4JHandler: Certificate path verification failed for certificate with subject " + subjectString, ex);
            }
        }
        log.debug("WSS4JHandler: Certificate path could not be verified for certificate with subject " + subjectString);
        return false;
    }

    protected boolean verifyTimestamp(Timestamp timestamp, int timeToLive) throws JAXRPCException {
        Calendar validCreation = Calendar.getInstance();
        long currentTime = validCreation.getTimeInMillis();
        validCreation.setTimeInMillis(currentTime -= (long)(timeToLive * 1000));
        if (this.doDebug) {
            log.debug("Preparing to verify the timestamp");
            SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
            log.debug("Validation of Timestamp: Current time is " + zulu.format(Calendar.getInstance().getTime()));
            log.debug("Validation of Timestamp: Valid creation is " + zulu.format(validCreation.getTime()));
            log.debug("Validation of Timestamp: Timestamp created is " + zulu.format(timestamp.getCreated().getTime()));
        }
        if (!timestamp.getCreated().after(validCreation)) {
            if (this.doDebug) {
                log.debug("Validation of Timestamp: The message was created too long ago");
            }
            return false;
        }
        log.debug("Validation of Timestamp: Everything is ok");
        return true;
    }

    protected Crypto loadSignatureCrypto() throws JAXRPCException {
        Crypto crypto = null;
        this.sigPropFile = (String)this.handlerInfo.getHandlerConfig().get("signaturePropFile");
        if (this.sigPropFile == null) {
            this.sigPropFile = (String)this.msgContext.getProperty("signaturePropFile");
        }
        if (this.sigPropFile != null) {
            crypto = (Crypto)cryptos.get(this.sigPropFile);
            if (crypto == null) {
                crypto = CryptoFactory.getInstance(this.sigPropFile);
                cryptos.put(this.sigPropFile, crypto);
            }
        } else {
            throw new JAXRPCException("WSS4JHandler: Signature: no crypto property file");
        }
        return crypto;
    }

    protected Crypto loadDecryptionCrypto() throws JAXRPCException {
        Crypto crypto = null;
        this.decPropFile = (String)this.handlerInfo.getHandlerConfig().get("decryptionPropFile");
        if (this.decPropFile == null) {
            this.decPropFile = (String)this.msgContext.getProperty("decryptionPropFile");
        }
        if (this.decPropFile != null) {
            crypto = (Crypto)cryptos.get(this.decPropFile);
            if (crypto == null) {
                crypto = CryptoFactory.getInstance(this.decPropFile);
                cryptos.put(this.decPropFile, crypto);
            }
        } else {
            crypto = this.sigCrypto;
            if (crypto == null) {
                throw new JAXRPCException("WSS4JHandler: Encryption: no crypto property file");
            }
        }
        return crypto;
    }

    private void decodeSignatureParameter() throws JAXRPCException {
        this.sigCrypto = this.loadSignatureCrypto();
        String tmpS = null;
        tmpS = (String)this.handlerInfo.getHandlerConfig().get("signatureKeyIdentifier");
        if (tmpS == null) {
            tmpS = (String)this.msgContext.getProperty("signatureKeyIdentifier");
        }
        if (tmpS != null) {
            Integer I = (Integer)WSHandlerConstants.keyIdentifier.get(tmpS);
            if (I == null) {
                throw new JAXRPCException("WSS4JHandler: Signature: unknown key identification");
            }
            this.sigKeyId = I;
            if (this.sigKeyId != 2 && this.sigKeyId != 1 && this.sigKeyId != 3 && this.sigKeyId != 4) {
                throw new JAXRPCException("WSS4JHandler: Signature: illegal key identification");
            }
        }
        if ((this.sigAlgorithm = (String)this.handlerInfo.getHandlerConfig().get("signatureAlgorithm")) == null) {
            tmpS = (String)this.msgContext.getProperty("signatureAlgorithm");
        }
        if ((tmpS = (String)this.handlerInfo.getHandlerConfig().get("signatureParts")) == null) {
            tmpS = (String)this.msgContext.getProperty("signatureParts");
        }
        if (tmpS != null) {
            this.splitEncParts(tmpS, this.signatureParts);
        }
    }

    private void decodeDecryptionParameter() throws JAXRPCException {
        this.decCrypto = this.loadDecryptionCrypto();
    }

    public boolean handleFault(MessageContext mc) {
        if (this.doDebug) {
            log.debug("Entered handleFault");
        }
        return true;
    }

    private void performENCRAction(boolean mu, int actionToDo, Document doc) throws JAXRPCException {
        WSEncryptBody wsEncrypt = new WSEncryptBody(this.actor, mu);
        if (this.encKeyId != 0) {
            wsEncrypt.setKeyIdentifierType(this.encKeyId);
        }
        if (this.encKeyId == 5) {
            String encKeyName = null;
            encKeyName = (String)this.handlerInfo.getHandlerConfig().get("EmbeddedKeyName");
            if (encKeyName == null) {
                encKeyName = (String)this.msgContext.getProperty("EmbeddedKeyName");
            }
            wsEncrypt.setEmbeddedKeyName(encKeyName);
            byte[] embeddedKey = this.getPassword(this.encUser, actionToDo, "EmbeddedKeyCallbackClass", "EmbeddedKeyCallbackRef").getKey();
            wsEncrypt.setKey(embeddedKey);
        }
        if (this.encSymmAlgo != null) {
            wsEncrypt.setSymmetricEncAlgorithm(this.encSymmAlgo);
        }
        if (this.encKeyTransport != null) {
            wsEncrypt.setKeyEnc(this.encKeyTransport);
        }
        wsEncrypt.setUserInfo(this.encUser);
        wsEncrypt.setUseThisCert(this.encCert);
        if (this.encryptParts.size() > 0) {
            wsEncrypt.setParts(this.encryptParts);
        }
        try {
            wsEncrypt.build(doc, this.encCrypto);
        }
        catch (WSSecurityException e) {
            throw new JAXRPCException("WSS4JHandler: Encryption: error during message processing" + e);
        }
    }

    private void performUTAction(int actionToDo, boolean mu, Document doc) throws JAXRPCException {
        String password = this.getPassword(this.username, actionToDo, "passwordCallbackClass", "passwordCallbackRef").getPassword();
        WSSAddUsernameToken builder = new WSSAddUsernameToken(this.actor, mu);
        builder.setPasswordType(this.pwType);
        builder.build(doc, this.username, password);
        if (this.utElements != null && this.utElements.length > 0) {
            for (int j = 0; j < this.utElements.length; ++j) {
                this.utElements[j].trim();
                if (this.utElements[j].equals("Nonce")) {
                    builder.addNonce(doc);
                }
                if (!this.utElements[j].equals("Created")) continue;
                builder.addCreated(doc);
            }
        }
    }

    private void performUT_SIGNAction(int actionToDo, boolean mu, Document doc) throws JAXRPCException {
        String password = this.getPassword(this.username, actionToDo, "passwordCallbackClass", "passwordCallbackRef").getPassword();
        WSSAddUsernameToken builder = new WSSAddUsernameToken(this.actor, mu);
        builder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        builder.preSetUsernameToken(doc, this.username, password);
        builder.addCreated(doc);
        builder.addNonce(doc);
        WSSignEnvelope sign = new WSSignEnvelope(this.actor, mu);
        sign.setUsernameToken(builder);
        if (this.signatureParts.size() > 0) {
            sign.setParts(this.signatureParts);
        }
        sign.setKeyIdentifierType(7);
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        try {
            sign.build(doc, null);
        }
        catch (WSSecurityException e) {
            throw new JAXRPCException("WSS4JHandler: Error during Signatur with UsernameToken secret" + e);
        }
        builder.build(doc, null, null);
    }

    private void performSTAction(boolean mu, Document doc) throws JAXRPCException {
        WSSAddSAMLToken builder = new WSSAddSAMLToken(this.actor, mu);
        String samlPropFile = null;
        samlPropFile = (String)this.handlerInfo.getHandlerConfig().get("samlPropFile");
        if (samlPropFile == null) {
            samlPropFile = (String)this.msgContext.getProperty("samlPropFile");
        }
        SAMLIssuer saml = SAMLIssuerFactory.getInstance(samlPropFile);
        saml.setUsername(this.username);
        SAMLAssertion assertion = saml.newAssertion();
        builder.build(doc, assertion);
    }

    private void performST_SIGNAction(int actionToDo, boolean mu, Document doc) throws JAXRPCException {
        String samlPropFile = null;
        samlPropFile = (String)this.handlerInfo.getHandlerConfig().get("samlPropFile");
        if (samlPropFile == null) {
            samlPropFile = (String)this.msgContext.getProperty("samlPropFile");
        }
        Crypto crypto = null;
        crypto = this.loadSignatureCrypto();
        SAMLIssuer saml = SAMLIssuerFactory.getInstance(samlPropFile);
        saml.setUsername(this.username);
        saml.setUserCrypto(crypto);
        saml.setInstanceDoc(doc);
        SAMLAssertion assertion = saml.newAssertion();
        if (assertion == null) {
            throw new JAXRPCException("WSS4JHandler: Signed SAML: no SAML token received");
        }
        String issuerKeyName = null;
        String issuerKeyPW = null;
        Crypto issuerCrypto = null;
        WSSignEnvelope wsSign = new WSSignEnvelope(this.actor, mu);
        String password = null;
        if (saml.isSenderVouches()) {
            issuerKeyName = saml.getIssuerKeyName();
            issuerKeyPW = saml.getIssuerKeyPassword();
            issuerCrypto = saml.getIssuerCrypto();
        } else {
            password = this.getPassword(this.username, actionToDo, "passwordCallbackClass", "passwordCallbackRef").getPassword();
            wsSign.setUserInfo(this.username, password);
        }
        if (this.sigKeyId != 0) {
            wsSign.setKeyIdentifierType(this.sigKeyId);
        }
        try {
            wsSign.build(doc, crypto, assertion, issuerCrypto, issuerKeyName, issuerKeyPW);
        }
        catch (WSSecurityException e) {
            throw new JAXRPCException("WSS4JHandler: Signed SAML: error during message processing" + e);
        }
    }

    private void performTSAction(boolean mu, Document doc) throws JAXRPCException {
        String ttl = null;
        ttl = (String)this.handlerInfo.getHandlerConfig().get("timeToLive");
        if (ttl == null) {
            ttl = (String)this.msgContext.getProperty("timeToLive");
        }
        int ttl_i = 0;
        if (ttl != null) {
            try {
                ttl_i = Integer.parseInt(ttl);
            }
            catch (NumberFormatException e) {
                ttl_i = this.timeToLive;
            }
        }
        if (ttl_i <= 0) {
            ttl_i = this.timeToLive;
        }
        WSAddTimestamp timeStampBuilder = new WSAddTimestamp(this.actor, mu);
        timeStampBuilder.build(doc, ttl_i);
    }

    public static int decodeAction(String action, Vector actions2) throws JAXRPCException {
        int doAction = 0;
        if (action == null) {
            return doAction;
        }
        String[] single = StringUtil.split(action, ' ');
        for (int i = 0; i < single.length; ++i) {
            if (single[i].equals("NoSecurity")) {
                doAction = 0;
                return doAction;
            }
            if (single[i].equals("UsernameToken")) {
                doAction |= 1;
                actions2.add(new Integer(1));
                continue;
            }
            if (single[i].equals("Signature")) {
                doAction |= 2;
                actions2.add(new Integer(2));
                continue;
            }
            if (single[i].equals("Encrypt")) {
                doAction |= 4;
                actions2.add(new Integer(4));
                continue;
            }
            if (single[i].equals("SAMLTokenUnsigned")) {
                doAction |= 8;
                actions2.add(new Integer(8));
                continue;
            }
            if (single[i].equals("SAMLTokenSigned")) {
                doAction |= 0x10;
                actions2.add(new Integer(16));
                continue;
            }
            if (single[i].equals("Timestamp")) {
                doAction |= 0x20;
                actions2.add(new Integer(32));
                continue;
            }
            if (single[i].equals("NoSerialization")) {
                doAction |= 0x100;
                actions2.add(new Integer(256));
                continue;
            }
            if (single[i].equals("UsernameTokenSignature")) {
                doAction |= 0x40;
                actions2.add(new Integer(64));
                continue;
            }
            throw new JAXRPCException("WSS4JHandler: Unknown action defined" + single[i]);
        }
        return doAction;
    }

    private boolean decodeMustUnderstand() throws JAXRPCException {
        boolean mu = true;
        String mustUnderstand = null;
        mustUnderstand = (String)this.handlerInfo.getHandlerConfig().get("mustUnderstand");
        if (mustUnderstand == null) {
            mustUnderstand = (String)this.msgContext.getProperty("mustUnderstand");
        }
        if (mustUnderstand != null) {
            if (mustUnderstand.equals("0") || mustUnderstand.equals("false")) {
                mu = false;
            } else if (mustUnderstand.equals("1") || mustUnderstand.equals("true")) {
                mu = true;
            } else {
                throw new JAXRPCException("WSS4JHandler: illegal mustUnderstand parameter");
            }
        }
        return mu;
    }

    private void decodeUTParameter() throws JAXRPCException {
        this.pwType = (String)this.handlerInfo.getHandlerConfig().get("passwordType");
        if (this.pwType == null) {
            this.pwType = (String)this.msgContext.getProperty("passwordType");
        }
        if (this.pwType != null) {
            this.pwType = this.pwType.equals("PasswordText") ? "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText" : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
        }
        String tmpS = null;
        tmpS = (String)this.handlerInfo.getHandlerConfig().get("addUTElements");
        if (tmpS == null) {
            tmpS = (String)this.msgContext.getProperty("addUTElements");
        }
        if (tmpS != null) {
            this.utElements = StringUtil.split(tmpS, ' ');
        }
    }

    protected Crypto loadEncryptionCrypto() throws JAXRPCException {
        Crypto crypto = null;
        String encPropFile = null;
        encPropFile = (String)this.handlerInfo.getHandlerConfig().get("encryptionPropFile");
        if (encPropFile == null) {
            encPropFile = (String)this.msgContext.getProperty("encryptionPropFile");
        }
        if (encPropFile != null) {
            crypto = (Crypto)cryptos.get(encPropFile);
            if (crypto == null) {
                crypto = CryptoFactory.getInstance(encPropFile);
                cryptos.put(encPropFile, crypto);
            }
        } else {
            crypto = this.sigCrypto;
            if (crypto == null) {
                throw new JAXRPCException("WSS4JHandler: Encryption: no crypto property file");
            }
        }
        return crypto;
    }

    private void decodeEncryptionParameter() throws JAXRPCException {
        this.encUser = (String)this.handlerInfo.getHandlerConfig().get("encryptionUser");
        if (this.encUser == null) {
            this.encUser = (String)this.msgContext.getProperty("encryptionUser");
        }
        if (this.encUser == null && (this.encUser = this.username) == null) {
            throw new JAXRPCException("WSS4JHandler: Encryption: no username");
        }
        this.handleSpecialUser(this.encUser);
        String tmpS = null;
        tmpS = (String)this.handlerInfo.getHandlerConfig().get("encryptionKeyIdentifier");
        if (tmpS == null) {
            tmpS = (String)this.msgContext.getProperty("encryptionKeyIdentifier");
        }
        if (tmpS != null) {
            Integer I = (Integer)WSHandlerConstants.keyIdentifier.get(tmpS);
            if (I == null) {
                throw new JAXRPCException("WSS4JHandler: Encryption: unknown key identification");
            }
            this.encKeyId = I;
            if (this.encKeyId != 2 && this.encKeyId != 3 && this.encKeyId != 4 && this.encKeyId != 1 && this.encKeyId != 5) {
                throw new JAXRPCException("WSS4JHandler: Encryption: illegal key identification");
            }
        }
        if ((this.encSymmAlgo = (String)this.handlerInfo.getHandlerConfig().get("encryptionSymAlgorithm")) == null) {
            this.encSymmAlgo = (String)this.msgContext.getProperty("encryptionSymAlgorithm");
        }
        if ((this.encKeyTransport = (String)this.handlerInfo.getHandlerConfig().get("encryptionKeyTransportAlgorithm")) == null) {
            this.encKeyTransport = (String)this.msgContext.getProperty("encryptionKeyTransportAlgorithm");
        }
        if ((tmpS = (String)this.handlerInfo.getHandlerConfig().get("encryptionParts")) == null) {
            tmpS = (String)this.msgContext.getProperty("encryptionParts");
        }
        if (tmpS != null) {
            this.splitEncParts(tmpS, this.encryptParts);
        }
    }

    private void handleSpecialUser(String encUser) {
        if (!"useReqSigCert".equals(encUser)) {
            return;
        }
        Vector results = null;
        results = (Vector)this.msgContext.getProperty("RECV_RESULTS");
        if (results == null) {
            return;
        }
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            String hActor = rResult.getActor();
            if (!WSSecurityUtil.isActorEqual(this.actor, hActor)) continue;
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                if (wser.getAction() != 2) continue;
                this.encCert = wser.getCertificate();
                return;
            }
        }
    }

    private void splitEncParts(String tmpS, Vector encryptParts) throws JAXRPCException {
        WSEncryptionPart encPart = null;
        String[] rawParts = StringUtil.split(tmpS, ';');
        for (int i = 0; i < rawParts.length; ++i) {
            String[] partDef = StringUtil.split(rawParts[i], '}');
            if (partDef.length == 1) {
                if (this.doDebug) {
                    log.debug("single partDef: '" + partDef[0] + "'");
                }
                encPart = new WSEncryptionPart(partDef[0].trim(), this.soapConstants.getEnvelopeURI(), "Content");
            } else if (partDef.length == 3) {
                String mode = partDef[0].trim();
                mode = mode.length() <= 1 ? "Content" : mode.substring(1);
                String nmSpace = partDef[1].trim();
                nmSpace = nmSpace.length() <= 1 ? this.soapConstants.getEnvelopeURI() : nmSpace.substring(1);
                String element = partDef[2].trim();
                if (this.doDebug) {
                    log.debug("partDefs: '" + mode + "' ,'" + nmSpace + "' ,'" + element + "'");
                }
                encPart = new WSEncryptionPart(element, nmSpace, mode);
            } else {
                throw new JAXRPCException("WSS4JHandler: wrong part definition: " + tmpS);
            }
            encryptParts.add(encPart);
        }
    }

    private WSPasswordCallback getPassword(String username, int doAction, String clsProp, String refProp) throws JAXRPCException {
        WSPasswordCallback pwCb = null;
        String password = null;
        String callback = null;
        CallbackHandler cbHandler = null;
        callback = (String)this.handlerInfo.getHandlerConfig().get(clsProp);
        if (callback == null) {
            callback = (String)this.msgContext.getProperty(clsProp);
        }
        if (callback != null) {
            pwCb = this.readPwViaCallbackClass(callback, username, doAction);
            if (pwCb.getPassword() == null && pwCb.getKey() == null) {
                throw new JAXRPCException("WSS4JHandler: password callback class provided null or empty password");
            }
        } else {
            cbHandler = (CallbackHandler)this.msgContext.getProperty(refProp);
            if (cbHandler != null) {
                pwCb = this.performCallback(cbHandler, username, doAction);
                if (pwCb.getPassword() == null && pwCb.getKey() == null) {
                    throw new JAXRPCException("WSS4JHandler: password callback provided null or empty password");
                }
            } else {
                password = (String)this.msgContext.getProperty("javax.xml.rpc.security.auth.password");
                if (password == null) {
                    throw new JAXRPCException("WSS4JHandler: application provided null or empty password");
                }
                this.msgContext.setProperty("javax.xml.rpc.security.auth.password", null);
                pwCb = new WSPasswordCallback("", 0);
                pwCb.setPassword(password);
            }
        }
        return pwCb;
    }

    private WSPasswordCallback readPwViaCallbackClass(String callback, String username, int doAction) throws JAXRPCException {
        Class<?> cbClass = null;
        CallbackHandler cbHandler = null;
        try {
            cbClass = Class.forName(callback);
        }
        catch (ClassNotFoundException e) {
            throw new JAXRPCException("WSS4JHandler: cannot load password callback class: " + callback, e);
        }
        try {
            cbHandler = (CallbackHandler)cbClass.newInstance();
        }
        catch (Exception e) {
            throw new JAXRPCException("WSS4JHandler: cannot create instance of password callback: " + callback, e);
        }
        return this.performCallback(cbHandler, username, doAction);
    }

    private WSPasswordCallback performCallback(CallbackHandler cbHandler, String username, int doAction) throws JAXRPCException {
        WSPasswordCallback pwCb = null;
        int reason = 0;
        switch (doAction) {
            case 1: 
            case 64: {
                reason = 2;
                break;
            }
            case 2: {
                reason = 3;
                break;
            }
            case 4: {
                reason = 4;
            }
        }
        pwCb = new WSPasswordCallback(username, reason);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cbHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new JAXRPCException("WSS4JHandler: password callback failed", e);
        }
        return pwCb;
    }

    public static Document messageToDocument(SOAPMessage message) {
        Document doc = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.writeTo(baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            doc = builder.parse(bais);
        }
        catch (Exception ex) {
            throw new JAXRPCException("messageToDocument: cannot convert SOAPMessage into Document", ex);
        }
        return doc;
    }

    public static void documentToStream(Document doc, OutputStream os) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StreamResult result = new StreamResult(os);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
        }
        catch (Exception ex) {
            throw new JAXRPCException("documentToStream : cannot convert document into stream", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

