/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.secureconv;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.signature.GssSignedSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityFault;

public class SignHandler
extends GenericHandler {
    protected static I18n i18n = I18n.getI18n("org.globus.wsrf.impl.security.authentication.errors");
    protected static Log log = LogFactory.getLog(SignHandler.class.getName());

    public boolean handleRequest(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleResponse(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleMessage(SOAPMessageContext ctx) {
        SecurityContext secContext = (SecurityContext)ctx.getProperty("org.globus.security.secureconv.context");
        if (secContext == null) {
            log.debug("No context - not signing.");
            return true;
        }
        SOAPMessage msg = ctx.getMessage();
        if (msg == null) {
            log.debug("No message - not signing.");
            return true;
        }
        log.debug("Enter: sign");
        SOAPMessage signedMsg = null;
        try {
            SOAPEnvelope unsignedEnvelope = msg.getSOAPPart().getEnvelope();
            GssSignedSOAPEnvelopeBuilder builder = new GssSignedSOAPEnvelopeBuilder(ctx, secContext.getContext(), (String)secContext.getID());
            builder.setActor((String)ctx.getProperty("gssActor"));
            signedMsg = builder.buildMessage(unsignedEnvelope);
        }
        catch (Exception e) {
            log.error(i18n.getMessage("signErr"), e);
            throw WSSecurityFault.makeFault(e);
        }
        ctx.setMessage(signedMsg);
        log.debug("Exit: sign");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }
}

