/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.virtualplatform.image;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.virtualplatform.image.PlatformConfiguration;

public final class Platforms {
    private static GCUBELog logger = new GCUBELog(Platforms.class);

    public static List<PlatformConfiguration> listAvailablePlatforms(File configFolder) {
        if (!configFolder.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<PlatformConfiguration> platforms = new ArrayList<PlatformConfiguration>();
        Platforms.scanFolder(configFolder, platforms);
        return Collections.unmodifiableList(platforms);
    }

    private static void scanFolder(File folder, List<PlatformConfiguration> platforms) {
        logger.debug((Object)("Scanning folder " + folder.getAbsolutePath()));
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                Platforms.scanFolder(file, platforms);
                continue;
            }
            if (!file.getAbsolutePath().endsWith(".properties") && !file.getAbsolutePath().endsWith(".props")) continue;
            try {
                platforms.add(Platforms.readConfig(file));
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.warn((Object)("Failed to load a platform config from properties file " + file.getAbsolutePath()));
            }
        }
    }

    private static PlatformConfiguration readConfig(File file) throws Exception {
        logger.debug((Object)("Trying to load a platform from " + file.getAbsolutePath()));
        PlatformConfiguration configuration = new PlatformConfiguration();
        FileInputStream stream = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(stream);
        configuration.setName((String)Platforms.getPropertyValue(properties, "Name"));
        logger.debug((Object)("Found configuration for platform " + configuration.getName()));
        configuration.setVersion(Short.valueOf((String)Platforms.getPropertyValue(properties, "Version")));
        configuration.setPlatformClass((String)Platforms.getPropertyValue(properties, "PlatformClass"));
        String[] resources = ((String)Platforms.getPropertyValue(properties, "Resources")).split(",");
        ArrayList<File> resourceFiles = new ArrayList<File>();
        for (int i = 0; i < resources.length; ++i) {
            resourceFiles.add(new File(file.getParentFile().getAbsolutePath() + File.separator + resources[i]));
        }
        configuration.setFolder(file.getParentFile());
        Platforms.scanFolderForResources(configuration.getFolder(), resourceFiles);
        logger.trace((Object)("Resources found: " + ((Object)resourceFiles).toString()));
        configuration.setResources(resourceFiles.toArray(new File[0]));
        configuration.setRequireDedicatedClassloader(Boolean.valueOf((String)Platforms.getPropertyValue(properties, "DedicatedClassLoader")));
        configuration.setBaseURL(new URL((String)Platforms.getPropertyValue(properties, "BaseURL")));
        configuration.setUser((String)Platforms.getPropertyValue(properties, "User"));
        configuration.setPassword((String)Platforms.getPropertyValue(properties, "Password"));
        ((InputStream)stream).close();
        return configuration;
    }

    private static Object getPropertyValue(Properties properties, String key) throws Exception {
        if (properties.get(key) == null) {
            throw new Exception("Configuration property " + key + " not found");
        }
        return properties.get(key);
    }

    private static void scanFolderForResources(File folder, List<File> resources) {
        logger.trace((Object)("Scanning folder " + folder.getAbsolutePath()));
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                Platforms.scanFolderForResources(file, resources);
                continue;
            }
            resources.add(file);
        }
    }
}

