/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.persistence;

import java.io.Serializable;
import java.util.HashMap;
import org.gcube.common.accounting.node.persistence.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopCallerData
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(TopCallerData.class);
    public static Long HOUR_INTERVAL_S = new Long(3600L);
    public static Long DAY_INTERVAL_S = HOUR_INTERVAL_S * 24L;
    public Long intervalXHour;
    public Long intervalXday;
    private static final long serialVersionUID = 1L;
    private long interval = 0L;
    private HashMap<String, HashMap<Long, Statistics>> callerMap = null;

    public TopCallerData(long interval) {
        this.interval = interval;
        this.intervalXHour = HOUR_INTERVAL_S / this.interval;
        this.intervalXday = DAY_INTERVAL_S / this.interval;
    }

    public HashMap<String, HashMap<Long, Statistics>> getCallerMap() {
        return this.callerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallerInfo(String caller, Long calls) throws Exception {
        if (this.callerMap == null) {
            this.callerMap = new HashMap();
        }
        HashMap<String, HashMap<Long, Statistics>> hashMap = this.callerMap;
        synchronized (hashMap) {
            HashMap<Object, Object> statMap = null;
            if (this.callerMap.get(caller) == null) {
                try {
                    statMap = new HashMap();
                    Statistics stat = new Statistics(this.intervalXHour);
                    stat.addAvg(calls);
                    Statistics statDay = new Statistics(this.intervalXday);
                    statDay.addAvg(calls);
                    statMap.put(this.intervalXHour, stat);
                    statMap.put(this.intervalXday, statDay);
                }
                catch (Exception e) {
                    logger.debug("Error creating top caller map Data for caller " + caller, (Throwable)e);
                    throw e;
                }
            }
            try {
                statMap = this.callerMap.get(caller);
                ((Statistics)statMap.get(this.intervalXHour)).addAvg(calls);
                ((Statistics)statMap.get(this.intervalXday)).addAvg(calls);
            }
            catch (Exception e) {
                logger.debug("Error updating top caller map Data for caller " + caller, (Throwable)e);
                throw e;
            }
            this.callerMap.put(caller, statMap);
        }
    }

    public TopCallerInfo getTopCallerInfo() {
        String callerHost = null;
        long maxCalls = 0L;
        for (String host : this.callerMap.keySet()) {
            if (this.callerMap.get(host).get(this.intervalXHour).getTotalCalls() < maxCalls) continue;
            maxCalls = this.callerMap.get(host).get(this.intervalXHour).getTotalCalls();
            callerHost = host;
        }
        return new TopCallerInfo(callerHost, maxCalls);
    }

    public Long getIntervalXHour() {
        return this.intervalXHour;
    }

    public void setIntervalXHour(Long intervalXHour) {
        this.intervalXHour = intervalXHour;
    }

    public Long getIntervalXday() {
        return this.intervalXday;
    }

    public void setIntervalXday(Long intervalXday) {
        this.intervalXday = intervalXday;
    }

    public class TopCallerInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String callerHost;
        private long totalCalls;

        public TopCallerInfo(String host, long totalCalls) {
            this.callerHost = host;
            this.totalCalls = totalCalls;
        }

        public String getCallerHost() {
            return this.callerHost;
        }

        public void setCallerHost(String callerHost) {
            this.callerHost = callerHost;
        }

        public long getTotalCalls() {
            return this.totalCalls;
        }

        public void setTotalCalls(long totalCall) {
            this.totalCalls = totalCall;
        }
    }
}

