/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.util.Collection;
import org.opensaml.BindingException;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLException;
import org.opensaml.XML;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SOAPException
extends BindingException
implements Cloneable {
    public static final QName CLIENT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client");
    public static final QName SERVER = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    public static final QName MUSTUNDERSTAND = new QName("http://schemas.xmlsoap.org/soap/envelope/", "MustUnderstand");
    public static final QName VERSION = new QName("http://schemas.xmlsoap.org/soap/envelope/", "VersionMismatch");

    protected SOAPException(Element element) throws SAMLException {
        super(element);
    }

    public SOAPException(String string) {
        super(string);
    }

    public SOAPException(String string, Exception exception) {
        super(string, exception);
    }

    public SOAPException(Collection collection, String string) {
        super(collection, string);
    }

    public SOAPException(Collection collection, Exception exception) {
        super(collection, exception);
    }

    public SOAPException(Collection collection, String string, Exception exception) {
        super(collection, string, exception);
    }

    public SOAPException(QName qName, String string) {
        super(qName, string);
    }

    public SOAPException(QName qName, Exception exception) {
        super(qName, exception);
    }

    public SOAPException(QName qName, String string, Exception exception) {
        super(qName, string, exception);
    }

    public void fromDOM(Element element) throws SAMLException {
        Node node;
        Node node2;
        if (element == null) {
            throw new MalformedException("SOAPException.fromDOM() given an empty DOM");
        }
        this.root = element;
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "http://schemas.xmlsoap.org/soap/envelope/", "Fault")) {
            throw new MalformedException(SAMLException.RESPONDER, "SOAPException.fromDOM() requires soap:Fault at root");
        }
        for (node2 = element.getFirstChild(); node2 != null && node2.getNodeType() != 1; node2 = node2.getNextSibling()) {
        }
        QName qName = QName.getQNameTextNode((Text)node2.getFirstChild());
        if (qName == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLException.fromDOM() unable to evaluate faultcode value");
        }
        this.codes.add(qName);
        for (node = node2.getNextSibling(); !(node == null || node.getNodeType() == 1 && XML.isElementNamed(element, null, "faultstring")); node = node.getNextSibling()) {
        }
        if (node != null) {
            this.msg = node.getFirstChild().getNodeValue();
        }
    }

    public Node toDOM(Document document) throws DOMException {
        if (this.root != null) {
            if (this.root.getOwnerDocument() != document) {
                this.root = document.importNode(this.root, true);
            }
        } else {
            Element element = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soap", "http://schemas.xmlsoap.org/soap/envelope/");
            Element element2 = document.createElementNS(null, "faultcode");
            if (this.codes == null || this.codes.isEmpty()) {
                element2.appendChild(document.createTextNode("soap:Server"));
            } else {
                element2.appendChild(document.createTextNode("soap:" + ((QName)this.codes.get(0)).getLocalName()));
            }
            element.appendChild(element2);
            if (this.getMessage() != null) {
                Element element3 = document.createElementNS(null, "faultstring");
                element3.appendChild(document.createTextNode(this.getMessage()));
                element.appendChild(element3);
            }
            this.root = element;
        }
        return this.root;
    }
}

