/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.store.buffer;

import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreAccessException;
import gr.uoa.di.madgik.grs.store.event.EventStoreFactory;
import gr.uoa.di.madgik.grs.store.event.GRS2EventStoreException;
import gr.uoa.di.madgik.grs.store.event.IEventStore;
import gr.uoa.di.madgik.grs.store.record.GRS2RecordStoreException;
import gr.uoa.di.madgik.grs.store.record.IRecordStore;
import gr.uoa.di.madgik.grs.store.record.RecordStoreFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class BufferStoreEntry {
    private URI locator = null;
    private long readerTimeout = 10L;
    private TimeUnit readerTimeoutTimeUnit = ForwardReader.DefaultIteratorTimeUnit;
    private ForwardReader<Record> reader = null;
    private IRecordStore recordManager = null;
    private IEventStore eventManager = null;
    private File bufferDefinitions = null;
    private EntryStatus status = EntryStatus.Open;

    public BufferStoreEntry(URI locator) {
        this.locator = locator;
        this.status = EntryStatus.Open;
    }

    public EntryStatus getStatus() {
        return this.status;
    }

    public void setStatus(EntryStatus status) {
        this.status = status;
    }

    public ForwardReader<Record> getReader() {
        return this.reader;
    }

    public IRecordStore getRecordManager() {
        return this.recordManager;
    }

    public IEventStore getEventManager() {
        return this.eventManager;
    }

    public long getReaderTimeout() {
        return this.readerTimeout;
    }

    public void setReaderTimeout(long timeout) {
        this.readerTimeout = timeout;
    }

    public TimeUnit getReaderTimeoutTimeUnit() {
        return this.readerTimeoutTimeUnit;
    }

    public void setReaderTimeoutTimeUnit(TimeUnit unit) {
        this.readerTimeoutTimeUnit = unit;
    }

    public void initialize() throws GRS2RecordStoreException, GRS2ReaderException, GRS2BufferStoreAccessException, GRS2EventStoreException {
        this.recordManager = RecordStoreFactory.getManager();
        this.recordManager.enableOrder(true);
        this.eventManager = EventStoreFactory.getManager();
        this.reader = new ForwardReader(this.locator);
        this.reader.setIteratorTimeout(this.readerTimeout);
        this.reader.setIteratorTimeout(this.readerTimeout);
        this.persistBufferDefinitions();
    }

    public void dispose() {
        this.locator = null;
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.recordManager != null) {
            try {
                this.recordManager.dispose();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.eventManager != null) {
            try {
                this.eventManager.dispose();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.bufferDefinitions != null) {
            try {
                this.bufferDefinitions.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.status = EntryStatus.Close;
    }

    public RecordDefinition[] getDefinitions() throws GRS2BufferStoreAccessException {
        FilterInputStream din = null;
        try {
            din = new DataInputStream(new BufferedInputStream(new FileInputStream(this.bufferDefinitions)));
            int len = ((DataInputStream)din).readInt();
            RecordDefinition[] defs = new RecordDefinition[len];
            for (int i = 0; i < len; ++i) {
                String recordDefType = ((DataInputStream)din).readUTF();
                RecordDefinition def = (RecordDefinition)Class.forName(recordDefType).newInstance();
                def.inflate((DataInput)((Object)din));
                defs[i] = def;
            }
            RecordDefinition[] recordDefinitionArray = defs;
            return recordDefinitionArray;
        }
        catch (Exception ex) {
            throw new GRS2BufferStoreAccessException("Could not initialize buffer definitions file", ex);
        }
        finally {
            if (din != null) {
                try {
                    din.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void persistBufferDefinitions() throws GRS2BufferStoreAccessException {
        DataOutputStream dout = null;
        try {
            this.bufferDefinitions = File.createTempFile(UUID.randomUUID().toString(), null);
            this.bufferDefinitions.deleteOnExit();
            dout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.bufferDefinitions)));
            RecordDefinition[] defs = this.reader.getRecordDefinitions();
            dout.writeInt(defs.length);
            for (RecordDefinition def : defs) {
                dout.writeUTF(def.getClass().getName());
                def.deflate(dout);
            }
        }
        catch (Exception ex) {
            throw new GRS2BufferStoreAccessException("Could not initialize buffer definitions file", ex);
        }
        finally {
            if (dout != null) {
                try {
                    dout.flush();
                }
                catch (Exception ex) {}
                try {
                    dout.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public static enum EntryStatus {
        Open,
        Close;

    }
}

