/*
 * Decompiled with CFR 0.152.
 */
package xjava.security;

import java.io.PrintWriter;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import xjava.security.IJCE;
import xjava.security.IJCE_Traceable;
import xjava.security.IllegalBlockSizeException;
import xjava.security.InvalidParameterTypeException;
import xjava.security.Mode;
import xjava.security.NoSuchParameterException;
import xjava.security.PaddingScheme;
import xjava.security.Parameterized;

public abstract class Cipher
extends IJCE_Traceable
implements Parameterized {
    private static final boolean DEBUG = true;
    private static int debuglevel = IJCE.getDebugLevel("Cipher");
    private static PrintWriter err = IJCE.getDebugOutput();
    public static final int UNINITIALIZED = 0;
    public static final int ENCRYPT = 1;
    public static final int DECRYPT = 2;
    private boolean implBuffering;
    private byte[] buffer;
    private int buffered;
    private int inputSize;
    private int outputSize;
    private String provider;
    private String cipherName;
    private String modeName;
    private String paddingName;
    private PaddingScheme padding;
    private int state;

    private static void debug(String s) {
        err.println("Cipher: " + s);
    }

    private static String dump(byte[] b) {
        if (b == null) {
            return "null";
        }
        return b.toString();
    }

    protected Cipher() {
        super("Cipher");
    }

    protected Cipher(boolean implBuffering, boolean implPadding, String provider) {
        super("Cipher");
        if (implPadding) {
            throw new IllegalArgumentException("IJCE does not support ciphers for which implPadding == true");
        }
        this.implBuffering = implBuffering;
        this.provider = provider;
    }

    protected Cipher(boolean implBuffering, String provider, String algorithm) {
        super("Cipher");
        this.implBuffering = implBuffering;
        this.provider = provider;
        this.parseAlgorithm(algorithm);
    }

    private void parseAlgorithm(String algorithm) {
        int p = algorithm.indexOf(47);
        if (p == -1) {
            this.cipherName = algorithm;
        } else {
            this.cipherName = algorithm.substring(0, p);
            int q = algorithm.indexOf(47, p + 1);
            if (q == -1) {
                this.modeName = algorithm.substring(p + 1);
            } else {
                this.modeName = algorithm.substring(p + 1, q);
                this.paddingName = algorithm.substring(q + 1);
            }
        }
    }

    private void setNames(String cipherName, String modeName, String paddingName, String provider) {
        if (this.cipherName == null) {
            this.cipherName = cipherName;
        }
        if (this.modeName == null) {
            this.modeName = modeName;
        }
        if (this.paddingName == null) {
            this.paddingName = paddingName;
        }
        if (this.provider == null) {
            this.provider = provider;
        }
    }

    protected final PaddingScheme getPaddingScheme() {
        return this.padding;
    }

    public static Cipher getInstance(String algorithm) throws NoSuchAlgorithmException {
        try {
            return Cipher.getInstance(algorithm, null);
        }
        catch (NoSuchProviderException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
    }

    public static Cipher getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        String cipherName = algorithm;
        String modeName = "ECB";
        String paddingName = "NONE";
        int p = algorithm.indexOf(47);
        if (p != -1) {
            cipherName = algorithm.substring(0, p);
            int q = algorithm.indexOf(47, p + 1);
            if (q == -1) {
                modeName = algorithm.substring(p + 1);
            } else {
                modeName = algorithm.substring(p + 1, q);
                paddingName = algorithm.substring(q + 1);
            }
        }
        return Cipher.getInstance(cipherName, modeName, paddingName, provider);
    }

    private static Cipher getInstance(String cipherName, String modeName, String paddingName, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Cipher result;
        PaddingScheme padding;
        Cipher nested;
        block10: {
            if (debuglevel >= 3) {
                Cipher.debug("Entered getInstance(\"" + cipherName + "\", \"" + modeName + "\", \"" + paddingName + "\", \"" + provider + "\")");
            }
            cipherName = IJCE.getStandardName(cipherName, "Cipher");
            modeName = IJCE.getStandardName(modeName, "Mode");
            paddingName = IJCE.getStandardName(paddingName, "PaddingScheme");
            nested = null;
            padding = null;
            try {
                result = (Cipher)IJCE.getImplementation(cipherName + "/" + modeName + "/" + paddingName, provider, "Cipher");
            }
            catch (NoSuchAlgorithmException e) {
                if (modeName.equals("ECB")) {
                    result = (Cipher)IJCE.getImplementation(cipherName, provider, "Cipher");
                } else {
                    try {
                        result = (Cipher)IJCE.getImplementation(cipherName + "/" + modeName, provider, "Cipher");
                    }
                    catch (NoSuchAlgorithmException e2) {
                        nested = (Cipher)IJCE.getImplementation(cipherName, provider, "Cipher");
                        nested.setNames(cipherName, "ECB", "NONE", provider);
                        result = (Cipher)IJCE.getImplementation(modeName, provider, "Mode");
                    }
                }
                if (paddingName.equals("NONE")) break block10;
                padding = (PaddingScheme)IJCE.getImplementation(paddingName, provider, "PaddingScheme");
            }
        }
        result.setNames(cipherName, modeName, paddingName, provider);
        if (nested != null) {
            ((Mode)result).engineSetCipher(nested);
        }
        if (padding != null) {
            result.engineSetPaddingScheme(padding);
        }
        if (debuglevel >= 3) {
            Cipher.debug("Created cipher [1]: " + result);
        }
        return result;
    }

    public static Cipher getInstance(Cipher cipher, Mode mode, PaddingScheme padding) {
        Cipher result;
        if (cipher == null) {
            throw new NullPointerException("cipher == null");
        }
        String cipherName = cipher.getAlgorithm();
        String modeName = mode == null ? "ECB" : mode.getAlgorithm();
        String paddingName = padding == null ? "NONE" : padding.getAlgorithm();
        String provider = cipher.getProvider();
        Cipher nested = null;
        if (mode == null) {
            result = cipher;
        } else {
            nested = cipher;
            result = mode;
        }
        result.setNames(cipherName, modeName, paddingName, provider);
        if (nested != null) {
            ((Mode)result).engineSetCipher(nested);
        }
        if (padding != null) {
            result.engineSetPaddingScheme(padding);
        }
        if (debuglevel >= 3) {
            Cipher.debug("Created cipher [2]: " + result);
        }
        return result;
    }

    public final int getState() {
        return this.state;
    }

    public final String getAlgorithm() {
        return this.cipherName;
    }

    public final String getMode() {
        return this.modeName == null ? "ECB" : this.modeName;
    }

    public final String getPadding() {
        return this.paddingName == null ? "NONE" : this.paddingName;
    }

    public final String getProvider() {
        return this.provider;
    }

    public final boolean isPaddingBlockCipher() {
        return this.getPlaintextBlockSize() > 1 && this.getPaddingScheme() != null;
    }

    public final int outBufferSize(int inLen) {
        return this.outBufferSizeInternal(inLen, false);
    }

    public final int outBufferSizeFinal(int inLen) {
        return this.outBufferSizeInternal(inLen, true);
    }

    public final int inBufferSize(int outLen) {
        return this.inBufferSizeInternal(outLen, false);
    }

    public final int inBufferSizeFinal(int outLen) {
        return this.inBufferSizeInternal(outLen, true);
    }

    public final int blockSize() {
        int blocksize = this.enginePlaintextBlockSize();
        if (blocksize != this.engineCiphertextBlockSize()) {
            throw new IllegalBlockSizeException("blockSize() called when plaintext and ciphertext block sizes differ");
        }
        return blocksize;
    }

    public final int getInputBlockSize() {
        switch (this.getState()) {
            case 1: {
                return this.enginePlaintextBlockSize();
            }
            case 2: {
                return this.engineCiphertextBlockSize();
            }
            default: {
                IJCE.reportBug("invalid Cipher state: " + this.getState());
            }
            case 0: 
        }
        throw new Error("cipher uninitialized");
    }

    public final int getOutputBlockSize() {
        switch (this.getState()) {
            case 1: {
                return this.engineCiphertextBlockSize();
            }
            case 2: {
                return this.enginePlaintextBlockSize();
            }
            default: {
                IJCE.reportBug("invalid Cipher state: " + this.getState());
            }
            case 0: 
        }
        throw new Error("cipher uninitialized");
    }

    public final int getPlaintextBlockSize() {
        return this.enginePlaintextBlockSize();
    }

    public final int getCiphertextBlockSize() {
        return this.engineCiphertextBlockSize();
    }

    public final void initEncrypt(Key key) throws KeyException {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (this.tracing) {
            this.traceVoidMethod("engineInitEncrypt(<" + key + ">)");
        }
        this.engineInitEncrypt(key);
        this.state = 1;
        this.inputSize = this.enginePlaintextBlockSize();
        this.outputSize = this.engineCiphertextBlockSize();
        if (this.inputSize < 1 || this.outputSize < 1) {
            this.state = 0;
            throw new Error("input or output block size < 1");
        }
        this.buffer = !this.implBuffering && this.inputSize > 1 ? new byte[this.inputSize] : null;
        this.buffered = 0;
        if (this.padding != null) {
            this.padding.engineSetBlockSize(this.inputSize);
        }
    }

    public final void initDecrypt(Key key) throws KeyException {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (this.tracing) {
            this.traceVoidMethod("engineInitDecrypt(<" + key + ">)");
        }
        this.engineInitDecrypt(key);
        this.state = 2;
        this.inputSize = this.engineCiphertextBlockSize();
        this.outputSize = this.enginePlaintextBlockSize();
        if (this.inputSize < 1 || this.outputSize < 1) {
            this.state = 0;
            throw new Error("input or output block size < 1");
        }
        this.buffer = !this.implBuffering && this.inputSize > 1 ? new byte[this.inputSize] : null;
        this.buffered = 0;
        if (this.padding != null) {
            this.padding.engineSetBlockSize(this.outputSize);
        }
    }

    public final byte[] update(byte[] in) {
        return this.update(in, 0, in.length);
    }

    public final byte[] update(byte[] in, int offset, int length) {
        byte[] out = new byte[this.outBufferSizeInternal(length, false)];
        int outlen = this.updateInternal(in, offset, length, out, 0, false);
        if (outlen != out.length) {
            byte[] newout = new byte[outlen];
            System.arraycopy(out, 0, newout, 0, outlen);
            return newout;
        }
        return out;
    }

    public final int update(byte[] in, int inOffset, int inLen, byte[] out) {
        return this.updateInternal(in, inOffset, inLen, out, 0, false);
    }

    public final int update(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        return this.updateInternal(in, inOffset, inLen, out, outOffset, false);
    }

    public final byte[] crypt(byte[] in) throws IllegalBlockSizeException {
        return this.crypt(in, 0, in.length);
    }

    public final byte[] crypt(byte[] in, int offset, int length) throws IllegalBlockSizeException {
        byte[] out = new byte[this.outBufferSizeInternal(length, true)];
        int outlen = this.updateInternal(in, offset, length, out, 0, true);
        if (outlen != out.length) {
            byte[] newout = new byte[outlen];
            System.arraycopy(out, 0, newout, 0, outlen);
            return newout;
        }
        return out;
    }

    public final int crypt(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws IllegalBlockSizeException {
        return this.updateInternal(in, inOffset, inLen, out, outOffset, true);
    }

    public final byte[] doFinal(byte[] in) throws IllegalBlockSizeException {
        return this.crypt(in, 0, in.length);
    }

    public final byte[] doFinal(byte[] in, int offset, int length) throws IllegalBlockSizeException {
        return this.crypt(in, offset, length);
    }

    public final int doFinal(byte[] in, int inOffset, int inLen, byte[] out) throws IllegalBlockSizeException {
        return this.crypt(in, inOffset, inLen, out, 0);
    }

    public final int doFinal(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws IllegalBlockSizeException {
        return this.crypt(in, inOffset, inLen, out, outOffset);
    }

    private int outBufferSizeInternal(int inLen, boolean isFinal) {
        if (inLen < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        if (!this.implBuffering) {
            int remainder = (inLen += this.buffered) % this.inputSize;
            inLen -= remainder;
            if (isFinal && this.state == 1 && (this.padding != null || remainder > 0)) {
                inLen += this.inputSize;
            }
        }
        if (inLen < 0) {
            IJCE.reportBug("inLen < 0");
        }
        if (this.tracing) {
            this.traceMethod("engineOutBufferSize(" + inLen + ", " + isFinal + ")");
        }
        int result = this.engineOutBufferSize(inLen, isFinal);
        if (this.tracing) {
            this.traceResult(result);
        }
        return result;
    }

    private int inBufferSizeInternal(int outLen, boolean isFinal) {
        int remainder;
        if (!this.implBuffering && (remainder = outLen % this.outputSize) > 0) {
            outLen += this.outputSize - remainder;
        }
        if (this.tracing) {
            this.traceMethod("engineInBufferSize(" + outLen + ", " + isFinal + ")");
        }
        int result = this.engineInBufferSize(outLen, isFinal);
        if (this.tracing) {
            this.traceResult(result);
        }
        if (!this.implBuffering) {
            if (isFinal && this.state == 1 && this.padding != null) {
                result -= this.inputSize;
            }
            result -= this.buffered;
        }
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private int updateInternal(byte[] in, int inOffset, int inLen, byte[] out, int outOffset, boolean isFinal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 29[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setParameter(String param, Object value) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (param == null) {
            throw new NullPointerException("param == null");
        }
        if (this.tracing) {
            this.traceVoidMethod("engineSetParameter(\"" + param + "\", <" + value + ">)");
        }
        this.engineSetParameter(param, value);
    }

    public Object getParameter(String param) throws NoSuchParameterException, InvalidParameterException {
        if (param == null) {
            throw new NullPointerException("param == null");
        }
        if (this.tracing) {
            this.traceMethod("engineGetParameter(\"" + param + "\")");
        }
        Object result = this.engineGetParameter(param);
        if (this.tracing) {
            this.traceResult("<" + result + ">");
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    public String toString() {
        return "Cipher [" + this.getProvider() + " " + this.getAlgorithm() + "/" + this.getMode() + "/" + this.getPadding() + "]";
    }

    protected void engineSetPaddingScheme(PaddingScheme padding) {
        if (this.state != 0) {
            throw new IllegalStateException("Cipher is already initialized");
        }
        this.padding = padding;
    }

    protected int engineBlockSize() {
        throw new Error("cipher classes must implement either engineBlockSize, or enginePlaintextBlockSize and engineCiphertextBlockSize");
    }

    protected int enginePlaintextBlockSize() {
        return this.engineBlockSize();
    }

    protected int engineCiphertextBlockSize() {
        return this.engineBlockSize();
    }

    protected int engineOutBufferSize(int inLen, boolean isFinal) {
        return inLen / this.inputSize * this.outputSize;
    }

    protected int engineInBufferSize(int outLen, boolean isFinal) {
        return outLen / this.outputSize * this.inputSize;
    }

    protected abstract void engineInitEncrypt(Key var1) throws KeyException;

    protected abstract void engineInitDecrypt(Key var1) throws KeyException;

    protected abstract int engineUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5);

    protected int engineCrypt(byte[] out, int outOffset) {
        return 0;
    }

    protected void engineSetParameter(String param, Object value) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        throw new NoSuchParameterException(this.getAlgorithm() + ": " + param);
    }

    protected Object engineGetParameter(String param) throws NoSuchParameterException, InvalidParameterException {
        throw new NoSuchParameterException(this.getAlgorithm() + ": " + param);
    }

    public static String[] getAlgorithms(Provider provider) {
        return IJCE.getAlgorithms(provider, "Cipher");
    }

    public static String[] getAlgorithms() {
        return IJCE.getAlgorithms("Cipher");
    }
}

