/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.encoding.SerializationException;

public class SimpleResourceKey
implements ResourceKey {
    private static Log logger = LogFactory.getLog(SimpleResourceKey.class.getName());
    private QName name;
    private Object value;

    public SimpleResourceKey(SOAPElement header, Class type) throws InvalidResourceKeyException {
        try {
            this.value = ObjectDeserializer.toObject(header, type);
        }
        catch (Exception e) {
            throw new InvalidResourceKeyException(e);
        }
        this.name = new QName(header.getElementName().getURI(), header.getElementName().getLocalName());
    }

    public SimpleResourceKey(QName name, Object value) {
        this.name = name;
        this.value = value;
    }

    public QName getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public SOAPElement toSOAPElement() throws SerializationException {
        return ObjectSerializer.toSOAPElement(this.value, this.name);
    }

    public String toString() {
        return this.name + "=" + this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleResourceKey)) {
            return false;
        }
        SimpleResourceKey otherKey = (SimpleResourceKey)obj;
        if (!this.name.equals(otherKey.name)) {
            return false;
        }
        return this.value.equals(otherKey.value);
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode();
    }
}

