/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.PersistenceCallback;
import org.globus.wsrf.RemoveCallback;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceIdentifier;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceLifetime;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.Subscription;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListAccessor;
import org.globus.wsrf.TopicListener;
import org.globus.wsrf.TopicListenerList;
import org.globus.wsrf.WSNConstants;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import org.globus.wsrf.impl.SimpleSubscriptionTopicListener;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.security.SecureResource;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.properties.QueryExpressionType;

public class SimpleSubscription
implements Subscription,
ResourceProperties,
ResourceIdentifier,
ResourceLifetime,
RemoveCallback,
SecureResource,
Serializable {
    static Log logger = LogFactory.getLog(SimpleSubscription.class.getName());
    public static final QName RP_SET = new QName("http://docs.oasis-open.org/wsn/2004/06/wsn-WS-BaseNotification-1.2-draft-01.xsd", "SubscriptionManagerRP");
    protected EndpointReferenceType consumerReference;
    protected EndpointReferenceType producerReference;
    protected Object policy;
    protected QueryExpressionType precondition;
    protected QueryExpressionType selector;
    protected ResourceKey producerKey;
    protected String producerHomeLocation;
    protected TopicExpressionType topicExpression;
    protected boolean isPaused;
    protected boolean useNotify;
    protected Calendar terminationTime;
    protected Calendar creationTime;
    protected ClientSecurityDescriptor securityDescriptor;
    protected String id = uuidGen.nextUUID();
    protected ResourceSecurityDescriptor resourceSecurityDescriptor;
    private transient ResourcePropertySet propertySet;
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    public ResourcePropertySet getResourcePropertySet() {
        return this.propertySet;
    }

    public void setTerminationTime(Calendar time) {
        this.terminationTime = time;
    }

    public Calendar getTerminationTime() {
        return this.terminationTime;
    }

    public Calendar getCurrentTime() {
        return Calendar.getInstance();
    }

    public Calendar getCreationTime() {
        return this.creationTime;
    }

    public EndpointReferenceType getConsumerReference() {
        return this.consumerReference;
    }

    public Object getSubscriptionPolicy() {
        return this.policy;
    }

    public QueryExpressionType getPrecondition() {
        return this.precondition;
    }

    public EndpointReferenceType getProducerReference() {
        return this.producerReference;
    }

    public Object getResource() throws Exception {
        InitialContext initialContext = new InitialContext();
        ResourceHome producerHome = (ResourceHome)initialContext.lookup(this.producerHomeLocation);
        return producerHome.find(this.producerKey);
    }

    public QueryExpressionType getSelector() {
        return this.selector;
    }

    public TopicExpressionType getTopicExpression() {
        return this.topicExpression;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void pause() throws Exception {
        this.isPaused = true;
    }

    public void resume() throws Exception {
        this.isPaused = false;
    }

    public boolean getUseNotify() {
        return this.useNotify;
    }

    public ClientSecurityDescriptor getSecurityProperties() {
        return this.securityDescriptor;
    }

    public SimpleSubscription() {
        this(null, null, null, null, null, null, null, null, null, false, true, null, null);
    }

    public SimpleSubscription(EndpointReferenceType consumerReference, EndpointReferenceType producerReference, Calendar initialTerminationTime, Object policy, QueryExpressionType precondition, QueryExpressionType selector, ResourceKey producerKey, String producerHomeLocation, TopicExpressionType topicExpression, boolean isPaused, boolean useNotify, ClientSecurityDescriptor notificationSecurityDescriptor, ResourceSecurityDescriptor resourceSecurityDescriptor) {
        this.terminationTime = initialTerminationTime;
        this.consumerReference = consumerReference;
        this.producerReference = producerReference;
        this.policy = policy;
        this.precondition = precondition;
        this.selector = selector;
        this.producerKey = producerKey;
        this.producerHomeLocation = producerHomeLocation;
        this.topicExpression = topicExpression;
        this.isPaused = isPaused;
        this.useNotify = useNotify;
        this.creationTime = Calendar.getInstance();
        this.securityDescriptor = notificationSecurityDescriptor;
        this.propertySet = new SimpleResourcePropertySet(RP_SET);
        this.resourceSecurityDescriptor = resourceSecurityDescriptor;
        ReflectionResourceProperty property = null;
        if (this.consumerReference != null && this.consumerReference.getAddress().getScheme().equalsIgnoreCase("https") && this.securityDescriptor == null) {
            this.securityDescriptor = new ClientSecurityDescriptor();
        }
        try {
            property = new ReflectionResourceProperty(WSNConstants.CONSUMER_REFERENCE, (Object)this);
            this.propertySet.add(property);
            property = new ReflectionResourceProperty(WSNConstants.SELECTOR, (Object)this);
            this.propertySet.add(property);
            property = new ReflectionResourceProperty(WSNConstants.USE_NOTIFY, (Object)this);
            this.propertySet.add(property);
            property = new ReflectionResourceProperty(WSNConstants.TOPIC_EXPRESSION, (Object)this);
            this.propertySet.add(property);
            property = new ReflectionResourceProperty(WSNConstants.SUBSCRIPTION_POLICY, (Object)this);
            this.propertySet.add(property);
            property = new ReflectionResourceProperty(SimpleResourcePropertyMetaData.TERMINATION_TIME, (Object)this);
            this.propertySet.add(property);
            property = new ReflectionResourceProperty(WSNConstants.CREATION_TIME, (Object)this);
            this.propertySet.add(property);
            property = new ReflectionResourceProperty(WSNConstants.PRECONDITION, (Object)this);
            this.propertySet.add(property);
            property = new ReflectionResourceProperty(SimpleResourcePropertyMetaData.CURRENT_TIME, (Object)this);
            this.propertySet.add(property);
        }
        catch (Exception e) {
            logger.debug("Failed to set up resource properties", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public Object getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws ResourceException {
        Object resource = null;
        try {
            resource = this.getResource();
        }
        catch (Exception e) {
            throw new ResourceException("", e);
        }
        if (!(resource instanceof TopicListAccessor)) {
            return;
        }
        TopicList topicList = ((TopicListAccessor)resource).getTopicList();
        Collection topics = null;
        try {
            topics = topicList.getTopics(this.topicExpression);
        }
        catch (Exception e) {
            throw new ResourceException("", e);
        }
        Object object = resource;
        synchronized (object) {
            boolean removed = this.removeListener(topics);
            if (removed && resource instanceof PersistenceCallback) {
                ((PersistenceCallback)resource).store();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeListener(Collection topics) {
        boolean removed = false;
        Iterator topicIterator = topics.iterator();
        while (topicIterator.hasNext()) {
            TopicListenerList topicListenerList;
            TopicListenerList topicListenerList2 = topicListenerList = (TopicListenerList)topicIterator.next();
            synchronized (topicListenerList2) {
                Iterator topicListenerIterator = topicListenerList.topicListenerIterator();
                while (topicListenerIterator.hasNext()) {
                    SimpleSubscriptionTopicListener lt;
                    Object subKey;
                    TopicListener listener = (TopicListener)topicListenerIterator.next();
                    if (!(listener instanceof SimpleSubscriptionTopicListener) || !(subKey = (lt = (SimpleSubscriptionTopicListener)listener).getSubscriptionResourceKey().getValue()).equals(this.id)) continue;
                    topicListenerIterator.remove();
                    removed = true;
                }
            }
        }
        return removed;
    }

    public ResourceSecurityDescriptor getSecurityDescriptor() {
        return this.resourceSecurityDescriptor;
    }
}

