/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content.keyvalues;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.keyvalues.KeyValueContent;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RSAKeyValue
extends SignatureElementProxy
implements KeyValueContent {
    static Log log = LogFactory.getLog((class$org$apache$xml$security$keys$content$keyvalues$RSAKeyValue == null ? (class$org$apache$xml$security$keys$content$keyvalues$RSAKeyValue = RSAKeyValue.class$("org.apache.xml.security.keys.content.keyvalues.RSAKeyValue")) : class$org$apache$xml$security$keys$content$keyvalues$RSAKeyValue).getName());
    static /* synthetic */ Class class$org$apache$xml$security$keys$content$keyvalues$RSAKeyValue;

    public RSAKeyValue(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public RSAKeyValue(Document document, BigInteger bigInteger, BigInteger bigInteger2) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this.addBigIntegerElement(bigInteger, "Modulus");
        this.addBigIntegerElement(bigInteger2, "Exponent");
    }

    public RSAKeyValue(Document document, Key key) throws IllegalArgumentException {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        if (!JavaUtils.implementsInterface(key, "java.security.interfaces.RSAPublicKey")) {
            Object[] objectArray = new Object[]{"RSAKeyValue", key.getClass().getName()};
            throw new IllegalArgumentException(I18n.translate("KeyValue.IllegalArgument", objectArray));
        }
        this.addBigIntegerElement(((RSAPublicKey)key).getModulus(), "Modulus");
        this.addBigIntegerElement(((RSAPublicKey)key).getPublicExponent(), "Exponent");
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(this.getBigIntegerFromChildElement("Modulus", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("Exponent", "http://www.w3.org/2000/09/xmldsig#"));
            PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("empty", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new XMLSecurityException("empty", invalidKeySpecException);
        }
    }

    public String getBaseLocalName() {
        return "RSAKeyValue";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

