/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.ChainedIOException;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.net.SocketFactory;
import org.globus.net.WrappedSocket;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public abstract class GssSocket
extends WrappedSocket {
    private static Log logger = LogFactory.getLog((class$org$globus$gsi$gssapi$net$GssSocket == null ? (class$org$globus$gsi$gssapi$net$GssSocket = GssSocket.class$("org.globus.gsi.gssapi.net.GssSocket")) : class$org$globus$gsi$gssapi$net$GssSocket).getName());
    protected GSSContext context;
    protected boolean clientMode;
    protected InputStream in;
    protected OutputStream out;
    protected Authorization authorization = SelfAuthorization.getInstance();
    public static final int SSL_MODE = 1;
    public static final int GSI_MODE = 2;
    protected int mode = -1;
    static /* synthetic */ Class class$org$globus$gsi$gssapi$net$GssSocket;

    public GssSocket(String host, int port, GSSContext context) throws IOException {
        this(SocketFactory.getDefault().createSocket(host, port), context);
    }

    public GssSocket(Socket socket, GSSContext context) {
        super(socket);
        this.context = context;
        this.clientMode = true;
    }

    public void setAuthorization(Authorization auth) {
        this.authorization = auth;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public void setUseClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean getClientMode() {
        return this.clientMode;
    }

    public void setWrapMode(int mode) {
        this.mode = mode;
    }

    public int getWrapMode() {
        return this.mode;
    }

    public GSSContext getContext() {
        return this.context;
    }

    protected abstract void writeToken(byte[] var1) throws IOException;

    protected abstract byte[] readToken() throws IOException;

    protected synchronized void authenticateClient() throws IOException, GSSException {
        byte[] outToken = null;
        byte[] inToken = new byte[]{};
        while (!this.context.isEstablished()) {
            outToken = this.context.initSecContext(inToken, 0, inToken.length);
            if (outToken != null) {
                this.writeToken(outToken);
            }
            if (this.context.isEstablished()) continue;
            inToken = this.readToken();
        }
    }

    protected synchronized void authenticateServer() throws IOException, GSSException {
        byte[] outToken = null;
        byte[] inToken = null;
        while (!this.context.isEstablished()) {
            inToken = this.readToken();
            outToken = this.context.acceptSecContext(inToken, 0, inToken.length);
            if (outToken == null) continue;
            this.writeToken(outToken);
        }
    }

    public synchronized void startHandshake() throws IOException {
        if (this.context.isEstablished()) {
            return;
        }
        logger.debug("Handshake start");
        try {
            if (this.clientMode) {
                this.authenticateClient();
            } else {
                this.authenticateServer();
            }
        }
        catch (GSSException e) {
            throw new ChainedIOException("Authentication failed", e);
        }
        logger.debug("Handshake end");
        if (this.authorization != null) {
            logger.debug("Performing authorization.");
            this.authorization.authorize(this.context, this.getInetAddress().getHostAddress());
        } else {
            logger.debug("Authorization not set");
        }
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            this.startHandshake();
            return this.out;
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        try {
            this.startHandshake();
            return this.in;
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            this.context.dispose();
        }
        catch (GSSException e) {
            throw new ChainedIOException("dispose failed.", e);
        }
        finally {
            this.socket.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

