/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.mirror;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorDisposedException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.mirror.PartialRequestEntry;
import java.util.Hashtable;

public class PartialRequestManager {
    private Hashtable<PartialRequestEntry, PartialRequestEntry> entries = new Hashtable();

    public synchronized void block(long recordIndex, int fieldIndex, IBuffer.TransportOverride override, Object notify) throws GRS2ProxyMirrorDisposedException, GRS2ProxyMirrorInvalidOperationException {
        if (this.entries == null) {
            throw new GRS2ProxyMirrorDisposedException("Partial request manager is already disposed");
        }
        PartialRequestEntry entry = new PartialRequestEntry(recordIndex, fieldIndex, override, notify);
        if (this.entries.contains(entry)) {
            throw new GRS2ProxyMirrorInvalidOperationException("A request is already set for the record and field");
        }
        this.entries.put(entry, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unblock(long recordIndex, int fieldIndex) throws GRS2ProxyMirrorDisposedException, GRS2ProxyMirrorInvalidOperationException {
        if (this.entries == null) {
            throw new GRS2ProxyMirrorDisposedException("Partial request manager is already disposed");
        }
        PartialRequestEntry entry = new PartialRequestEntry(recordIndex, fieldIndex, IBuffer.TransportOverride.Defined, null);
        if (!this.entries.contains(entry)) {
            throw new GRS2ProxyMirrorInvalidOperationException("No request has been set for the record and field");
        }
        if ((entry = this.entries.remove(entry)) == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("No request has been set for the record and field");
        }
        Object object = entry.getNotify();
        synchronized (object) {
            entry.getNotify().notify();
        }
    }

    public synchronized boolean requestExists(long recordIndex, int fieldIndex) throws GRS2ProxyMirrorDisposedException {
        if (this.entries == null) {
            throw new GRS2ProxyMirrorDisposedException("Partial request manager is already disposed");
        }
        PartialRequestEntry entry = new PartialRequestEntry(recordIndex, fieldIndex, IBuffer.TransportOverride.Defined, null);
        return this.entries.contains(entry);
    }

    public synchronized PartialRequestEntry[] getEntries() {
        if (this.entries == null) {
            return new PartialRequestEntry[0];
        }
        PartialRequestEntry[] vals = this.entries.values().toArray(new PartialRequestEntry[0]);
        PartialRequestEntry[] tmp = new PartialRequestEntry[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            tmp[i] = vals[i].copy();
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        if (this.entries == null) {
            return;
        }
        for (PartialRequestEntry entry : this.entries.values()) {
            Object object = entry.getNotify();
            synchronized (object) {
                entry.getNotify().notify();
            }
        }
        this.entries.clear();
        this.entries = null;
    }
}

