/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.nozzle;

import gr.uoa.di.madgik.commons.channel.events.ChannelPayloadStateEvent;
import gr.uoa.di.madgik.commons.channel.events.ChannelState;
import gr.uoa.di.madgik.commons.channel.events.ChannelStateEvent;
import gr.uoa.di.madgik.commons.channel.proxy.IChannelLocator;
import gr.uoa.di.madgik.commons.channel.proxy.IChannelProxy;
import gr.uoa.di.madgik.commons.channel.proxy.local.LocalChannelProxy;
import gr.uoa.di.madgik.commons.channel.proxy.tcp.TCPServerChannelProxy;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChannelOutlet
implements Observer {
    private static Logger logger = Logger.getLogger(ChannelOutlet.class.getName());
    private long NozzleIdentifierLeastSignificantBits = 0L;
    private long NozzleIdentifierMostSignificantBits = 0L;
    private IChannelLocator Locator = null;
    private IChannelProxy Proxy = null;
    private ChannelState NozzleState = new ChannelState();

    public ChannelOutlet(IChannelLocator Locator) {
        this.Locator = Locator;
        if (Locator == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Outlet locator cannot be null");
            }
            throw new IllegalArgumentException("Outlet locator cannot be null");
        }
        UUID ID = UUID.randomUUID();
        this.NozzleIdentifierLeastSignificantBits = ID.getLeastSignificantBits();
        this.NozzleIdentifierMostSignificantBits = ID.getMostSignificantBits();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created outlet with identifier " + this.GetNozzleID());
        }
        switch (this.Locator.GetLocatorType()) {
            case Local: {
                this.Proxy = new LocalChannelProxy(this.Locator, this.GetNozzleID());
                break;
            }
            case TCP: {
                this.Proxy = new TCPServerChannelProxy(this.Locator, this.GetNozzleID());
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Registering for emited events");
        }
        for (ChannelStateEvent ev : this.Proxy.GetChannelState().GetChannelEvents()) {
            ev.addObserver(this);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        ChannelStateEvent ev;
        if (!o.getClass().getName().equals(arg.getClass().getName())) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Caught event has argument other than the one registered for. Disgarding");
            }
            return;
        }
        if (arg instanceof ChannelStateEvent && (((ChannelStateEvent)arg).GetEmitingNozzleIdentifierLeastSignificantBits() != this.NozzleIdentifierLeastSignificantBits || ((ChannelStateEvent)arg).GetEmitingNozzleIdentifierMostSignificantBits() != this.NozzleIdentifierMostSignificantBits) && (ev = this.NozzleState.GetEvent(((ChannelStateEvent)arg).GetEventName())) != null) {
            ev.NotifyChange((ChannelStateEvent)arg);
        }
    }

    public String GetNozzleID() {
        return Long.toString(this.NozzleIdentifierLeastSignificantBits) + "#" + Long.toString(this.NozzleIdentifierMostSignificantBits);
    }

    public Collection<ChannelStateEvent> GetNozzleEvents() {
        return this.NozzleState.GetChannelEvents();
    }

    public void Dispose() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disposing Outlet Nozzle");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Unregistering nozzle from state events");
        }
        for (ChannelStateEvent ev : this.Proxy.GetChannelState().GetChannelEvents()) {
            ev.deleteObserver(this);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disposing Nozzle state");
        }
        this.NozzleState.Dispose();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disposing proxy");
        }
        this.Proxy.Dispose();
    }

    public void Push(ChannelPayloadStateEvent Event) {
        ChannelStateEvent ev;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "trying to push event to outlet");
        }
        if ((ev = this.Proxy.GetChannelState().GetEvent(Event.GetEventName())) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "pushing event to outlet");
            }
            Event.SetEmitingNozzleIdentifierLeastSignificantBits(this.NozzleIdentifierLeastSignificantBits);
            Event.SetEmitingNozzleIdentifierMostSignificantBits(this.NozzleIdentifierMostSignificantBits);
            ev.NotifyChange(Event);
        }
    }

    public IChannelLocator GetLocator() {
        return this.Proxy.GetLocator();
    }
}

