/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.proxy.local;

import gr.uoa.di.madgik.commons.channel.proxy.IChannelLocator;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryKey;
import gr.uoa.di.madgik.commons.utils.URIUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.URI;
import java.util.Map;

public class LocalChannelLocator
implements IChannelLocator {
    private static final long serialVersionUID = 1L;
    private ChannelRegistryKey RegistryKey = null;

    @Override
    public void Decode(byte[] payload) throws Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(payload);
        DataInputStream din = new DataInputStream(bin);
        if (!din.readUTF().equalsIgnoreCase(this.GetLocatorType().toString())) {
            throw new Exception("Not valid serialization for this channel locator");
        }
        this.RegistryKey = new ChannelRegistryKey(din.readUTF());
    }

    @Override
    public byte[] Encode() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeUTF(this.GetLocatorType().toString());
        dout.writeUTF(this.RegistryKey.GetUniqueID());
        dout.flush();
        dout.close();
        bout.flush();
        bout.close();
        return bout.toByteArray();
    }

    @Override
    public IChannelLocator.LocatorType GetLocatorType() {
        return IChannelLocator.LocatorType.Local;
    }

    @Override
    public ChannelRegistryKey GetRegistryKey() {
        return this.RegistryKey;
    }

    @Override
    public void SetRegistryKey(ChannelRegistryKey RegistryKey) {
        this.RegistryKey = RegistryKey;
    }

    @Override
    public URI ToURI() throws Exception {
        String queryString = URIUtils.BuildQueryString(this.RegistryKey.GetUniqueID());
        return new URI("channel", null, "localhost", -1, null, queryString, this.GetLocatorType().toString());
    }

    @Override
    public void FromURI(URI locator) throws Exception {
        try {
            if (!locator.getScheme().equals("channel")) {
                throw new Exception("Invalid scheme");
            }
            if (!IChannelLocator.LocatorType.valueOf(locator.getFragment()).equals((Object)this.GetLocatorType())) {
                throw new Exception("Invalid type");
            }
            Map<String, String> params = URIUtils.ParseQueryString(locator.getQuery());
            this.RegistryKey = new ChannelRegistryKey(URIUtils.GetID(params, true));
        }
        catch (Exception ex) {
            throw new Exception("Could not parse URI " + locator, ex);
        }
    }

    public String toString() {
        return this.RegistryKey.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalChannelLocator)) {
            return false;
        }
        return this.RegistryKey.equals(((LocalChannelLocator)o).RegistryKey);
    }

    public int hashCode() {
        int hash = 5;
        return 94 * hash + (this.RegistryKey != null ? this.RegistryKey.hashCode() : 0);
    }
}

