/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.configuration;

import gr.uoa.di.madgik.commons.configuration.parameter.IParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.ParameterFactory;
import gr.uoa.di.madgik.commons.configuration.parameter.elements.graph.DependencyGraph;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigurationManager {
    private static Logger logger;
    private static File confFile;
    private static Map<String, IParameter> Parameters;

    public static File GetGonfigurationFile() {
        return confFile;
    }

    public static Object GetParameter(String ParameterName) throws Exception {
        IParameter param = Parameters.get(ParameterName);
        if (param == null) {
            throw new Exception("Parameter " + ParameterName + " does not exist");
        }
        if (param.IsInternal().booleanValue()) {
            throw new Exception("Parameter " + ParameterName + " does not exist");
        }
        return param.GetValue();
    }

    public static Boolean GetBooleanParameter(String ParameterName) throws Exception {
        Object val = ConfigurationManager.GetParameter(ParameterName);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        throw new Exception("Could not convert parameter value to boolean");
    }

    public static Byte GetByteParameter(String ParameterName) throws Exception {
        Object val = ConfigurationManager.GetParameter(ParameterName);
        if (val instanceof Byte) {
            return (Byte)val;
        }
        throw new Exception("Could not convert parameter value to byte");
    }

    public static Double GetDoubleParameter(String ParameterName) throws Exception {
        Object val = ConfigurationManager.GetParameter(ParameterName);
        if (val instanceof Double) {
            return (Double)val;
        }
        throw new Exception("Could not convert parameter value to double");
    }

    public static Float GetFloatParameter(String ParameterName) throws Exception {
        Object val = ConfigurationManager.GetParameter(ParameterName);
        if (val instanceof Float) {
            return (Float)val;
        }
        throw new Exception("Could not convert parameter value to float");
    }

    public static Integer GetIntegerParameter(String ParameterName) throws Exception {
        Object val = ConfigurationManager.GetParameter(ParameterName);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        throw new Exception("Could not convert parameter value to integer");
    }

    public static Long GetLongParameter(String ParameterName) throws Exception {
        Object val = ConfigurationManager.GetParameter(ParameterName);
        if (val instanceof Long) {
            return (Long)val;
        }
        throw new Exception("Could not convert parameter value to long");
    }

    public static Short GetShortParameter(String ParameterName) throws Exception {
        Object val = ConfigurationManager.GetParameter(ParameterName);
        if (val instanceof Short) {
            return (Short)val;
        }
        throw new Exception("Could not convert parameter value to short");
    }

    public static String GetStringParameter(String ParameterName) throws Exception {
        Object val = ConfigurationManager.GetParameter(ParameterName);
        if (val instanceof String) {
            return (String)val;
        }
        throw new Exception("Could not convert parameter value to string");
    }

    private static void GenerateParameters() throws Exception {
        DependencyGraph graph = new DependencyGraph(Parameters);
        graph.ConstructGraph();
        graph.ResolveDependencies();
        if (!graph.AllChecked().booleanValue()) {
            throw new Exception("unable to resolve all dependencies");
        }
    }

    private static void Parse() {
        block5: {
            try {
                char[] cbuf;
                int num;
                FileReader reader = new FileReader(ConfigurationManager.GetGonfigurationFile());
                StringBuilder buf = new StringBuilder();
                while ((num = reader.read(cbuf = new char[1024])) >= 0) {
                    buf.append(cbuf, 0, num);
                }
                Document doc = XMLUtils.Deserialize(buf.toString());
                List<Element> params = XMLUtils.GetChildElementsWithName(doc.getDocumentElement(), "param");
                for (Element par : params) {
                    IParameter param = ParameterFactory.GetParameter(par);
                    if (Parameters.containsKey(param.GetName())) {
                        throw new Exception("Duplicate key " + param.GetName());
                    }
                    Parameters.put(param.GetName(), param);
                }
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, "Could not parse Configuration file", ex);
            }
        }
    }

    static {
        block4: {
            logger = Logger.getLogger(ConfigurationManager.class.getName());
            confFile = null;
            Parameters = null;
            try {
                confFile = new File("configuration.conf");
                if (!confFile.exists()) {
                    Properties props = new Properties();
                    URL configResource = Thread.currentThread().getContextClassLoader().getResource("configuration.properties");
                    if (configResource != null) {
                        props.load(configResource.openStream());
                        String filename = props.getProperty("configuration.filename");
                        confFile = new File(filename);
                    }
                }
                Parameters = new Hashtable<String, IParameter>();
                ConfigurationManager.Parse();
                ConfigurationManager.GenerateParameters();
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.log(Level.WARNING, "Could not initialize configuration manager", ex);
            }
        }
    }
}

