/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.configuration.parameter;

import gr.uoa.di.madgik.commons.configuration.parameter.IParameter;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FloatClassParameter
implements IParameter {
    private String Name = null;
    private Float Value = Float.valueOf(0.0f);
    private boolean generated = false;
    private boolean internal = false;
    private boolean checked = false;

    @Override
    public Class<?> GetParameterClassType() {
        return Float.class;
    }

    @Override
    public Boolean IsChecked() {
        return this.checked;
    }

    @Override
    public void Check() {
        this.checked = true;
    }

    @Override
    public IParameter.ParameterType GetParameterType() {
        return IParameter.ParameterType.FloatClass;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public Boolean IsGenerated() {
        return this.generated;
    }

    @Override
    public Boolean IsInternal() {
        return this.internal;
    }

    @Override
    public Object GetValue() {
        return new Float(this.Value.floatValue());
    }

    @Override
    public void SetValue(Object Value) throws Exception {
        if (!(Value instanceof Float)) {
            throw new Exception("Provided value not of expected type");
        }
        this.Value = new Float(((Float)Value).floatValue());
    }

    @Override
    public void FromXML(String xml) throws Exception {
        Document doc = XMLUtils.Deserialize(xml);
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element element) throws Exception {
        if (!XMLUtils.AttributeExists(element, "name").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        this.Name = XMLUtils.GetAttribute(element, "name");
        if (!XMLUtils.AttributeExists(element, "type").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        if (!IParameter.ParameterType.valueOf(XMLUtils.GetAttribute(element, "type")).equals((Object)this.GetParameterType())) {
            throw new Exception("Not valid serialization of parameter");
        }
        if (!XMLUtils.AttributeExists(element, "generated").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        this.generated = Boolean.getBoolean(XMLUtils.GetAttribute(element, "generated"));
        if (!XMLUtils.AttributeExists(element, "internal").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        this.internal = Boolean.getBoolean(XMLUtils.GetAttribute(element, "internal"));
        if (!this.generated) {
            this.Value = Float.valueOf(Float.parseFloat(XMLUtils.GetChildText(element)));
        }
    }
}

