/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.ghnmanager.testsuite;

import java.rmi.Remote;
import java.util.Properties;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.security.utils.ProxyUtil;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.vremanagement.ghnmanager.stubs.AddScopeInputParams;
import org.gcube.common.vremanagement.ghnmanager.stubs.GHNManagerPortType;
import org.gcube.common.vremanagement.ghnmanager.stubs.service.GHNManagerServiceAddressingLocator;
import org.ietf.jgss.GSSCredential;

public class AddGHNToScopeTest {
    static GCUBEClientLog logger = new GCUBEClientLog(AddGHNToScopeTest.class, new Properties[0]);

    public static void main(String[] args) {
        final boolean isSecurityEnabled = Boolean.valueOf(args[4]);
        logger.info((Object)("Security is enabled? " + isSecurityEnabled));
        if (!isSecurityEnabled && args.length != 5) {
            AddGHNToScopeTest.printUsage();
        }
        if (isSecurityEnabled && args.length != 6) {
            AddGHNToScopeTest.printUsage2();
        }
        GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl(){

            public boolean isSecurityEnabled() {
                return isSecurityEnabled;
            }
        };
        EndpointReferenceType endpoint = new EndpointReferenceType();
        try {
            endpoint.setAddress((AttributedURI)new Address("http://" + args[0] + ":" + args[1] + "/wsrf/services/gcube/common/vremanagement/GHNManager"));
            GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
            GHNManagerPortType pt = locator.getGHNManagerPortTypePort(endpoint);
            if (isSecurityEnabled) {
                logger.info((Object)("Loading proxy from " + args[5]));
                managerSec.useCredentials((GSSCredential)ProxyUtil.loadProxyCredentials((String)args[5]));
                managerSec.setSecurity((Remote)pt, GCUBESecurityManager.AuthMode.PRIVACY, GCUBESecurityManager.DelegationMode.FULL);
            }
            pt = (GHNManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)GCUBEScope.getScope((String)args[2]), (GCUBESecurityManager[])new GCUBESecurityManager[]{managerSec});
            AddScopeInputParams params = new AddScopeInputParams();
            params.setScope(args[3]);
            params.setMap("");
            pt.addScope(params);
        }
        catch (URI.MalformedURIException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: ");
        System.out.println("\tAddGHNToScopeTest <GHN host> <GHN port> <caller scope> <new VO/VRE> false");
        System.out.println("");
        System.exit(0);
    }

    private static void printUsage2() {
        System.out.println("Usage: ");
        System.out.println("\tAddGHNToScopeTest <GHN host> <GHN port> <caller scope> <new VO/VRE> true <proxy>");
        System.out.println("");
        System.exit(0);
    }
}

