/*
 * Decompiled with CFR 0.152.
 */
package org.globus.axis.providers;

import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.server.ServiceLifecycle;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.enum.Scope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.providers.PrivilegedInvokeMethodAction;
import org.globus.gsi.jaas.JaasSubject;

public class RPCProvider
extends org.apache.axis.providers.java.RPCProvider {
    private static Log logger = LogFactory.getLog((String)RPCProvider.class.getName());

    public Object getServiceObject(MessageContext msgContext, Handler service, String clsName, IntHolder scopeHolder) throws Exception {
        Map mapping = (Map)service.getOption("providerMapping");
        if (mapping == null) {
            return super.getServiceObject(msgContext, service, clsName, scopeHolder);
        }
        OperationDesc operation = msgContext.getOperation();
        if (operation == null) {
            return super.getServiceObject(msgContext, service, clsName, scopeHolder);
        }
        Object provider = mapping.get(operation);
        if (provider == null) {
            return super.getServiceObject(msgContext, service, clsName, scopeHolder);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invoking '" + operation.getName() + "' operation on " + provider));
        }
        Scope scope = Scope.getScope((String)((String)service.getOption("scope")), (Scope)Scope.DEFAULT);
        scopeHolder.value = scope.getValue();
        if (scope == Scope.APPLICATION) {
            return provider;
        }
        return RPCProvider.getNewServiceInstance(msgContext, (Class)provider);
    }

    protected Object invokeMethod(MessageContext msgContext, Method method, Object obj, Object[] argValues) throws Exception {
        Subject subject = (Subject)msgContext.getProperty("invocationSubject");
        if (subject == null) {
            return this.invokeMethodSub(msgContext, method, obj, argValues);
        }
        PrivilegedInvokeMethodAction action = new PrivilegedInvokeMethodAction(this, msgContext, method, obj, argValues);
        try {
            return JaasSubject.doAs((Subject)subject, (PrivilegedExceptionAction)action);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    protected Object invokeMethodSub(MessageContext msgContext, Method method, Object obj, Object[] argValues) throws Exception {
        return super.invokeMethod(msgContext, method, obj, argValues);
    }

    public static Object getNewServiceInstance(MessageContext msgCtx, Class serviceClass) throws Exception {
        Object service = serviceClass.newInstance();
        if (service instanceof ServiceLifecycle) {
            Object ctx = msgCtx.getProperty("servletEndpointContext");
            ((ServiceLifecycle)service).init(ctx);
        }
        return service;
    }
}

