/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.io.OutputStream;
import java.net.Socket;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.util.I18n;
import org.globus.wsrf.container.ServiceDispatcher;
import org.globus.wsrf.container.ServiceRequest;
import org.globus.wsrf.container.ServiceThread;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.utils.Resources;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

class GSIServiceThread
extends ServiceThread {
    private static Log logger = LogFactory.getLog((String)GSIServiceThread.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());

    public GSIServiceThread(ServiceDispatcher dispatcher) {
        super(dispatcher);
    }

    protected String getProtocol() {
        return "https";
    }

    protected void process(ServiceRequest request) {
        logger.debug((Object)(this.getName() + ": processing requests"));
        GSSManager manager = ExtendedGSSManager.getInstance();
        GssSocket gsiSocket = null;
        OutputStream out = null;
        try {
            ExtendedGSSContext extGss;
            X509Certificate[] certs;
            ContainerSecurityConfig config = ContainerSecurityConfig.getConfig();
            config.refresh();
            Subject containerSub = config.getSubject();
            if (containerSub == null) {
                throw new RuntimeException(i18n.getMessage("noValidCreds"));
            }
            GSSCredential credentials = JaasGssUtil.getCredential((Subject)containerSub);
            ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(credentials);
            context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_SSL);
            context.setOption(GSSConstants.ACCEPT_NO_CLIENT_CERTS, (Object)Boolean.TRUE);
            GssSocketFactory factory = GssSocketFactory.getDefault();
            gsiSocket = (GssSocket)factory.createSocket(request.getSocket(), null, 0, (GSSContext)context);
            gsiSocket.setUseClientMode(false);
            gsiSocket.setAuthorization(null);
            out = gsiSocket.getOutputStream();
            String globusID = ((Object)context.getSrcName()).toString();
            logger.debug((Object)(this.getName() + ": Authenticated globus user: " + globusID));
            Subject subject = this.getSubject();
            subject.getPrincipals().add((Principal)new GlobusPrincipal(globusID));
            if (context instanceof ExtendedGSSContext && (certs = (X509Certificate[])(extGss = context).inquireByOid(GSSConstants.X509_CERT_CHAIN)) != null) {
                subject.getPublicCredentials().add(certs);
            }
            this.msgContext.setProperty("org.globus.security.transport.context", (Object)context);
            if (context.getConfState()) {
                this.msgContext.setProperty("org.globus.security.transport.type", (Object)Constants.ENCRYPTION);
            } else if (context.getIntegState()) {
                this.msgContext.setProperty("org.globus.security.transport.type", (Object)Constants.SIGNATURE);
            } else {
                this.msgContext.setProperty("org.globus.security.transport.type", (Object)Constants.NONE);
            }
        }
        catch (Exception e) {
            if (gsiSocket == null) {
                try {
                    request.getSocket().close();
                }
                catch (Exception ee) {}
            } else {
                try {
                    gsiSocket.close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            logger.error((Object)i18n.getMessage("serverFault00"), (Throwable)e);
            return;
        }
        ServiceRequest req = new ServiceRequest((Socket)gsiSocket, request.getServerSocket());
        super.process(req);
    }

    protected Subject getSubject() {
        Subject subject = (Subject)this.msgContext.getProperty("callerSubject");
        if (subject == null) {
            subject = new Subject();
            this.msgContext.setProperty("callerSubject", (Object)subject);
        }
        return subject;
    }
}

