/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.encoding.AnyContentType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicListener;
import org.globus.wsrf.core.notification.ResourcePropertyValueChangeNotificationElementType;
import org.globus.wsrf.encoding.SerializationException;
import org.globus.wsrf.impl.SimpleTopic;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.properties.ResourcePropertyValueChangeNotificationType;
import org.oasis.wsrf.properties.ResourcePropertyValueChangeNotificationTypeNewValue;
import org.oasis.wsrf.properties.ResourcePropertyValueChangeNotificationTypeOldValue;
import org.w3c.dom.Element;

public class ResourcePropertyTopic
implements ResourceProperty,
Topic {
    private static Log logger = LogFactory.getLog((String)ResourcePropertyTopic.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    protected ResourceProperty rp;
    protected Topic topic;
    protected boolean autoNotify = true;
    protected boolean sendOldValue = false;

    protected ResourcePropertyTopic() {
    }

    public ResourcePropertyTopic(ResourceProperty rp, QName qname) {
        if (rp == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"rp"));
        }
        if (qname == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"qname"));
        }
        this.rp = rp;
        this.topic = new SimpleTopic(qname);
    }

    public ResourcePropertyTopic(ResourceProperty rp) {
        if (rp == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"rp"));
        }
        this.rp = rp;
        this.topic = new SimpleTopic(this.rp.getMetaData().getName());
    }

    public ResourceProperty getResourceProperty() {
        return this.rp;
    }

    public QName getName() {
        return this.topic.getName();
    }

    public void addTopic(Topic topic) throws Exception {
        this.topic.addTopic(topic);
    }

    public void addTopicListener(TopicListener listener) {
        this.topic.addTopicListener(listener);
    }

    public Object getCurrentMessage() {
        return this.topic.getCurrentMessage();
    }

    public Topic getTopic(QName topicName) {
        return this.topic.getTopic(topicName);
    }

    public List getTopicPath() {
        return this.topic.getTopicPath();
    }

    public TopicExpressionType getTopicReference() {
        return this.topic.getTopicReference();
    }

    public boolean isReference() {
        return this.topic.isReference();
    }

    public Iterator topicIterator() {
        return this.topic.topicIterator();
    }

    public void notify(Object obj) throws Exception {
        ResourcePropertyValueChangeNotificationElementType message = this.createValueChangeMessage(this.sendOldValue);
        this.setNewValue(message);
        this.topic.notify(message);
    }

    public void removeTopic(Topic topic) {
        this.topic.removeTopic(topic);
    }

    public void removeTopicListener(TopicListener listener) {
        this.topic.removeTopicListener(listener);
    }

    public Iterator topicListenerIterator() {
        return this.topic.topicListenerIterator();
    }

    public void setTopicPath(List topicPath) {
        this.topic.setTopicPath(topicPath);
    }

    public void setTopicReference(TopicExpressionType topicPath) {
        this.topic.setTopicReference(topicPath);
    }

    public boolean autoNotify() {
        return this.autoNotify;
    }

    public void setAutoNotify(boolean autoNotify) {
        this.autoNotify = autoNotify;
    }

    protected void fireNotification(ResourcePropertyValueChangeNotificationElementType message) {
        if (this.autoNotify) {
            try {
                this.topic.notify(message);
            }
            catch (Exception e) {
                logger.error((Object)i18n.getMessage("nodeliver", (Object)message), (Throwable)e);
            }
        }
    }

    public void add(Object value) {
        ResourcePropertyValueChangeNotificationElementType message = this.createValueChangeMessage(this.sendOldValue);
        this.rp.add(value);
        this.setNewValue(message);
        this.fireNotification(message);
    }

    public void set(int index, Object value) {
        ResourcePropertyValueChangeNotificationElementType message = this.createValueChangeMessage(this.sendOldValue);
        this.rp.set(index, value);
        this.setNewValue(message);
        this.fireNotification(message);
    }

    public boolean remove(Object value) {
        ResourcePropertyValueChangeNotificationElementType message = this.createValueChangeMessage(this.sendOldValue);
        boolean rs = this.rp.remove(value);
        if (rs) {
            this.setNewValue(message);
            this.fireNotification(message);
        }
        return rs;
    }

    public Object get(int index) {
        return this.rp.get(index);
    }

    public void clear() {
        this.rp.clear();
    }

    public int size() {
        return this.rp.size();
    }

    public boolean isEmpty() {
        return this.rp.isEmpty();
    }

    public Iterator iterator() {
        return this.rp.iterator();
    }

    public ResourcePropertyMetaData getMetaData() {
        return this.rp.getMetaData();
    }

    public SOAPElement[] toSOAPElements() throws SerializationException {
        return this.rp.toSOAPElements();
    }

    public Element[] toElements() throws SerializationException {
        return this.rp.toElements();
    }

    public boolean getSendOldValue() {
        return this.sendOldValue;
    }

    public void setSendOldValue(boolean sendOldValue) {
        this.sendOldValue = sendOldValue;
    }

    private void setNewValue(ResourcePropertyValueChangeNotificationElementType message) {
        ResourcePropertyValueChangeNotificationTypeNewValue newValue = new ResourcePropertyValueChangeNotificationTypeNewValue();
        if (this.rp.size() != 0) {
            try {
                AnyHelper.setAny((AnyContentType)newValue, this.rp.toSOAPElements());
            }
            catch (Exception e) {
                logger.error((Object)i18n.getMessage("rpSerializationError", (Object)this.rp.getMetaData().getName()), (Throwable)e);
            }
        }
        message.getResourcePropertyValueChangeNotification().setNewValue(newValue);
    }

    private ResourcePropertyValueChangeNotificationElementType createValueChangeMessage(boolean sendOld) {
        ResourcePropertyValueChangeNotificationElementType changeMessage = new ResourcePropertyValueChangeNotificationElementType();
        ResourcePropertyValueChangeNotificationType message = new ResourcePropertyValueChangeNotificationType();
        changeMessage.setResourcePropertyValueChangeNotification(message);
        if (sendOld) {
            ResourcePropertyValueChangeNotificationTypeOldValue oldValue = new ResourcePropertyValueChangeNotificationTypeOldValue();
            if (this.rp.size() != 0) {
                try {
                    AnyHelper.setAny((AnyContentType)oldValue, this.rp.toSOAPElements());
                }
                catch (Exception e) {
                    logger.error((Object)i18n.getMessage("rpSerializationError", (Object)this.rp.getMetaData().getName()), (Throwable)e);
                }
            }
            message.setOldValue(oldValue);
        }
        return changeMessage;
    }
}

