/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.informationsystem.client.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISInputStream;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.impl.AbstractQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class AbstractClient
implements ISClient {
    protected GCUBELog logger = new GCUBELog(this);
    protected static Map<Class<? extends ISQuery<?>>, Class<? extends ISQuery<?>>> implementationMap;
    protected static Map<String, String> genericQueries;

    public AbstractClient() {
        if (implementationMap == null) {
            implementationMap = Collections.synchronizedMap(new HashMap());
            this.loadQueries(implementationMap);
            genericQueries = Collections.synchronizedMap(new HashMap());
            this.loadGenericQueries(genericQueries);
        }
    }

    protected abstract void loadQueries(Map<Class<? extends ISQuery<?>>, Class<? extends ISQuery<?>>> var1);

    protected abstract void loadGenericQueries(Map<String, String> var1);

    @Override
    public <RESULT, QUERY extends ISQuery<RESULT>> QUERY getQuery(Class<QUERY> clazz) throws ISClient.ISUnsupportedQueryException, InstantiationException, IllegalAccessException {
        Class<ISQuery<?>> impl = implementationMap.get(clazz);
        if (impl == null) {
            throw new ISClient.ISUnsupportedQueryException();
        }
        return (QUERY)impl.newInstance();
    }

    @Override
    public abstract <RESULT> List<RESULT> execute(ISQuery<RESULT> var1, GCUBEScope var2) throws ISClient.ISUnsupportedQueryException, ISException;

    protected void checkQuery(ISQuery<?> query) throws ISClient.ISMalformedQueryException, ISClient.ISUnsupportedQueryException {
        if (!this.getQueryBaseClass().isAssignableFrom(query.getClass())) {
            throw new ISClient.ISUnsupportedQueryException();
        }
        AbstractQuery abstractQuery = (AbstractQuery)query;
        if (!abstractQuery.isWellFormed()) {
            throw new ISClient.ISMalformedQueryException();
        }
    }

    @Override
    public abstract <RESULT> ISInputStream<RESULT> executeByRef(ISQuery<RESULT> var1, GCUBEScope var2) throws ISClient.ISMalformedQueryException, ISClient.ISUnsupportedQueryException, ISException;

    protected Class<? extends AbstractQuery> getQueryBaseClass() {
        return AbstractQuery.class;
    }
}

