/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.state;

import java.util.ArrayList;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.state.GCUBEReadWriteLock;
import org.gcube.common.core.state.GCUBEResourceHome;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.scope.api.ScopeProvider;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.lifetime.SetTerminationTimeProvider;

public abstract class GCUBEWSHome
extends GCUBEResourceHome<ResourceKey, GCUBEWSResourceKey, GCUBEWSResource>
implements ResourceHome {
    protected QName keyTypeName;
    protected SweeperScheduler sweeperScheduler;
    private long sweeperDelay = 60L;

    public synchronized void setKeyName(String keyName) {
        if (this.keyTypeName != null) {
            throw new RuntimeException("key name already configured");
        }
        this.keyTypeName = QName.valueOf(keyName);
    }

    public synchronized QName getKeyTypeName() {
        this.keyTypeName = new QName(this.getPortTypeContext().getNamespace(), "ResourceKey");
        return this.keyTypeName;
    }

    public final Class<String> getKeyTypeClass() {
        return String.class;
    }

    public synchronized void setSweeperDelay(long delay) {
        this.sweeperDelay = delay;
    }

    public synchronized long getSweeperDelay() {
        return this.sweeperDelay;
    }

    public abstract GCUBEStatefulPortTypeContext getPortTypeContext();

    @Override
    public GCUBEServiceContext getServiceContext() {
        return this.getPortTypeContext().getServiceContext();
    }

    @Override
    protected void onInitialisation() throws Exception {
        if (!GCUBEWSResource.class.isAssignableFrom(this.resourceClass)) {
            throw new Exception(this.getClass().getSimpleName() + " does not extend " + GCUBEWSResource.class.getSimpleName());
        }
        this.sweeperScheduler = new SweeperScheduler();
        super.onInitialisation();
        this.sweeperScheduler.run();
        this.logger.info("activated sweeper to run every " + this.getSweeperDelay() + " seconds");
    }

    @Override
    protected void onReady() throws Exception {
        super.onReady();
        GCUBEResource.ResourceConsumer consumer = new GCUBEResource.ResourceConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onRemoveScope(GCUBEResource.RemoveScopeEvent event) {
                GCUBEWSHome.this.logger.info("re-assessing scope consistency of all resources after removal of " + ((GCUBEScope[])event.getPayload())[0]);
                for (GCUBEWSResourceKey key : GCUBEWSHome.this.getIdentifiers()) {
                    try {
                        GCUBEWSResource resource = GCUBEWSHome.this.find(key);
                        ScopeProvider.instance.set(((GCUBEScope[])event.getPayload())[0].toString());
                        GCUBEReadWriteLock.GCUBEWriteLock lock = resource.getLock().writeLock();
                        try {
                            lock.lockInterruptibly();
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        try {
                            for (String resScopeExpression : resource.getResourcePropertySet().getScope()) {
                                GCUBEScope resScope = GCUBEScope.getScope(resScopeExpression);
                                try {
                                    GCUBEWSHome.this.getServiceContext().setScope(resScope);
                                }
                                catch (GCUBEScopeManager.IllegalScopeException usedAsTest) {
                                    try {
                                        GCUBEWSHome.this.logger.trace("removing resource from scope " + resScope + " after RI");
                                        ScopeProvider.instance.set(resScope.toString());
                                        ((GCUBEResourceHome)GCUBEWSHome.this).remove(resource);
                                    }
                                    catch (Exception e) {
                                        GCUBEWSHome.this.logger.warn("could not remove " + resource.getClass().getSimpleName() + "(" + resource.getID() + ") from scope " + resScope);
                                    }
                                }
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    catch (Exception e) {
                        GCUBEWSHome.this.logger.debug("problem", e);
                    }
                }
            }
        };
        this.getServiceContext().getInstance().subscribeResourceEvents(consumer, GCUBEResource.ResourceTopic.REMOVESCOPE);
        this.logger.trace("registered for RI scope removal events");
    }

    @Override
    protected void onFailure() throws Exception {
        if (this.sweeperScheduler != null) {
            this.sweeperScheduler.stop();
        }
    }

    @Override
    protected GCUBEWSResource get(ResourceKey id) throws ResourceException, NoSuchResourceException {
        GCUBEWSResource resource = (GCUBEWSResource)super.get(id);
        if (!this.isLegacyCall() && !resource.inScope(this.currentScope())) {
            throw new NoSuchResourceException();
        }
        return resource;
    }

    @Override
    public GCUBEWSResource create(Object ... params) throws ResourceException {
        if (this.isLegacyCall() || !this.isValidScope()) {
            throw new ResourceException((Throwable)new GCUBEScopeManager.IllegalScopeException());
        }
        return (GCUBEWSResource)super.create(params);
    }

    @Override
    public GCUBEWSResource create(GCUBEWSResourceKey id, Object ... params) throws ResourceException {
        if (this.isLegacyCall() || !this.isValidScope()) {
            throw new ResourceException((Throwable)new GCUBEScopeManager.IllegalScopeException());
        }
        return (GCUBEWSResource)super.create(id, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GCUBEWSResource reuse(GCUBEWSResourceKey id, Object ... params) throws ResourceException {
        GCUBEWSResource resource;
        GCUBEScope callScope = this.currentScope();
        ScopeProvider.instance.reset();
        try {
            resource = (GCUBEWSResource)super.reuse(id, params);
        }
        finally {
            this.getServiceContext().setScope(callScope);
        }
        return resource;
    }

    public GCUBEWSResource find() throws ResourceException {
        try {
            return (GCUBEWSResource)ResourceContext.getResourceContext().getResource();
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Override
    public GCUBEWSResource find(ResourceKey id) throws ResourceException, NoSuchResourceException {
        GCUBEWSResource resource = (GCUBEWSResource)super.find(this.convertLegacyID(id));
        if (!this.isLegacyCall() && !this.isValidScope()) {
            throw new NoSuchResourceException();
        }
        return resource;
    }

    @Override
    public void remove(ResourceKey id) throws ResourceException {
        if (this.isLegacyCall() || !this.isValidScope()) {
            throw new ResourceException((Throwable)new GCUBEScopeManager.IllegalScopeException());
        }
        super.remove(this.convertLegacyID(id));
    }

    GCUBEScope currentScope() {
        String currentScope = ScopeProvider.instance.get();
        return currentScope == null ? null : GCUBEScope.getScope(currentScope);
    }

    private boolean isValidScope() throws ResourceException {
        return this.getServiceContext().getInstance().inScope(this.currentScope());
    }

    private boolean isLegacyCall() {
        return this.currentScope() == null;
    }

    private GCUBEWSResourceKey convertLegacyID(ResourceKey id) {
        return id == null ? null : (GCUBEWSResourceKey.class.isAssignableFrom(id.getClass()) ? (GCUBEWSResourceKey)id : new GCUBEWSResourceKey(id));
    }

    @Override
    protected void preInitialise(GCUBEWSResource resource) throws ResourceException {
        super.preInitialise(resource);
        resource.setPortTypeContext(this.getPortTypeContext());
        try {
            resource.initialiseContainers();
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Override
    protected void postInitialise(GCUBEWSResource resource) throws ResourceException {
        super.postInitialise(resource);
        resource.getResourcePropertySet().addScope(this.currentScope());
        resource.publish(this.currentScope());
    }

    @Override
    protected void onReuse(GCUBEWSResource resource) throws ResourceException {
        super.onReuse(resource);
        GCUBEScope callScope = this.currentScope();
        if (resource.getResourcePropertySet().addScope(callScope)) {
            resource.publish(callScope);
        }
    }

    @Override
    protected void onLoad(GCUBEWSResource resource, boolean firstLoad) throws ResourceException {
        super.onLoad(resource, firstLoad);
        if (this.sweeperScheduler.isExpired(resource, new Calendar[0])) {
            String msg = "resource " + this.resourceClass.getSimpleName() + "(" + resource.getID() + ") is expired";
            this.logger.trace(msg);
            this.sweeperScheduler.remove(resource);
            throw new NoSuchResourceException(msg);
        }
        if (firstLoad) {
            ArrayList<GCUBEScope> scopes = new ArrayList<GCUBEScope>();
            for (String s : resource.getResourcePropertySet().getScope()) {
                scopes.add(GCUBEScope.getScope(s));
            }
            resource.publish(scopes.toArray(new GCUBEScope[0]));
        }
    }

    @Override
    protected boolean onRemove(GCUBEWSResource resource) throws ResourceException {
        GCUBEScope callScope = this.currentScope();
        if (!resource.getResourcePropertySet().removeScope(callScope)) {
            throw new ResourceException((Throwable)new GCUBEScopeManager.IllegalScopeException());
        }
        this.logger.info("removing a " + this.resourceClass.getSimpleName() + "(" + resource.getID() + ") from scope " + callScope);
        resource.unpublish(callScope);
        if (resource.getResourcePropertySet().getScope().size() == 0) {
            SetTerminationTimeProvider.sendTerminationNotification((Object)resource);
            return true;
        }
        return false;
    }

    private class SweeperScheduler
    extends GCUBEScheduledHandler<Object> {
        protected SweeperScheduler() {
            super(GCUBEWSHome.this.getSweeperDelay(), GCUBEScheduledHandler.Mode.LAZY, new GCUBEHandler[0]);
            this.setName(GCUBEWSHome.this.getServiceContext().getName() + "-Resource Sweeper-" + GCUBEWSHome.this.getClass().getSimpleName());
            Sweeper sweeper = new Sweeper();
            sweeper.setName(this.getName());
            this.setScheduled(sweeper);
        }

        @Override
        protected boolean repeat(Exception exception, int exceptionCount) {
            if (exception != null) {
                this.logger.warn("could not sweep " + GCUBEWSHome.this.resourceClass.getSimpleName() + " resources", exception);
            }
            return true;
        }

        private boolean isExpired(GCUBEWSResource resource, Calendar ... time) {
            Calendar currentTime = time == null || time.length == 0 ? Calendar.getInstance() : time[0];
            Calendar terminationTime = resource.getTerminationTime();
            return terminationTime != null && terminationTime.before(currentTime);
        }

        protected void remove(GCUBEWSResource resource) {
            for (String scope : resource.getResourcePropertySet().getScope()) {
                GCUBEWSHome.this.getServiceContext().setScope(GCUBEScope.getScope(scope));
                try {
                    ((GCUBEResourceHome)GCUBEWSHome.this).remove(resource);
                }
                catch (Exception e) {
                    this.logger.warn("could not remove " + GCUBEWSHome.this.resourceClass.getSimpleName() + "(" + resource.getID() + ") from scope " + scope + " after expiry", e);
                }
            }
        }

        protected class Sweeper
        extends GCUBEHandler<Object> {
            protected Sweeper() {
            }

            @Override
            public void run() throws Exception {
                ArrayList<GCUBEWSResource> expired = new ArrayList<GCUBEWSResource>();
                Calendar currentTime = Calendar.getInstance();
                for (GCUBEWSResource resource : GCUBEWSHome.this.getResources()) {
                    if (!SweeperScheduler.this.isExpired(resource, new Calendar[]{currentTime})) continue;
                    expired.add(resource);
                }
                if (expired.size() > 0) {
                    this.logger.trace("sweeping " + expired.size() + " expired resource(s)");
                }
                for (GCUBEWSResource resource : expired) {
                    SweeperScheduler.this.remove(resource);
                }
            }
        }
    }
}

