/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.aggregator.impl;

import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.MessageElement;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.aggregator.impl.AggregatorException;
import org.globus.mds.aggregator.impl.AggregatorServiceGroupEntryResource;
import org.globus.mds.aggregator.impl.AggregatorSink;
import org.globus.mds.aggregator.impl.AggregatorSource;
import org.globus.mds.aggregator.types.AggregatorContent;
import org.w3c.dom.Element;

public class ServiceGroupEntryAggregatorSink
implements AggregatorSink {
    private AggregatorSource source = null;
    private boolean initialized = false;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$aggregator$impl$ServiceGroupEntryAggregatorSink == null ? (class$org$globus$mds$aggregator$impl$ServiceGroupEntryAggregatorSink = ServiceGroupEntryAggregatorSink.class$("org.globus.mds.aggregator.impl.ServiceGroupEntryAggregatorSink")) : class$org$globus$mds$aggregator$impl$ServiceGroupEntryAggregatorSink).getName());
    static /* synthetic */ Class class$org$globus$mds$aggregator$impl$ServiceGroupEntryAggregatorSink;

    public void initialize(Object parameters) throws AggregatorException, Exception {
        if (this.initialized) {
            this.terminate();
        }
        if (this.source == null) {
            throw new AggregatorException("Aggregator Source not set!");
        }
        this.initialized = true;
    }

    public AggregatorSource getSource() {
        return this.source;
    }

    public void setSource(AggregatorSource source) {
        this.source = source;
    }

    public void deliver(AnyContentType message, AggregatorServiceGroupEntryResource entry) throws AggregatorException, Exception {
        if (entry == null) {
            logger.error((Object)"Deliver got a null entry parameter - bailing");
            return;
        }
        if (message == null) {
            logger.warn((Object)"Deliver got a null message parameter - bailing");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Processing message...");
        }
        MessageElement[] data = message.get_any();
        if (logger.isDebugEnabled()) {
            if (data != null) {
                logger.debug((Object)("Deliver successfully processed message content into " + Integer.toString(data.length) + " message elements:"));
                for (int i = 0; i < data.length; ++i) {
                    logger.debug((Object)("Message Element (" + Integer.toString(i) + "): " + XMLUtils.ElementToString((Element)data[i])));
                }
            } else {
                logger.debug((Object)"Deliver successuflly received no values.");
            }
        }
        logger.debug((Object)"Updating an AggregatorServiceGroupEntryResource");
        AggregatorContent content = entry.getContent();
        if (content == null || content.getAggregatorData() == null) {
            logger.error((Object)"Found null content or null content data during update");
            return;
        }
        content.getAggregatorData().set_any(data);
        entry.setContent(content);
    }

    public void terminate() {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

