/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import ise.library.GUIUtils;
import ise.library.KappaLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontDialog
extends JDialog {
    public boolean didCancel = false;
    private JLabel sample;
    private String font_name = "Serif";
    private String font_size = "10";
    private boolean bold_on = false;
    private boolean italic_on = false;
    private JList font_list;
    private JComboBox size_list;
    private JTextField font_selection;
    private JTextField size_selection;
    private static JFrame _parent = null;
    private static FontDialog _fd = null;

    public FontDialog(JFrame parent) {
        this(parent, null);
    }

    public FontDialog(JFrame parent, Font font) {
        super(parent, "Select Font", true);
        this.createUI(font);
    }

    private void createUI(Font font) {
        JPanel content_pane = new JPanel();
        content_pane.setLayout(new KappaLayout());
        content_pane.setBorder(new EmptyBorder(6, 6, 6, 6));
        ListSelectionListener lsl = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getSource().equals(FontDialog.this.font_list)) {
                    FontDialog.this.font_name = FontDialog.this.font_list.getSelectedValue().toString();
                    FontDialog.this.font_selection.setText(FontDialog.this.font_name);
                }
                FontDialog.this.setSample();
            }
        };
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FontDialog.this.font_size = FontDialog.this.size_list.getSelectedItem().toString();
                FontDialog.this.setSample();
            }
        };
        JPanel font_panel = new JPanel();
        font_panel.setLayout(new BorderLayout());
        font_panel.setBorder(new TitledBorder("Font:"));
        this.font_selection = new JTextField(this.font_name);
        this.font_selection.setEditable(false);
        font_panel.add((Component)this.font_selection, "North");
        String[] font_names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.font_list = new JList<String>(font_names);
        this.font_list.setSelectionMode(1);
        this.font_list.setSelectedIndex(0);
        this.font_list.addListSelectionListener(lsl);
        font_panel.add((Component)new JScrollPane(this.font_list), "Center");
        JPanel size_panel = new JPanel();
        size_panel.setLayout(new BorderLayout());
        size_panel.setBorder(new TitledBorder("Size:"));
        String[] size_names = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "38", "48", "72"};
        this.size_list = new JComboBox<String>(size_names);
        this.size_list.setEditable(true);
        this.size_list.addActionListener(al);
        this.size_list.setSelectedIndex(2);
        size_panel.add((Component)new JScrollPane(this.size_list), "Center");
        JPanel style_panel = new JPanel();
        style_panel.setLayout(new KappaLayout());
        style_panel.setBorder(new TitledBorder("Style:"));
        final JCheckBox bold_style = new JCheckBox("Bold");
        bold_style.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FontDialog.this.bold_on = bold_style.isSelected();
                FontDialog.this.setSample();
            }
        });
        final JCheckBox italic_style = new JCheckBox("Italic");
        italic_style.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FontDialog.this.italic_on = italic_style.isSelected();
                FontDialog.this.setSample();
            }
        });
        style_panel.add((Component)bold_style, "0, 0, 1, 1, W, wh, 5");
        style_panel.add((Component)italic_style, "0, 1, 1, 1, W, wh, 5");
        JPanel sample_panel = new JPanel();
        sample_panel.setLayout(new BorderLayout());
        sample_panel.setBorder(new TitledBorder("Sample"));
        this.sample = new JLabel("AaBbYyZz", 0);
        sample_panel.add((Component)this.sample, "Center");
        this.setSample();
        KappaLayout layout = new KappaLayout();
        JPanel btn_panel = new JPanel(layout);
        JButton ok_btn = new JButton("Ok");
        JButton cancel_btn = new JButton("Cancel");
        ok_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FontDialog.this.didCancel = false;
                FontDialog.this.setVisible(false);
            }
        });
        cancel_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FontDialog.this.didCancel = true;
                FontDialog.this.setVisible(false);
            }
        });
        btn_panel.add("0,0,1,1,0,w", ok_btn);
        btn_panel.add("1,0", KappaLayout.createHorizontalStrut(5, true));
        btn_panel.add("2,0,1,1,0,w", cancel_btn);
        layout.makeColumnsSameWidth(0, 2);
        content_pane.add("0, 0, 2, 3, N, wh", font_panel);
        content_pane.add("2, 0, 1, 1", KappaLayout.createHorizontalStrut(5, true));
        content_pane.add("3, 0, 2, 1, N, w", size_panel);
        content_pane.add("3, 1, 2, 2, S, wh", style_panel);
        content_pane.add("0, 3, 1, 1", KappaLayout.createVerticalStrut(5, true));
        content_pane.add("0, 4, 5, 1, 0, wh", sample_panel);
        content_pane.add("5, 4, 1, 1", KappaLayout.createVerticalStrut(72));
        content_pane.add("0, 5, 1, 1", KappaLayout.createVerticalStrut(11));
        content_pane.add("0, 6, 5, 1", btn_panel);
        if (font != null) {
            String font_family = font.getFamily();
            int font_style = font.getStyle();
            int font_size = font.getSize();
            this.font_list.setSelectedValue(font_family, true);
            this.size_list.setSelectedItem(String.valueOf(font_size));
            switch (font_style) {
                case 1: {
                    bold_style.setSelected(true);
                    break;
                }
                case 2: {
                    italic_style.setSelected(true);
                    break;
                }
                case 3: {
                    bold_style.setSelected(true);
                    italic_style.setSelected(true);
                }
            }
        }
        this.setContentPane(content_pane);
        this.pack();
    }

    private void setSample() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    int style = 0;
                    if (FontDialog.this.bold_on) {
                        ++style;
                    }
                    if (FontDialog.this.italic_on) {
                        style += 2;
                    }
                    int size = Integer.valueOf(FontDialog.this.font_size);
                    FontDialog.this.sample.setFont(new Font(FontDialog.this.font_name, style, size));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public Font getSelectedFont() {
        return this.sample.getFont();
    }

    public boolean didCancel() {
        return this.didCancel;
    }

    public static Font showFontDialog() {
        return FontDialog.showFontDialog(null);
    }

    public static Font showFontDialog(JFrame parent) {
        return FontDialog.showFontDialog(parent, null);
    }

    public static Font showFontDialog(JFrame parent, Font default_font) {
        if (parent == null || !parent.equals(_parent) || _fd == null) {
            _fd = new FontDialog(parent, default_font);
        }
        _parent = parent;
        GUIUtils.center(parent, _fd);
        _fd.pack();
        _fd.show();
        Font font = _fd.getSelectedFont();
        _fd.dispose();
        if (!_fd.didCancel()) {
            return font;
        }
        return null;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        FontDialog fd = new FontDialog(f);
        fd.show();
        System.out.println(fd.getSelectedFont());
        System.exit(0);
    }
}

