/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container.usage;

import org.globus.usage.packets.CustomByteBuffer;
import org.globus.wsrf.container.usage.ContainerUsageBasePacket;

public class ContainerUsageBasePacketV2
extends ContainerUsageBasePacket {
    public static final short PACKET_VERSION = 2;
    protected String list;
    protected int optionalIntField = -1;

    public ContainerUsageBasePacketV2(short eventType) {
        super(eventType);
        this.setPacketVersion((short)2);
    }

    public void setOptionalIntField(int value) {
        this.optionalIntField = value;
    }

    public int getOptionalIntField() {
        return this.optionalIntField;
    }

    public void setServiceList(String list) {
        this.list = list;
    }

    public String getServiceList() {
        return this.list;
    }

    public void packCustomFields(CustomByteBuffer buf) {
        super.packCustomFields(buf);
        buf.putInt(this.optionalIntField);
        byte[] data = this.list.getBytes();
        buf.putShort((short)data.length);
        int maxLen = Math.min(data.length, buf.remaining());
        buf.put(data, 0, maxLen);
    }

    public void unpackCustomFields(CustomByteBuffer buf) {
        super.unpackCustomFields(buf);
        this.optionalIntField = buf.getInt();
        short len = buf.getShort();
        int maxLen = Math.min(len, buf.remaining());
        byte[] data = new byte[maxLen];
        buf.get(data);
        this.list = new String(data);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append(", optField: " + this.getOptionalIntField());
        buf.append(", services: " + this.getServiceList());
        return buf.toString();
    }
}

