/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLCipherState;
import COM.claymoresystems.ptls.SSLCipherSuite;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLHandshake;
import COM.claymoresystems.ptls.SSLRecord;
import COM.claymoresystems.sslg.CertVerifyPolicyInt;
import COM.claymoresystems.sslg.SSLPolicyInt;
import COM.claymoresystems.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.CertUtil;
import org.globus.gsi.CertificateRevocationLists;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.GlobusGSSException;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.globus.gsi.gssapi.GlobusGSSName;
import org.globus.gsi.gssapi.SSLUtil;
import org.globus.gsi.gssapi.TokenInputStream;
import org.globus.gsi.proxy.ProxyPathValidator;
import org.globus.gsi.proxy.ProxyPathValidatorException;
import org.globus.gsi.proxy.ProxyPolicyHandler;
import org.globus.gsi.ptls.PureTLSContext;
import org.globus.gsi.ptls.PureTLSTrustedCertificates;
import org.globus.gsi.ptls.PureTLSUtil;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GlobusGSSContextImpl
implements ExtendedGSSContext {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$gsi$gssapi$GlobusGSSContextImpl == null ? (class$org$globus$gsi$gssapi$GlobusGSSContextImpl = GlobusGSSContextImpl.class$("org.globus.gsi.gssapi.GlobusGSSContextImpl")) : class$org$globus$gsi$gssapi$GlobusGSSContextImpl).getName());
    private static Log sslLogger = LogFactory.getLog((String)(class$COM$claymoresystems$ptls$SSLDebug == null ? (class$COM$claymoresystems$ptls$SSLDebug = GlobusGSSContextImpl.class$("COM.claymoresystems.ptls.SSLDebug")) : class$COM$claymoresystems$ptls$SSLDebug).getName());
    public static final int GSI_WRAP = 26;
    private static final int GSI_SEQUENCE_SIZE = 8;
    private static final int GSI_MESSAGE_DIGEST_PADDING = 12;
    private static final short[] NO_ENCRYPTION = new short[]{1};
    private static final byte[] DELEGATION_TOKEN = new byte[]{68};
    private static final int UNDEFINED = 0;
    private static final int INITIATE = 1;
    private static final int ACCEPT = 2;
    protected int state = 0;
    private static final int HANDSHAKE = 0;
    private static final int CLIENT_START_DEL = 2;
    private static final int CLIENT_END_DEL = 3;
    private static final int SERVER_START_DEL = 4;
    private static final int SERVER_END_DEL = 5;
    protected int delegationState = 0;
    private static final int DELEGATION_START = 0;
    private static final int DELEGATION_SIGN_CERT = 1;
    private static final int DELEGATION_COMPLETE_CRED = 2;
    protected ExtendedGSSCredential delegatedCred;
    protected boolean delegationFinished = false;
    protected boolean credentialDelegation = false;
    protected boolean anonymity = false;
    protected boolean encryption = true;
    protected boolean established = false;
    protected GSSName sourceName = null;
    protected GSSName targetName = null;
    protected int role = 0;
    protected ExtendedGSSCredential delegCred;
    protected Integer delegationType = GSIConstants.DELEGATION_TYPE_LIMITED;
    protected Integer gssMode = GSIConstants.MODE_GSI;
    protected Boolean checkContextExpiration = Boolean.FALSE;
    protected Boolean rejectLimitedProxy = Boolean.FALSE;
    protected Boolean requireClientAuth = Boolean.TRUE;
    protected Boolean acceptNoClientCerts = Boolean.FALSE;
    protected GlobusGSSCredentialImpl ctxCred;
    protected GSSName expectedTargetName = null;
    protected Date goodUntil = null;
    protected SSLConn conn;
    protected PureTLSContext context;
    protected SSLPolicyInt policy;
    protected TokenInputStream in;
    protected ByteArrayOutputStream out;
    protected BouncyCastleCertProcessingFactory certFactory;
    protected KeyPair keyPair;
    protected TrustedCertificates tc;
    protected Map proxyPolicyHandlers;
    protected Boolean peerLimited = null;
    static /* synthetic */ Class class$org$globus$gsi$gssapi$GlobusGSSContextImpl;
    static /* synthetic */ Class class$COM$claymoresystems$ptls$SSLDebug;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$globus$gsi$proxy$ProxyPolicyHandler;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$globus$gsi$TrustedCertificates;

    public GlobusGSSContextImpl(GSSName target, GlobusGSSCredentialImpl cred) throws GSSException {
        if (cred == null) {
            throw new GSSException(13);
        }
        this.expectedTargetName = target;
        this.ctxCred = cred;
        this.context = new PureTLSContext();
        CertVerifyPolicyInt certPolicy = PureTLSUtil.getDefaultCertVerifyPolicy();
        this.policy = new SSLPolicyInt();
        this.policy.negotiateTLS(false);
        this.policy.waitOnClose(false);
        this.policy.setCertVerifyPolicy(certPolicy);
        this.context.setPolicy(this.policy);
        this.setSSLDebugging();
    }

    private void setSSLDebugging() {
        if (sslLogger.isTraceEnabled()) {
            SSLDebug.setDebug((int)65535);
        } else if (sslLogger.isDebugEnabled()) {
            SSLDebug.setDebug((int)32);
        }
    }

    public byte[] acceptSecContext(byte[] inBuff, int off, int len) throws GSSException {
        logger.debug((Object)"enter acceptSecContext");
        if (this.conn == null) {
            this.role = 2;
            if (this.ctxCred.getName().isAnonymous()) {
                throw new GlobusGSSException(9, 102, "acceptCtx00");
            }
            if (this.ctxCred.getUsage() != 2 && this.ctxCred.getUsage() != 0) {
                throw new GlobusGSSException(9, 102, "badCredUsage");
            }
            this.setCredential();
            this.init(2);
        }
        this.out.reset();
        this.in.putToken(inBuff, off, len);
        switch (this.state) {
            case 0: {
                try {
                    this.conn.getHandshake().processHandshake();
                    if (!this.conn.getHandshake().finishedP()) break;
                    logger.debug((Object)"acceptSecContext handshake finished");
                    this.handshakeFinished();
                    X509Certificate cert = this.ctxCred.getCertificateChain()[0];
                    this.setGoodUntil(cert.getNotAfter());
                    this.targetName = this.ctxCred.getName();
                    Vector chain = this.conn.getCertificateChain();
                    if (chain == null || chain.size() == 0) {
                        this.sourceName = new GlobusGSSName();
                        this.anonymity = true;
                    } else {
                        X509Cert crt = (X509Cert)chain.elementAt(chain.size() - 1);
                        this.setGoodUntil(crt.getValidityNotAfter());
                        String identity = this.verifyChain(chain);
                        this.sourceName = new GlobusGSSName(identity);
                        this.anonymity = false;
                    }
                    if (this.gssMode == GSIConstants.MODE_GSI) {
                        this.state = 4;
                        break;
                    }
                    this.setDone();
                    break;
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
            }
            case 4: {
                try {
                    if (this.in.available() <= 0) {
                        return null;
                    }
                    int delChar = this.conn.getInStream().read();
                    if (delChar != 68) {
                        this.setDone();
                        break;
                    }
                    Vector chain = this.conn.getCertificateChain();
                    if (chain == null || chain.size() == 0) {
                        throw new GlobusGSSException(11, 30, "noClientCert");
                    }
                    X509Certificate tmpCert = PureTLSUtil.convertCert((X509Cert)chain.lastElement());
                    byte[] req = this.generateCertRequest(tmpCert);
                    this.conn.getOutStream().write(req, 0, req.length);
                }
                catch (GeneralSecurityException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                this.state = 5;
                break;
            }
            case 5: {
                try {
                    if (this.in.available() <= 0) {
                        return null;
                    }
                    X509Certificate certificate = CertUtil.loadCertificate(this.conn.getInStream());
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Received delegated cert: " + certificate.toString()));
                    }
                    this.verifyDelegatedCert(certificate);
                    Vector chain = this.conn.getCertificateChain();
                    int chainLen = chain.size();
                    X509Certificate[] newChain = new X509Certificate[chainLen + 1];
                    newChain[0] = certificate;
                    for (int i = 0; i < chainLen; ++i) {
                        newChain[i + 1] = PureTLSUtil.convertCert((X509Cert)chain.elementAt(chainLen - 1 - i));
                    }
                    GlobusCredential proxy = new GlobusCredential(this.keyPair.getPrivate(), newChain);
                    this.delegCred = new GlobusGSSCredentialImpl(proxy, 0);
                }
                catch (GeneralSecurityException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                this.setDone();
                break;
            }
            default: {
                throw new GSSException(11);
            }
        }
        logger.debug((Object)"exit acceptSeContext");
        return this.out.size() > 0 ? this.out.toByteArray() : null;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] initSecContext(byte[] inBuff, int off, int len) throws GSSException {
        GlobusGSSContextImpl.logger.debug((Object)"enter iniSecContext");
        if (this.conn == null) {
            this.role = 1;
            if (this.credentialDelegation) {
                if (this.gssMode == GSIConstants.MODE_SSL) {
                    throw new GlobusGSSException(11, 7, "initCtx00");
                }
                if (this.anonymity) {
                    throw new GlobusGSSException(11, 7, "initCtx01");
                }
            }
            if (this.anonymity || this.ctxCred.getName().isAnonymous()) {
                this.anonymity = true;
            } else {
                this.anonymity = false;
                this.setCredential();
                if (this.ctxCred.getUsage() != 1 && this.ctxCred.getUsage() != 0) {
                    throw new GlobusGSSException(9, 102, "badCredUsage");
                }
            }
            this.init(1);
        }
        if (this.expectedTargetName == null && this.credentialDelegation) {
            throw new GlobusGSSException(11, 7, "initCtx02");
        }
        this.out.reset();
        this.in.putToken(inBuff, off, len);
        switch (this.state) {
            case 0: {
                try {
                    this.conn.getHandshake().processHandshake();
                    if (!this.conn.getHandshake().finishedP()) break;
                    GlobusGSSContextImpl.logger.debug((Object)"iniSecContext handshake finished");
                    this.handshakeFinished();
                    chain = this.conn.getCertificateChain();
                    crt = (X509Cert)chain.elementAt(chain.size() - 1);
                    this.setGoodUntil(crt.getValidityNotAfter());
                    identity = this.verifyChain(chain);
                    this.targetName = new GlobusGSSName(identity);
                    if (this.anonymity) {
                        this.sourceName = new GlobusGSSName();
                    } else {
                        cert = this.ctxCred.getCertificateChain()[0];
                        this.setGoodUntil(cert.getNotAfter());
                        this.sourceName = this.ctxCred.getName();
                    }
                    if (this.expectedTargetName != null && !this.expectedTargetName.equals(this.targetName)) {
                        throw new GlobusGSSException(15, 25, "authFailed00", new Object[]{this.expectedTargetName, this.targetName});
                    }
                    if (this.gssMode != GSIConstants.MODE_GSI) ** GOTO lbl46
                    this.state = 2;
                    if (this.out.size() > 0) {
                        break;
                    }
                    ** GOTO lbl50
lbl46:
                    // 1 sources

                    this.setDone();
                    break;
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
            }
lbl50:
            // 2 sources

            case 2: {
                if (this.state != 2 || this.out.size() > 0) {
                    throw new GSSException(11);
                }
                try {
                    if (this.getCredDelegState()) {
                        this.conn.getOutStream().write(68);
                        this.state = 3;
                        break;
                    }
                    this.conn.getOutStream().write(48);
                    this.setDone();
                    break;
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
            }
            case 3: {
                try {
                    if (this.in.available() <= 0) {
                        return null;
                    }
                    chain = this.ctxCred.getCertificateChain();
                    cert = this.certFactory.createCertificate(this.conn.getInStream(), chain[0], this.ctxCred.getPrivateKey(), -1, this.getDelegationType(chain[0]));
                    enc = cert.getEncoded();
                    this.conn.getOutStream().write(enc, 0, enc.length);
                    this.setDone();
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
            }
            default: {
                throw new GSSException(11);
            }
        }
        GlobusGSSContextImpl.logger.debug((Object)"exit initSecContext");
        return (byte[])(this.out.size() > 0 || this.state == 2 ? this.out.toByteArray() : null);
    }

    private void setDone() {
        this.established = true;
    }

    private void setGoodUntil(Date date) {
        if (this.goodUntil == null) {
            this.goodUntil = date;
        } else if (date.before(this.goodUntil)) {
            this.goodUntil = date;
        }
    }

    private void init(int how) throws GSSException {
        short[] cs;
        if (this.encryption) {
            short[] ciphers = this.policy.getCipherSuites();
            short[] newCiphers = new short[ciphers.length + 1];
            System.arraycopy(ciphers, 0, newCiphers, 0, ciphers.length);
            newCiphers[ciphers.length] = 1;
            cs = newCiphers;
        } else {
            cs = NO_ENCRYPTION;
        }
        this.policy.setCipherSuites(cs);
        this.policy.requireClientAuth(this.requireClientAuth.booleanValue());
        this.policy.setAcceptNoClientCert(this.acceptNoClientCerts.booleanValue());
        this.setTrustedCertificates();
        this.in = new TokenInputStream();
        this.out = new ByteArrayOutputStream();
        try {
            this.conn = new SSLConn(null, (InputStream)this.in, (OutputStream)this.out, (SSLContext)this.context, how);
        }
        catch (IOException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
        this.conn.init();
        this.certFactory = BouncyCastleCertProcessingFactory.getDefault();
        this.state = 0;
    }

    private void handshakeFinished() throws IOException {
        this.conn.finishHandshake();
        SSLCipherSuite cs = SSLCipherSuite.findCipherSuite((int)this.conn.getCipherSuite());
        this.encryption = !cs.getCipherAlg().equals("NULL");
        logger.debug((Object)("encryption alg: " + cs.getCipherAlg()));
    }

    private String verifyChain(Vector peerCerts) throws GSSException {
        X509Certificate[] peerChain = null;
        try {
            peerChain = PureTLSUtil.certificateChainToArray(peerCerts);
        }
        catch (GeneralSecurityException e) {
            throw new GlobusGSSException(9, (Throwable)e);
        }
        GSSProxyPathValidator validator = new GSSProxyPathValidator();
        if (this.proxyPolicyHandlers != null) {
            Iterator iter = this.proxyPolicyHandlers.keySet().iterator();
            while (iter.hasNext()) {
                String oid = (String)iter.next();
                ProxyPolicyHandler handler = (ProxyPolicyHandler)this.proxyPolicyHandlers.get(oid);
                validator.setProxyPolicyHandler(oid, handler);
            }
        }
        CertificateRevocationLists certRevList = CertificateRevocationLists.getDefaultCertificateRevocationLists();
        validator.setRejectLimitedProxyCheck(this.rejectLimitedProxy);
        try {
            validator.validate(peerChain, this.tc, certRevList);
        }
        catch (ProxyPathValidatorException e) {
            if (e.getErrorCode() == 7) {
                throw new GlobusGSSException(15, (Throwable)e);
            }
            throw new GlobusGSSException(9, (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new GlobusGSSException(9, (Throwable)e);
        }
        this.peerLimited = validator.isLimited() ? Boolean.TRUE : Boolean.FALSE;
        return validator.getIdentity();
    }

    private void setCredential() throws GSSException {
        try {
            this.context.setCredential(this.ctxCred.getGlobusCredential());
        }
        catch (GeneralSecurityException e) {
            throw new GlobusGSSException(9, (Throwable)e);
        }
    }

    private void setTrustedCertificates() throws GSSException {
        if (this.tc == null) {
            this.tc = PureTLSTrustedCertificates.getDefaultPureTLSTrustedCertificates();
        }
        if (this.tc == null) {
            throw new GlobusGSSException(9, 102, "noCaCerts");
        }
        try {
            if (this.tc instanceof PureTLSTrustedCertificates) {
                this.context.setRootList(((PureTLSTrustedCertificates)this.tc).getX509CertList());
            } else {
                this.context.setTrustedCertificates(this.tc.getCertificates());
            }
        }
        catch (GeneralSecurityException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
    }

    public byte[] wrap(byte[] inBuf, int off, int len, MessageProp prop) throws GSSException {
        this.checkContext();
        logger.debug((Object)"enter wrap");
        byte[] token = null;
        boolean doGSIWrap = false;
        if (prop != null) {
            if (prop.getQOP() != 0 && prop.getQOP() != 1) {
                throw new GSSException(14);
            }
            boolean bl = doGSIWrap = !prop.getPrivacy() && prop.getQOP() == 1;
        }
        if (doGSIWrap) {
            byte[] mic = this.getMIC(inBuf, off, len, null);
            byte[] wtoken = new byte[5 + len + mic.length];
            wtoken[0] = 26;
            wtoken[1] = 3;
            wtoken[2] = 0;
            wtoken[3] = (byte)(mic.length >>> 8);
            wtoken[4] = (byte)(mic.length >>> 0);
            System.arraycopy(mic, 0, wtoken, 5, mic.length);
            System.arraycopy(inBuf, off, wtoken, 5 + mic.length, len);
            token = wtoken;
        } else {
            token = this.wrap(inBuf, off, len);
            if (prop != null) {
                prop.setPrivacy(this.encryption);
                prop.setQOP(0);
            }
        }
        logger.debug((Object)"exit wrap");
        return token;
    }

    private byte[] wrap(byte[] inBuf, int off, int len) throws GSSException {
        this.out.reset();
        try {
            this.conn.getOutStream().write(inBuf, off, len);
        }
        catch (IOException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
        return this.out.toByteArray();
    }

    public byte[] unwrap(byte[] inBuf, int off, int len, MessageProp prop) throws GSSException {
        this.checkContext();
        logger.debug((Object)"enter unwrap");
        byte[] token = null;
        if (inBuf[off] == 26 && inBuf[off + 1] == 3 && inBuf[off + 2] == 0) {
            short micLen = SSLUtil.toShort(inBuf[off + 3], inBuf[off + 4]);
            int msgLen = len - 5 - micLen;
            if (micLen > len - 5 || msgLen < 0) {
                throw new GSSException(10);
            }
            this.verifyMIC(inBuf, off + 5, micLen, inBuf, off + 5 + micLen, msgLen, null);
            if (prop != null) {
                prop.setPrivacy(false);
                prop.setQOP(1);
            }
            token = new byte[msgLen];
            System.arraycopy(inBuf, off + 5 + micLen, token, 0, msgLen);
        } else {
            token = this.unwrap(inBuf, off, len);
            if (prop != null) {
                prop.setPrivacy(this.encryption);
                prop.setQOP(0);
            }
        }
        logger.debug((Object)"exit unwrap");
        return token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] unwrap(byte[] inBuf, int off, int len) throws GSSException {
        ByteArrayInputStream in = new ByteArrayInputStream(inBuf, off, len);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            block7: while (in.available() > 0) {
                SSLRecord r = new SSLRecord(null);
                r.decode(this.conn, (InputStream)in);
                switch (r.getType().getValue()) {
                    case 23: {
                        out.write(r.getData().getValue());
                        continue block7;
                    }
                    case 21: {
                        this.conn.getRecordReader().processAlert(r.getData().getValue());
                        continue block7;
                    }
                }
            }
            return out.toByteArray();
            throw new Exception("Invalid token");
        }
        catch (IOException e) {
            throw new GlobusGSSException(6, (Throwable)e);
        }
        catch (Exception e) {
            throw new GlobusGSSException(10, (Throwable)e);
        }
    }

    public void dispose() throws GSSException {
        logger.debug((Object)"dipose");
    }

    public boolean isEstablished() {
        return this.established;
    }

    public void requestCredDeleg(boolean state) throws GSSException {
        this.credentialDelegation = state;
    }

    public boolean getCredDelegState() {
        return this.credentialDelegation;
    }

    public boolean isInitiator() throws GSSException {
        if (this.role == 0) {
            throw new GSSException(11);
        }
        return this.role == 1;
    }

    public boolean isProtReady() {
        return this.isEstablished();
    }

    public void requestLifetime(int lifetime) throws GSSException {
        if (lifetime == Integer.MAX_VALUE) {
            throw new GlobusGSSException(11, 102, "badLifetime00");
        }
        if (lifetime != 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, lifetime);
            this.setGoodUntil(calendar.getTime());
        }
    }

    public int getLifetime() {
        if (this.goodUntil != null) {
            return (int)((this.goodUntil.getTime() - System.currentTimeMillis()) / 1000L);
        }
        return -1;
    }

    public Oid getMech() throws GSSException {
        return GSSConstants.MECH_OID;
    }

    public GSSCredential getDelegCred() throws GSSException {
        return this.delegCred;
    }

    public void requestConf(boolean state) throws GSSException {
        this.encryption = state;
    }

    public boolean getConfState() {
        return this.encryption;
    }

    public byte[] getMIC(byte[] inBuf, int off, int len, MessageProp prop) throws GSSException {
        this.checkContext();
        logger.debug((Object)"enter getMic");
        if (prop != null && (prop.getQOP() != 0 || prop.getPrivacy())) {
            throw new GSSException(14);
        }
        SSLCipherState st = this.conn.getWriteCipherState();
        SSLCipherSuite cs = st.getCipherSuite();
        long sequence = this.conn.getWriteSequence();
        byte[] mic = new byte[12 + cs.getDigestOutputLength()];
        System.arraycopy(Util.toBytes((long)sequence), 0, mic, 0, 8);
        System.arraycopy(Util.toBytes((long)len, (int)4), 0, mic, 8, 4);
        this.conn.incrementWriteSequence();
        int pad_ct = cs.getDigestOutputLength() == 16 ? 48 : 40;
        try {
            MessageDigest md = MessageDigest.getInstance(cs.getDigestAlg());
            md.update(st.getMacKey());
            for (int i = 0; i < pad_ct; ++i) {
                md.update(SSLHandshake.pad_1);
            }
            md.update(mic, 0, 12);
            md.update(inBuf, off, len);
            byte[] digest = md.digest();
            System.arraycopy(digest, 0, mic, 12, digest.length);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
        if (prop != null) {
            prop.setPrivacy(false);
            prop.setQOP(0);
        }
        logger.debug((Object)"exit getMic");
        return mic;
    }

    public void verifyMIC(byte[] inTok, int tokOff, int tokLen, byte[] inMsg, int msgOff, int msgLen, MessageProp prop) throws GSSException {
        this.checkContext();
        logger.debug((Object)"enter verifyMic");
        SSLCipherState st = this.conn.getReadCipherState();
        SSLCipherSuite cs = st.getCipherSuite();
        logger.debug((Object)("digest algorithm: " + cs.getDigestAlg()));
        if (tokLen != 12 + cs.getDigestOutputLength()) {
            throw new GlobusGSSException(10, 29, "tokenFail00", new Object[]{new Integer(tokLen), new Integer(12 + cs.getDigestOutputLength())});
        }
        int bufLen = SSLUtil.toInt(inTok, tokOff + 8);
        if (bufLen != msgLen) {
            throw new GlobusGSSException(10, 29, "tokenFail01", new Object[]{new Integer(msgLen), new Integer(bufLen)});
        }
        int pad_ct = cs.getDigestOutputLength() == 16 ? 48 : 40;
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance(cs.getDigestAlg());
            md.update(st.getMacKey());
            for (int i = 0; i < pad_ct; ++i) {
                md.update(SSLHandshake.pad_1);
            }
            md.update(inTok, tokOff, 12);
            md.update(inMsg, msgOff, msgLen);
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
        byte[] token = new byte[tokLen - 12];
        System.arraycopy(inTok, tokOff + 12, token, 0, token.length);
        if (!Arrays.equals(digest, token)) {
            throw new GlobusGSSException(6, 33, "tokenFail02");
        }
        long tokSeq = SSLUtil.toLong(inTok, tokOff);
        long readSeq = this.conn.getReadSequence();
        long seqTest = tokSeq - readSeq;
        logger.debug((Object)("Token seq#   : " + tokSeq));
        logger.debug((Object)("Current seq# : " + readSeq));
        if (seqTest > 0L) {
            throw new GSSException(22);
        }
        if (seqTest < 0L) {
            throw new GSSException(20);
        }
        this.conn.incrementReadSequence();
        if (prop != null) {
            prop.setPrivacy(false);
            prop.setQOP(0);
        }
        logger.debug((Object)"exit verifyMic");
    }

    public int initSecContext(InputStream in, OutputStream out) throws GSSException {
        byte[] inToken = null;
        try {
            inToken = this.conn == null ? new byte[]{} : SSLUtil.readSslMessage(in);
            byte[] outToken = this.initSecContext(inToken, 0, inToken.length);
            if (outToken != null) {
                out.write(outToken);
                return outToken.length;
            }
            return 0;
        }
        catch (IOException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
    }

    public void acceptSecContext(InputStream in, OutputStream out) throws GSSException {
        try {
            byte[] inToken = SSLUtil.readSslMessage(in);
            byte[] outToken = this.acceptSecContext(inToken, 0, inToken.length);
            if (outToken != null) {
                out.write(outToken);
            }
        }
        catch (IOException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
    }

    public GSSName getSrcName() throws GSSException {
        return this.sourceName;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public void requestInteg(boolean state) throws GSSException {
        if (!state) {
            throw new GlobusGSSException(11, 101, "integOn");
        }
    }

    public boolean getIntegState() {
        return true;
    }

    public void requestSequenceDet(boolean state) throws GSSException {
        if (!state) {
            throw new GlobusGSSException(11, 101, "seqDet");
        }
    }

    public boolean getSequenceDetState() {
        return true;
    }

    public void requestReplayDet(boolean state) throws GSSException {
        if (!state) {
            throw new GlobusGSSException(11, 101, "replayDet");
        }
    }

    public boolean getReplayDetState() {
        return true;
    }

    public void requestAnonymity(boolean state) throws GSSException {
        this.anonymity = state;
    }

    public boolean getAnonymityState() {
        return this.anonymity;
    }

    public void requestMutualAuth(boolean state) throws GSSException {
        if (!state) {
            throw new GlobusGSSException(11, 101, "mutualAuthOn");
        }
    }

    public boolean getMutualAuthState() {
        return true;
    }

    protected byte[] generateCertRequest(X509Certificate cert) throws GeneralSecurityException {
        KeyPairGenerator generator = null;
        generator = KeyPairGenerator.getInstance("RSA", "BC");
        int bits = ((RSAPublicKey)cert.getPublicKey()).getModulus().bitLength();
        logger.debug((Object)("Creating " + bits + " bits keypair"));
        generator.initialize(bits);
        long st = System.currentTimeMillis();
        this.keyPair = generator.generateKeyPair();
        logger.debug((Object)("Time to generate key pair: " + (System.currentTimeMillis() - st)));
        return this.certFactory.createCertificateRequest(cert, this.keyPair);
    }

    protected void verifyDelegatedCert(X509Certificate certificate) throws GeneralSecurityException {
        RSAPublicKey pubKey = (RSAPublicKey)certificate.getPublicKey();
        RSAPrivateKey privKey = (RSAPrivateKey)this.keyPair.getPrivate();
        if (!pubKey.getModulus().equals(privKey.getModulus())) {
            throw new GeneralSecurityException("Private/Public key mismatch!");
        }
    }

    protected void checkContext() throws GSSException {
        if (this.conn == null || !this.isEstablished()) {
            throw new GSSException(12);
        }
        if (this.checkContextExpiration.booleanValue() && this.getLifetime() <= 0) {
            throw new GSSException(7);
        }
    }

    protected int getDelegationType(X509Certificate issuer) throws GeneralSecurityException, GSSException {
        int certType = BouncyCastleUtil.getCertificateType(issuer, this.tc);
        int dType = this.delegationType;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Issuer type: " + certType + " delg. type requested: " + dType));
        }
        if (certType == 3) {
            if (dType == 2) {
                return CertUtil.isGsi3Enabled() ? 15 : 11;
            }
            if (dType == 3) {
                return CertUtil.isGsi3Enabled() ? 14 : 10;
            }
            if (CertUtil.isProxy(dType)) {
                return dType;
            }
        } else if (CertUtil.isGsi2Proxy(certType)) {
            if (dType == 2) {
                return 11;
            }
            if (dType == 3) {
                return 10;
            }
            if (CertUtil.isGsi2Proxy(dType)) {
                return dType;
            }
        } else if (CertUtil.isGsi3Proxy(certType)) {
            if (dType == 2) {
                return 15;
            }
            if (dType == 3) {
                return 14;
            }
            if (CertUtil.isGsi3Proxy(dType)) {
                return dType;
            }
        } else if (CertUtil.isGsi4Proxy(certType)) {
            if (dType == 2) {
                return 19;
            }
            if (dType == 3) {
                return 18;
            }
            if (CertUtil.isGsi4Proxy(dType)) {
                return dType;
            }
        }
        throw new GSSException(11);
    }

    protected void setGssMode(Object value) throws GSSException {
        if (!(value instanceof Integer)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"GSS mode", class$java$lang$Integer == null ? (class$java$lang$Integer = GlobusGSSContextImpl.class$("java.lang.Integer")) : class$java$lang$Integer});
        }
        Integer v = (Integer)value;
        if (v != GSIConstants.MODE_GSI && v != GSIConstants.MODE_SSL) {
            throw new GlobusGSSException(11, 101, "badGssMode");
        }
        this.gssMode = v;
    }

    protected void setDelegationType(Object value) throws GSSException {
        if (!(value instanceof Integer)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"delegation type", class$java$lang$Integer == null ? (class$java$lang$Integer = GlobusGSSContextImpl.class$("java.lang.Integer")) : class$java$lang$Integer});
        }
        Integer v = (Integer)value;
        if (v != GSIConstants.DELEGATION_TYPE_FULL && v != GSIConstants.DELEGATION_TYPE_LIMITED) {
            throw new GlobusGSSException(11, 101, "badDelegType");
        }
        this.delegationType = v;
    }

    protected void setCheckContextExpired(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"check context expired", class$java$lang$Boolean == null ? (class$java$lang$Boolean = GlobusGSSContextImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean});
        }
        this.checkContextExpiration = (Boolean)value;
    }

    protected void setRejectLimitedProxy(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"reject limited proxy", class$java$lang$Boolean == null ? (class$java$lang$Boolean = GlobusGSSContextImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean});
        }
        this.rejectLimitedProxy = (Boolean)value;
    }

    protected void setRequireClientAuth(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"require client auth", class$java$lang$Boolean == null ? (class$java$lang$Boolean = GlobusGSSContextImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean});
        }
        this.requireClientAuth = (Boolean)value;
    }

    protected void setAcceptNoClientCerts(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"accept no client certs", class$java$lang$Boolean == null ? (class$java$lang$Boolean = GlobusGSSContextImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean});
        }
        this.acceptNoClientCerts = (Boolean)value;
    }

    protected void setGrimPolicyHandler(Object value) throws GSSException {
        if (!(value instanceof ProxyPolicyHandler)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"GRIM policy handler", class$org$globus$gsi$proxy$ProxyPolicyHandler == null ? (class$org$globus$gsi$proxy$ProxyPolicyHandler = GlobusGSSContextImpl.class$("org.globus.gsi.proxy.ProxyPolicyHandler")) : class$org$globus$gsi$proxy$ProxyPolicyHandler});
        }
        if (this.proxyPolicyHandlers == null) {
            this.proxyPolicyHandlers = new HashMap();
        }
        this.proxyPolicyHandlers.put("1.3.6.1.4.1.3536.1.1.1.7", value);
    }

    protected void setProxyPolicyHandlers(Object value) throws GSSException {
        if (!(value instanceof Map)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"Proxy policy handlers", class$java$util$Map == null ? (class$java$util$Map = GlobusGSSContextImpl.class$("java.util.Map")) : class$java$util$Map});
        }
        this.proxyPolicyHandlers = (Map)value;
    }

    protected void setTrustedCertificates(Object value) throws GSSException {
        if (!(value instanceof TrustedCertificates)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"Trusted certificates", class$org$globus$gsi$TrustedCertificates == null ? (class$org$globus$gsi$TrustedCertificates = GlobusGSSContextImpl.class$("org.globus.gsi.TrustedCertificates")) : class$org$globus$gsi$TrustedCertificates});
        }
        this.tc = (TrustedCertificates)value;
    }

    public void setOption(Oid option, Object value) throws GSSException {
        if (option == null) {
            throw new GlobusGSSException(11, 7, "nullOption");
        }
        if (value == null) {
            throw new GlobusGSSException(11, 7, "nullOptionValue");
        }
        if (option.equals(GSSConstants.GSS_MODE)) {
            this.setGssMode(value);
        } else if (option.equals(GSSConstants.DELEGATION_TYPE)) {
            this.setDelegationType(value);
        } else if (option.equals(GSSConstants.CHECK_CONTEXT_EXPIRATION)) {
            this.setCheckContextExpired(value);
        } else if (option.equals(GSSConstants.REJECT_LIMITED_PROXY)) {
            this.setRejectLimitedProxy(value);
        } else if (option.equals(GSSConstants.REQUIRE_CLIENT_AUTH)) {
            this.setRequireClientAuth(value);
        } else if (option.equals(GSSConstants.GRIM_POLICY_HANDLER)) {
            this.setGrimPolicyHandler(value);
        } else if (option.equals(GSSConstants.TRUSTED_CERTIFICATES)) {
            this.setTrustedCertificates(value);
        } else if (option.equals(GSSConstants.PROXY_POLICY_HANDLERS)) {
            this.setProxyPolicyHandlers(value);
        } else if (option.equals(GSSConstants.ACCEPT_NO_CLIENT_CERTS)) {
            this.setAcceptNoClientCerts(value);
        } else {
            throw new GlobusGSSException(11, 37, "unknownOption", new Object[]{option});
        }
    }

    public Object getOption(Oid option) throws GSSException {
        if (option == null) {
            throw new GlobusGSSException(11, 7, "nullOption");
        }
        if (option.equals(GSSConstants.GSS_MODE)) {
            return this.gssMode;
        }
        if (option.equals(GSSConstants.DELEGATION_TYPE)) {
            return this.delegationType;
        }
        if (option.equals(GSSConstants.CHECK_CONTEXT_EXPIRATION)) {
            return this.checkContextExpiration;
        }
        if (option.equals(GSSConstants.REJECT_LIMITED_PROXY)) {
            return this.rejectLimitedProxy;
        }
        if (option.equals(GSSConstants.REQUIRE_CLIENT_AUTH)) {
            return this.requireClientAuth;
        }
        if (option.equals(GSSConstants.TRUSTED_CERTIFICATES)) {
            return this.tc;
        }
        if (option.equals(GSSConstants.PROXY_POLICY_HANDLERS)) {
            return this.proxyPolicyHandlers;
        }
        if (option.equals(GSSConstants.ACCEPT_NO_CLIENT_CERTS)) {
            return this.acceptNoClientCerts;
        }
        return null;
    }

    public byte[] initDelegation(GSSCredential credential, Oid mechanism, int lifetime, byte[] buf, int off, int len) throws GSSException {
        logger.debug((Object)("Enter initDelegation: " + this.delegationState));
        if (mechanism != null && !mechanism.equals(this.getMech())) {
            throw new GSSException(2);
        }
        if (this.gssMode != GSIConstants.MODE_SSL && buf != null && len > 0) {
            buf = this.unwrap(buf, off, len);
            off = 0;
            len = buf.length;
        }
        byte[] token = null;
        switch (this.delegationState) {
            case 0: {
                this.delegationFinished = false;
                token = DELEGATION_TOKEN;
                this.delegationState = 1;
                break;
            }
            case 1: {
                ByteArrayInputStream inData = new ByteArrayInputStream(buf, off, len);
                if (credential == null) {
                    GlobusGSSManagerImpl manager = new GlobusGSSManagerImpl();
                    credential = ((GSSManager)manager).createCredential(0);
                }
                if (!(credential instanceof GlobusGSSCredentialImpl)) {
                    throw new GSSException(9);
                }
                GlobusCredential cred = ((GlobusGSSCredentialImpl)credential).getGlobusCredential();
                X509Certificate[] chain = cred.getCertificateChain();
                int time = lifetime == 0 ? -1 : lifetime;
                try {
                    X509Certificate cert = this.certFactory.createCertificate(inData, chain[0], cred.getPrivateKey(), time, this.getDelegationType(chain[0]));
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    out.write(cert.getEncoded());
                    for (int i = 0; i < chain.length; ++i) {
                        out.write(chain[i].getEncoded());
                    }
                    token = out.toByteArray();
                }
                catch (Exception e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                this.delegationState = 0;
                this.delegationFinished = true;
                break;
            }
            default: {
                throw new GSSException(11);
            }
        }
        logger.debug((Object)"Exit initDelegation");
        if (this.gssMode != GSIConstants.MODE_SSL && token != null) {
            return this.wrap(token, 0, token.length);
        }
        return token;
    }

    public byte[] acceptDelegation(int lifetime, byte[] buf, int off, int len) throws GSSException {
        logger.debug((Object)("Enter acceptDelegation: " + this.delegationState));
        if (this.gssMode != GSIConstants.MODE_SSL && buf != null && len > 0) {
            buf = this.unwrap(buf, off, len);
            off = 0;
            len = buf.length;
        }
        byte[] token = null;
        switch (this.delegationState) {
            case 0: {
                this.delegationFinished = false;
                if (len != 1 && buf[off] != 68) {
                    throw new GlobusGSSException(11, 30, "delegError00", new Object[]{new Character((char)buf[off])});
                }
                try {
                    Vector certChain = this.conn.getCertificateChain();
                    if (certChain == null || certChain.size() == 0) {
                        throw new GlobusGSSException(11, 30, "noClientCert");
                    }
                    X509Certificate tmpCert = PureTLSUtil.convertCert((X509Cert)certChain.lastElement());
                    token = this.generateCertRequest(tmpCert);
                }
                catch (GeneralSecurityException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                this.delegationState = 2;
                break;
            }
            case 2: {
                ByteArrayInputStream in = new ByteArrayInputStream(buf, off, len);
                X509Certificate[] chain = null;
                LinkedList<X509Certificate> certList = new LinkedList<X509Certificate>();
                X509Certificate cert = null;
                try {
                    while (in.available() > 0) {
                        cert = CertUtil.loadCertificate(in);
                        certList.add(cert);
                    }
                    chain = new X509Certificate[certList.size()];
                    chain = certList.toArray(chain);
                    this.verifyDelegatedCert(chain[0]);
                }
                catch (GeneralSecurityException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                GlobusCredential proxy = new GlobusCredential(this.keyPair.getPrivate(), chain);
                this.delegatedCred = new GlobusGSSCredentialImpl(proxy, 0);
                this.delegationState = 0;
                this.delegationFinished = true;
                break;
            }
            default: {
                throw new GSSException(11);
            }
        }
        logger.debug((Object)"Exit initDelegation");
        if (this.gssMode != GSIConstants.MODE_SSL && token != null) {
            return this.wrap(token, 0, token.length);
        }
        return token;
    }

    public GSSCredential getDelegatedCredential() {
        return this.delegatedCred;
    }

    public boolean isDelegationFinished() {
        return this.delegationFinished;
    }

    public Object inquireByOid(Oid oid) throws GSSException {
        if (oid == null) {
            throw new GlobusGSSException(11, 7, "nullOption");
        }
        if (oid.equals(GSSConstants.X509_CERT_CHAIN)) {
            if (this.isEstablished()) {
                try {
                    Vector peerCerts = this.conn.getCertificateChain();
                    if (peerCerts != null && peerCerts.size() > 0) {
                        return PureTLSUtil.certificateChainToArray(peerCerts);
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new GlobusGSSException(9, (Throwable)e);
                }
            }
        } else if (oid.equals(GSSConstants.RECEIVED_LIMITED_PROXY)) {
            return this.peerLimited;
        }
        return null;
    }

    public int getWrapSizeLimit(int qop, boolean confReq, int maxTokenSize) throws GSSException {
        throw new GSSException(16);
    }

    public void wrap(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        throw new GSSException(16);
    }

    public void unwrap(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        throw new GSSException(16);
    }

    public void getMIC(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        throw new GSSException(16);
    }

    public void verifyMIC(InputStream tokStream, InputStream msgStream, MessageProp msgProp) throws GSSException {
        throw new GSSException(16);
    }

    public void setChannelBinding(ChannelBinding cb) throws GSSException {
        throw new GSSException(16);
    }

    public boolean isTransferable() throws GSSException {
        throw new GSSException(16);
    }

    public byte[] export() throws GSSException {
        throw new GSSException(16);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class GSSProxyPathValidator
    extends ProxyPathValidator {
        GSSProxyPathValidator() {
        }

        public void validate(X509Certificate[] certPath, TrustedCertificates trustedCerts, CertificateRevocationLists crlsList) throws ProxyPathValidatorException {
            super.validate(certPath, trustedCerts, crlsList);
        }
    }
}

