/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.client.proxy;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.authorization.client.Binder;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.client.proxy.AuthorizationEntryCache;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.BannedService;
import org.gcube.common.authorization.library.BannedServices;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.common.scope.api.ScopeProvider;

public class DefaultAuthorizationProxy
implements AuthorizationProxy {
    private final ProxyDelegate<String> delegate;
    private static Map<String, AuthorizationEntryCache> cache = new HashMap<String, AuthorizationEntryCache>();

    public DefaultAuthorizationProxy(ProxyDelegate<String> config) {
        this.delegate = config;
    }

    @Override
    public String generate(final String userName, final List<String> roles) {
        Call<String, String> call = new Call<String, String>(){

            public String call(String endpoint) throws Exception {
                StringBuilder rolesQueryString = new StringBuilder();
                for (String role : roles) {
                    rolesQueryString.append(role).append(",");
                }
                rolesQueryString.deleteCharAt(rolesQueryString.lastIndexOf(","));
                String callUrl = endpoint + "/generate/" + userName + "?roles=" + rolesQueryString.toString();
                URL url = new URL(callUrl);
                HttpURLConnection connection = DefaultAuthorizationProxy.this.makeRequest(url, "POST");
                if (connection.getResponseCode() != 200) {
                    throw new Exception("error contacting authorization service");
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
                    String line;
                    StringBuilder result = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        result.append(line);
                    }
                    String string = result.toString();
                    return string;
                }
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public AuthorizationEntry get(final String token) throws ObjectNotFound {
        Call<String, AuthorizationEntry> call = new Call<String, AuthorizationEntry>(){

            public AuthorizationEntry call(String endpoint) throws Exception {
                URL url = new URL(endpoint + "/retrieve/" + token);
                HttpURLConnection connection = DefaultAuthorizationProxy.this.makeRequest(url, "GET");
                if (connection.getResponseCode() == 404) {
                    throw new ObjectNotFound("token " + token + " not found");
                }
                if (connection.getResponseCode() != 200) {
                    throw new Exception("error contacting authorization service");
                }
                if (connection.getContentLengthLong() <= 0L) {
                    return null;
                }
                try (InputStream stream = (InputStream)connection.getContent();){
                    AuthorizationEntry entry = (AuthorizationEntry)Binder.getContext().createUnmarshaller().unmarshal(stream);
                    cache.put(token, new AuthorizationEntryCache(entry));
                    AuthorizationEntry authorizationEntry = entry;
                    return authorizationEntry;
                }
            }
        };
        if (cache.containsKey(token) && cache.get(token).isValid()) {
            return cache.get(token).getEntry();
        }
        try {
            return (AuthorizationEntry)this.delegate.make((Call)call);
        }
        catch (ObjectNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public BannedService deny(final String userName, final String serviceClass, final String serviceName) {
        Call<String, BannedService> call = new Call<String, BannedService>(){

            public BannedService call(String endpoint) throws Exception {
                URL url = new URL(endpoint + "/deny/" + userName + "/" + serviceClass + "/" + serviceName);
                HttpURLConnection connection = DefaultAuthorizationProxy.this.makeRequest(url, "POST");
                if (connection.getResponseCode() != 200 && connection.getResponseCode() != 200) {
                    throw new Exception("error contacting authorization service");
                }
                if (connection.getContentLengthLong() <= 0L) {
                    return null;
                }
                try (InputStream stream = (InputStream)connection.getContent();){
                    BannedService service;
                    BannedService bannedService = service = (BannedService)Binder.getContext().createUnmarshaller().unmarshal(stream);
                    return bannedService;
                }
            }
        };
        try {
            return (BannedService)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public void allow(final String userName, final String serviceClass, final String serviceName) {
        Call<String, JAXWSUtils.Empty> call = new Call<String, JAXWSUtils.Empty>(){

            public JAXWSUtils.Empty call(String endpoint) throws Exception {
                URL url = new URL(endpoint + "/deny/" + userName + "/" + serviceClass + "/" + serviceName);
                HttpURLConnection connection = DefaultAuthorizationProxy.this.makeRequest(url, "DELETE");
                if (connection.getResponseCode() < 200 || connection.getResponseCode() > 206) {
                    throw new Exception("error contacting authorization service");
                }
                return new JAXWSUtils.Empty();
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<BannedService> getBannedServices(final String userName) {
        Call<String, List<BannedService>> call = new Call<String, List<BannedService>>(){

            public List<BannedService> call(String endpoint) throws Exception {
                URL url = new URL(endpoint + "/deny/" + userName);
                HttpURLConnection connection = DefaultAuthorizationProxy.this.makeRequest(url, "GET");
                if (connection.getResponseCode() != 200) {
                    throw new Exception("error contacting authorization service");
                }
                if (connection.getContentLengthLong() <= 0L) {
                    return Collections.emptyList();
                }
                try (InputStream stream = (InputStream)connection.getContent();){
                    BannedServices services = (BannedServices)Binder.getContext().createUnmarshaller().unmarshal(stream);
                    if (services.get() == null) {
                        List<BannedService> list = Collections.emptyList();
                        return list;
                    }
                    List list = services.get();
                    return list;
                }
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    private HttpURLConnection makeRequest(URL url, String method) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("gcube-scope", ScopeProvider.instance.get());
        connection.setRequestMethod(method);
        return connection;
    }
}

