/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.resultset.elements;

import java.io.InputStream;
import java.util.Vector;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.RecordAttribute;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBBase;

public class ResultElementBLOBGeneric
extends ResultElementBLOBBase {
    public static final String RECORD_ID_NAME = "DocID";
    public static final String RECORD_COLLECTION_NAME = "CollID";
    private String payload;
    private InputStream content;

    public ResultElementBLOBGeneric() {
    }

    public ResultElementBLOBGeneric(String id, String collection, String payload, InputStream content) throws Exception {
        Vector<RecordAttribute> at = new Vector<RecordAttribute>();
        at.add(new RecordAttribute(RECORD_ID_NAME, id));
        at.add(new RecordAttribute(RECORD_COLLECTION_NAME, collection));
        this.setRecordAttributes(at.toArray(new RecordAttribute[0]));
        this.payload = payload == null || payload.trim().length() == 0 ? null : payload;
        this.content = content;
    }

    private void setPayload(String payload) {
        this.payload = payload;
    }

    public String getPayload() {
        return this.payload;
    }

    @Override
    public void close() throws Exception {
        try {
            this.content.close();
        }
        catch (Exception e) {
            throw new Exception("Could not close the underlying stream", e);
        }
    }

    @Override
    public void setContentOfBLOB(InputStream content) throws Exception {
        this.content = content;
    }

    @Override
    public InputStream getContentOfBLOB() throws Exception {
        return this.content;
    }

    @Override
    public String toXML() throws Exception {
        return this.payload;
    }

    @Override
    public void fromXML(String xml) throws Exception {
        try {
            this.setPayload(xml);
        }
        catch (Exception e) {
            throw new Exception("provided xml string is not valid ResultSelement serialization", e);
        }
    }
}

