/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.common.security.impl;

import org.gcube.soa3.connector.common.security.Credentials;

public class FederatedCredentials
implements Credentials {
    private final String FEDERATED = "FED";
    private String assertionId;
    private String headerString;
    private boolean isReady;

    public FederatedCredentials(String assertionId) {
        this.assertionId = assertionId;
        this.isReady = false;
    }

    @Override
    public void prepareCredentials() {
        if (!this.isReady) {
            this.headerString = "FED " + this.assertionId;
            this.isReady = true;
        }
    }

    @Override
    public String getAuthenticationType() {
        return "FED";
    }

    @Override
    public String getHeaderString() {
        return this.headerString;
    }

    @Override
    public String getAuthenticationString() {
        return this.assertionId;
    }

    @Override
    public void disposeCredentials() {
        this.headerString = null;
        this.isReady = false;
    }

    @Override
    public boolean isPrepared() {
        return this.isReady;
    }
}

