/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.proxy.local;

import gr.uoa.di.madgik.commons.channel.events.ChannelState;
import gr.uoa.di.madgik.commons.channel.proxy.IChannelLocator;
import gr.uoa.di.madgik.commons.channel.proxy.IChannelProxy;
import gr.uoa.di.madgik.commons.channel.proxy.local.LocalChannelLocator;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistry;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryEntry;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryKey;
import gr.uoa.di.madgik.commons.channel.registry.RegisteredNozzle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalChannelProxy
implements IChannelProxy {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(LocalChannelProxy.class.getName());
    private ChannelRegistryKey RegistryKey = null;
    private IChannelLocator Locator = null;
    private String NozzleID = null;

    protected LocalChannelProxy() {
    }

    public LocalChannelProxy(IChannelLocator Locator, String NozzleID) {
        this.NozzleID = NozzleID;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Creating Local Proxy");
        }
        if (!this.CanHandleProxyLocator(Locator.GetLocatorType()).booleanValue()) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "LocalProxy cannot handle locators of type " + Locator.GetLocatorType().toString());
            }
            throw new IllegalArgumentException("LocalProxy cannot handle locators of type " + Locator.GetLocatorType().toString());
        }
        if (!(Locator instanceof LocalChannelLocator)) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Incompatible declared and found types of locators");
            }
            throw new IllegalArgumentException("Incompatible declared and found types of locators");
        }
        this.Locator = Locator;
        ChannelRegistryEntry entry = ChannelRegistry.Retrieve(Locator.GetRegistryKey());
        if (entry == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Registry does not contain entry for regtistry key " + this.Locator.GetRegistryKey());
            }
            throw new IllegalArgumentException("Registry does not contain etnry for regtistry key " + this.Locator.GetRegistryKey());
        }
        if (!entry.RegisterNozzle(new RegisteredNozzle(this.NozzleID, null))) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Registry does not permit this registration of this nozzle");
            }
            throw new IllegalArgumentException("Registry does not permit this registration of this nozzle");
        }
    }

    @Override
    public ChannelState GetChannelState() {
        return ChannelRegistry.Retrieve(this.Locator.GetRegistryKey()).GetState();
    }

    @Override
    public Boolean CanHandleProxyLocator(IChannelLocator.LocatorType Locator) {
        if (Locator == IChannelLocator.LocatorType.Local) {
            return true;
        }
        return false;
    }

    @Override
    public void Dispose() {
        ChannelRegistryEntry entry = ChannelRegistry.Retrieve(this.RegistryKey);
        if (entry == null || this.NozzleID == null) {
            return;
        }
        for (RegisteredNozzle rn : entry.GetRegisteredNozzles()) {
            if (!rn.GetNozzleID().equals(this.NozzleID)) continue;
            rn.Dispose();
            break;
        }
    }

    @Override
    public IChannelLocator GetLocator() {
        if (this.Locator == null) {
            if (this.RegistryKey == null || this.RegistryKey.GetUniqueID() == null) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Nozzle not yet registered. Cannot create Locator");
                }
                throw new IllegalStateException("Nozzle not yet registered. Cannot create Locator");
            }
            this.Locator = new LocalChannelLocator();
            this.Locator.SetRegistryKey(this.RegistryKey);
        }
        return this.Locator;
    }

    @Override
    public IChannelProxy.ProxyConnector GetProxyType() {
        return IChannelProxy.ProxyConnector.Local;
    }

    @Override
    public void SetChannelRegistryKey(ChannelRegistryKey RegistryKey) {
        this.RegistryKey = RegistryKey;
    }

    @Override
    public Boolean HasConnected() {
        return ChannelRegistry.Retrieve(this.RegistryKey).HasConnected();
    }

    @Override
    public Boolean StillConnected() {
        return ChannelRegistry.Retrieve(this.RegistryKey).StillConnected();
    }
}

