/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.glite.security.util.CertUtil;
import org.glite.security.voms.BasicVOMSTrustStore;
import org.glite.security.voms.FQAN;
import org.glite.security.voms.VOMSAttribute;
import org.glite.security.voms.ac.ACTrustStore;
import org.glite.security.voms.ac.ACValidator;
import org.glite.security.voms.ac.AttributeCertificate;

public class VOMSValidator {
    static Logger log = Logger.getLogger((Class)VOMSValidator.class);
    public static final String VOMS_EXT_OID = "1.3.6.1.4.1.8005.100.100.5";
    protected static ACTrustStore theTrustStore;
    protected ACValidator myValidator;
    protected X509Certificate[] myValidatedChain;
    protected Vector myVomsAttributes = new Vector();
    protected boolean isParsed = false;
    protected boolean isValidated = false;
    protected FQANTree myFQANTree = null;

    public VOMSValidator(X509Certificate validatedCert) {
        this(new X509Certificate[]{validatedCert});
    }

    public VOMSValidator(X509Certificate[] validatedChain) {
        this(validatedChain, null);
    }

    public VOMSValidator(X509Certificate[] validatedChain, ACValidator acValidator) {
        this.myValidatedChain = validatedChain;
        if (acValidator == null && theTrustStore == null) {
            theTrustStore = new BasicVOMSTrustStore();
        }
        this.myValidator = acValidator == null ? new ACValidator(theTrustStore) : acValidator;
    }

    public static void setTrustStore(ACTrustStore trustStore) {
        theTrustStore = trustStore;
    }

    public VOMSValidator setClientChain(X509Certificate[] validatedChain) {
        this.myValidatedChain = validatedChain;
        this.myVomsAttributes = new Vector();
        this.myFQANTree = null;
        this.isParsed = false;
        this.isValidated = false;
        return this;
    }

    public static Vector parse(X509Certificate[] myValidatedChain) {
        int clientIdx;
        if (log.isDebugEnabled()) {
            log.debug((Object)"VOMSValidator : parsing cert chain");
        }
        if ((clientIdx = CertUtil.findClientCert(myValidatedChain)) < 0) {
            log.error((Object)"VOMSValidator : no client cert found in cert chain");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing VOMS attributes for subject " + myValidatedChain[clientIdx].getSubjectX500Principal().getName()));
        }
        Vector<VOMSAttribute> myVomsAttributes = new Vector<VOMSAttribute>();
        for (int i = 0; i < myValidatedChain.length; ++i) {
            byte[] payload = myValidatedChain[i].getExtensionValue(VOMS_EXT_OID);
            if (payload == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No VOMS extension in certificate issued to " + myValidatedChain[i].getSubjectX500Principal().getName()));
                continue;
            }
            try {
                payload = ((DEROctetString)new DERInputStream((InputStream)new ByteArrayInputStream(payload)).readObject()).getOctets();
                ASN1Sequence seq1 = (ASN1Sequence)new DERInputStream((InputStream)new ByteArrayInputStream(payload)).readObject();
                Enumeration e1 = seq1.getObjects();
                while (e1.hasMoreElements()) {
                    ASN1Sequence seq2 = (ASN1Sequence)e1.nextElement();
                    Enumeration e2 = seq2.getObjects();
                    while (e2.hasMoreElements()) {
                        AttributeCertificate ac = new AttributeCertificate((ASN1Sequence)e2.nextElement());
                        for (int j = clientIdx; j < myValidatedChain.length; ++j) {
                            if (ac.getHolder().isHolder(myValidatedChain[j])) {
                                VOMSAttribute va = new VOMSAttribute(ac);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Found VOMS attribute from " + va.getHostPort() + " in certificate issued to " + myValidatedChain[j].getSubjectX500Principal().getName()));
                                }
                                myVomsAttributes.add(va);
                                continue;
                            }
                            log.debug((Object)"VOMS attribute cert found, but holder checking failed!");
                        }
                    }
                }
                continue;
            }
            catch (Exception e) {
                log.info((Object)("Error parsing VOMS extension in certificate issued to " + myValidatedChain[i].getSubjectX500Principal().getName()), (Throwable)e);
                throw new IllegalArgumentException("Error parsing VOMS extension in certificate issued to " + myValidatedChain[i].getSubjectX500Principal().getName() + "error was:" + e.getMessage());
            }
        }
        return myVomsAttributes;
    }

    public VOMSValidator parse() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"VOMSValidator : parsing cert chain");
        }
        if (this.isParsed) {
            return this;
        }
        int clientIdx = CertUtil.findClientCert(this.myValidatedChain);
        if (clientIdx < 0) {
            log.error((Object)"VOMSValidator : no client cert found in cert chain");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing VOMS attributes for subject " + this.myValidatedChain[clientIdx].getSubjectX500Principal().getName()));
        }
        for (int i = 0; i < this.myValidatedChain.length; ++i) {
            byte[] payload = this.myValidatedChain[i].getExtensionValue(VOMS_EXT_OID);
            if (payload == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No VOMS extension in certificate issued to " + this.myValidatedChain[i].getSubjectX500Principal().getName()));
                continue;
            }
            try {
                payload = ((DEROctetString)new DERInputStream((InputStream)new ByteArrayInputStream(payload)).readObject()).getOctets();
                ASN1Sequence seq1 = (ASN1Sequence)new DERInputStream((InputStream)new ByteArrayInputStream(payload)).readObject();
                Enumeration e1 = seq1.getObjects();
                while (e1.hasMoreElements()) {
                    ASN1Sequence seq2 = (ASN1Sequence)e1.nextElement();
                    Enumeration e2 = seq2.getObjects();
                    while (e2.hasMoreElements()) {
                        AttributeCertificate ac = new AttributeCertificate((ASN1Sequence)e2.nextElement());
                        for (int j = clientIdx; j < this.myValidatedChain.length; ++j) {
                            if (ac.getHolder().isHolder(this.myValidatedChain[j])) {
                                VOMSAttribute va = new VOMSAttribute(ac);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Found VOMS attribute from " + va.getHostPort() + " in certificate issued to " + this.myValidatedChain[j].getSubjectX500Principal().getName()));
                                }
                                this.myVomsAttributes.add(va);
                                continue;
                            }
                            log.debug((Object)"VOMS attribute cert found, but holder checking failed!");
                        }
                    }
                }
                continue;
            }
            catch (Exception e) {
                log.info((Object)("Error parsing VOMS extension in certificate issued to " + this.myValidatedChain[i].getSubjectX500Principal().getName()), (Throwable)e);
            }
        }
        this.isParsed = true;
        return this;
    }

    public VOMSValidator validate() {
        if (this.isValidated) {
            return this;
        }
        if (!this.isParsed) {
            this.myVomsAttributes = VOMSValidator.parse(this.myValidatedChain);
            this.isParsed = true;
        }
        ListIterator i = this.myVomsAttributes.listIterator();
        while (i.hasNext()) {
            AttributeCertificate ac = ((VOMSAttribute)i.next()).getAC();
            if (this.myValidator.validate(ac)) continue;
            i.remove();
        }
        this.isValidated = true;
        return this;
    }

    private void populate() {
        if (!this.isParsed && !this.isValidated) {
            throw new IllegalStateException("VOMSValidator: trying to populate FQAN tree before call to parse() or validate()");
        }
        this.myFQANTree = new FQANTree();
        ListIterator i = this.myVomsAttributes.listIterator();
        while (i.hasNext()) {
            this.myFQANTree.add(((VOMSAttribute)i.next()).getListOfFQAN());
        }
    }

    public List getVOMSAttributes() {
        return this.myVomsAttributes;
    }

    public List getRoles(String subGroup) {
        if (!this.isParsed && !this.isValidated) {
            throw new IllegalStateException("Must call parse() or validate() first");
        }
        if (this.myFQANTree == null) {
            this.populate();
        }
        return this.myFQANTree.getRoles(subGroup);
    }

    public List getCapabilities(String subGroup) {
        if (!this.isParsed && !this.isValidated) {
            throw new IllegalStateException("Must call parse() or validate() first");
        }
        if (this.myFQANTree == null) {
            this.populate();
        }
        return this.myFQANTree.getCapabilities(subGroup);
    }

    public boolean isValidated() {
        return this.isValidated;
    }

    public String toString() {
        return "isParsed : " + this.isParsed + "\nisValidated : " + this.isValidated + "\nVOMS attrs:" + this.myVomsAttributes;
    }

    public class FQANTree {
        Hashtable myTree = new Hashtable();
        Hashtable myResults = new Hashtable();

        public void add(List fqans) {
            if (fqans == null) {
                return;
            }
            Iterator i = fqans.iterator();
            while (i.hasNext()) {
                this.add((FQAN)i.next());
            }
        }

        public void add(FQAN fqan) {
            String group = fqan.getGroup();
            Vector<FQAN> v = (Vector<FQAN>)this.myTree.get(group);
            if (v == null) {
                v = new Vector<FQAN>();
                this.myTree.put(group, v);
            }
            if (!v.contains(fqan)) {
                v.add(fqan);
            }
        }

        protected RoleCaps traverse(String voGroup) {
            RoleCaps rc = (RoleCaps)this.myResults.get(voGroup);
            if (rc != null) {
                return rc;
            }
            rc = new RoleCaps();
            StringTokenizer tok = new StringTokenizer(voGroup, "/", true);
            StringBuffer sb = new StringBuffer();
            while (tok.hasMoreTokens()) {
                sb.append(tok.nextToken());
                rc.add((Vector)this.myTree.get(sb.toString()));
            }
            this.myResults.put(voGroup, rc);
            return rc;
        }

        public List getRoles(String voGroup) {
            return this.traverse(voGroup).getRoles();
        }

        public List getCapabilities(String voGroup) {
            return this.traverse(voGroup).getCapabilities();
        }
    }

    class RoleCaps {
        List roles;
        List caps;

        RoleCaps() {
        }

        void add(List v, String s) {
            if (s == null) {
                return;
            }
            if (!v.contains(s)) {
                v.add(s);
            }
        }

        public void add(Vector fqans) {
            if (fqans == null) {
                return;
            }
            if (this.roles == null) {
                this.roles = new Vector();
                this.caps = new Vector();
            }
            Iterator i = fqans.iterator();
            while (i.hasNext()) {
                FQAN f = (FQAN)i.next();
                this.add(this.roles, f.getRole());
                this.add(this.caps, f.getCapability());
            }
        }

        public List getRoles() {
            return this.roles;
        }

        public List getCapabilities() {
            return this.caps;
        }
    }
}

