/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AbstractQueryStringHandler;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QSWSDLHandler
extends AbstractQueryStringHandler {
    public void invoke(MessageContext msgContext) throws AxisFault {
        block7: {
            this.configureFromContext(msgContext);
            AxisServer engine = (AxisServer)msgContext.getProperty("transport.http.plugin.engine");
            PrintWriter writer = (PrintWriter)msgContext.getProperty("transport.http.plugin.writer");
            HttpServletResponse response = (HttpServletResponse)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
            try {
                engine.generateWSDL(msgContext);
                Document wsdlDoc = (Document)msgContext.getProperty("WSDL");
                if (wsdlDoc != null) {
                    try {
                        this.updateSoapAddressLocationURLs(wsdlDoc, msgContext);
                    }
                    catch (RuntimeException re) {
                        this.log.warn("Failed to update soap:address location URL(s) in WSDL.", re);
                    }
                    response.setContentType("text/xml; charset=" + XMLUtils.getEncoding().toLowerCase());
                    this.reportWSDL(wsdlDoc, writer);
                    break block7;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("processWsdlRequest: failed to create WSDL");
                }
                this.reportNoWSDL(response, writer, "noWSDL02", null);
            }
            catch (AxisFault axisFault) {
                if (axisFault.getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                    this.processAxisFault(axisFault);
                    response.setStatus(404);
                    this.reportNoWSDL(response, writer, "noWSDL01", axisFault);
                }
                throw axisFault;
            }
        }
    }

    public void reportWSDL(Document doc, PrintWriter writer) {
        XMLUtils.PrettyDocumentToWriter(doc, writer);
    }

    public void reportNoWSDL(HttpServletResponse res, PrintWriter writer, String moreDetailCode, AxisFault axisFault) {
        res.setStatus(404);
        res.setContentType("text/html");
        writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        writer.println("<p>" + Messages.getMessage("noWSDL00") + "</p>");
        if (moreDetailCode != null) {
            writer.println("<p>" + Messages.getMessage(moreDetailCode) + "</p>");
        }
        if (axisFault != null && this.isDevelopment()) {
            this.writeFault(writer, axisFault);
        }
    }

    protected void updateSoapAddressLocationURLs(Document wsdlDoc, MessageContext msgContext) throws AxisFault {
        NodeList soapAddresses = wsdlDoc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", "address");
        if (soapAddresses == null || soapAddresses.getLength() == 0) {
            soapAddresses = wsdlDoc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap12/", "address");
        }
        if (soapAddresses != null) {
            String endpointURL = this.getEndpointURL(msgContext);
            this.log.debug("Setting soap:address location values in WSDL for service " + msgContext.getTargetService() + " to: " + endpointURL);
            for (int i = 0; i < soapAddresses.getLength(); ++i) {
                Node locationAttrib = soapAddresses.item(i).getAttributes().getNamedItem("location");
                locationAttrib.setNodeValue(endpointURL);
            }
        }
    }

    protected String getEndpointURL(MessageContext msgContext) throws AxisFault {
        String locationUrl = msgContext.getStrProp("axis.wsdlgen.serv.loc.url");
        if (locationUrl == null) {
            locationUrl = msgContext.getService().getInitializedServiceDesc(msgContext).getEndpointURL();
        }
        if (locationUrl == null) {
            locationUrl = msgContext.getStrProp("transport.url");
        }
        return locationUrl;
    }
}

