/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security.util;

import java.io.ByteArrayInputStream;
import java.util.Vector;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.dom.DOMSource;
import org.apache.axis.AxisFault;
import org.apache.ws.security.util.StringUtil;
import org.apache.xml.security.c14n.Canonicalizer;
import org.w3c.dom.Document;

public class AxisUtil {
    public static SOAPMessage toSOAPMessage(Document doc) throws Exception {
        Canonicalizer c14n = Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        byte[] canonicalMessage = c14n.canonicalizeSubtree(doc);
        ByteArrayInputStream in = new ByteArrayInputStream(canonicalMessage);
        MessageFactory factory = MessageFactory.newInstance();
        return factory.createMessage(null, in);
    }

    public static SOAPMessage updateSOAPMessage(Document doc, SOAPMessage message) throws Exception {
        DOMSource domSource = new DOMSource(doc);
        message.getSOAPPart().setContent(domSource);
        return message;
    }

    public static int decodeAction(String action, Vector actions2) throws AxisFault {
        int doAction = 0;
        if (action == null) {
            return doAction;
        }
        String[] single = StringUtil.split(action, ' ');
        for (int i = 0; i < single.length; ++i) {
            if (single[i].equals("NoSecurity")) {
                doAction = 0;
                return doAction;
            }
            if (single[i].equals("UsernameToken")) {
                doAction |= 1;
                actions2.add(new Integer(1));
                continue;
            }
            if (single[i].equals("Signature")) {
                doAction |= 2;
                actions2.add(new Integer(2));
                continue;
            }
            if (single[i].equals("Encrypt")) {
                doAction |= 4;
                actions2.add(new Integer(4));
                continue;
            }
            if (single[i].equals("SAMLTokenUnsigned")) {
                doAction |= 8;
                actions2.add(new Integer(8));
                continue;
            }
            if (single[i].equals("SAMLTokenSigned")) {
                doAction |= 0x10;
                actions2.add(new Integer(16));
                continue;
            }
            if (single[i].equals("Timestamp")) {
                doAction |= 0x20;
                actions2.add(new Integer(32));
                continue;
            }
            if (single[i].equals("NoSerialization")) {
                doAction |= 0x100;
                actions2.add(new Integer(256));
                continue;
            }
            if (single[i].equals("UsernameTokenSignature")) {
                doAction |= 0x40;
                actions2.add(new Integer(64));
                continue;
            }
            throw new AxisFault("WSDoAllSender: Unknown action defined" + single[i]);
        }
        return doAction;
    }
}

