/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation.dkAlgo;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkAlgo.DerivationAlgorithm;

public class P_SHA1
implements DerivationAlgorithm {
    private byte[] secret;
    private String seed;

    public byte[] createKey(byte[] secret, String labelAndNonce, int offset, long length) throws ConversationException {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            byte[] key = new String(P_SHA1.P_hash(secret, labelAndNonce.getBytes(), mac, offset + (int)length)).substring(offset, (int)length).getBytes();
            return key;
        }
        catch (Exception ex) {
            throw new ConversationException("Key Derivation : P_SHA-1: " + ex.getMessage());
        }
    }

    private static byte[] P_hash(byte[] secret, byte[] seed, Mac mac, int required) throws Exception {
        byte[] out = new byte[required];
        int offset = 0;
        byte[] A = seed;
        while (required > 0) {
            SecretKeySpec key = new SecretKeySpec(secret, "HMACSHA1");
            mac.init(key);
            mac.update(A);
            A = mac.doFinal();
            mac.reset();
            mac.init(key);
            mac.update(A);
            mac.update(seed);
            byte[] tmp = mac.doFinal();
            int tocpy = P_SHA1.min(required, tmp.length);
            System.arraycopy(tmp, 0, out, offset, tocpy);
            offset += tocpy;
            required -= tocpy;
        }
        return out;
    }

    private static int min(int a, int b) {
        return a > b ? b : a;
    }
}

