/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.aggregator.impl;

import commonj.timers.Timer;
import commonj.timers.TimerListener;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.aggregator.impl.AggregatorException;
import org.globus.mds.aggregator.impl.AggregatorParamTypeNotSupportedException;
import org.globus.mds.aggregator.impl.AggregatorServiceGroupEntryResource;
import org.globus.mds.aggregator.impl.AggregatorSink;
import org.globus.mds.aggregator.impl.AggregatorSource;
import org.globus.mds.aggregator.types.AggregatorConfig;
import org.globus.mds.aggregator.types.AggregatorPollType;
import org.globus.wsrf.encoding.DeserializationException;
import org.globus.wsrf.impl.timer.TimerManagerImpl;

public abstract class PollingAggregatorSource
implements AggregatorSource {
    public static final int DEFAULT_POLL_INTERVAL = 60000;
    private AggregatorSink sink = null;
    private Object sinkParameters = null;
    private Hashtable sessions = new Hashtable();
    private TimerManagerImpl timerManager = new TimerManagerImpl();
    private boolean initialized = false;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$aggregator$impl$PollingAggregatorSource == null ? (class$org$globus$mds$aggregator$impl$PollingAggregatorSource = PollingAggregatorSource.class$("org.globus.mds.aggregator.impl.PollingAggregatorSource")) : class$org$globus$mds$aggregator$impl$PollingAggregatorSource).getName());
    static /* synthetic */ Class class$org$globus$mds$aggregator$impl$PollingAggregatorSource;

    public PollingAggregatorSource(AggregatorSink sink, Object sinkParameters) {
        this.setAggregatorSink(sink, sinkParameters);
    }

    public PollingAggregatorSource(AggregatorSink sink) {
        this.setAggregatorSink(sink, null);
    }

    public void initialize(Object parameters) throws AggregatorException, Exception {
        if (this.initialized) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Reinitializing");
            }
            this.terminate();
        }
        if (this.getAggregatorSink() == null) {
            throw new AggregatorException("Aggregator Sink not set!");
        }
        this.sink.initialize(this.sinkParameters);
        this.initialized = true;
    }

    public AggregatorServiceGroupEntryResource getSessionContext(String sessionKey) {
        QueryTimerListener q = (QueryTimerListener)this.sessions.get(sessionKey);
        return q.getEntry();
    }

    public String getSessionKey(AggregatorServiceGroupEntryResource entry) throws AggregatorException {
        QueryTimerListener timer;
        if (entry == null) {
            throw new AggregatorException("Null Argument");
        }
        String key = "";
        Iterator keys = this.sessions.keySet().iterator();
        while (keys.hasNext() && !entry.equals((timer = (QueryTimerListener)this.sessions.get(key = (String)keys.next())).getEntry())) {
        }
        return key;
    }

    public boolean isValidSession(String sessionKey) throws AggregatorException {
        return this.sessions.containsKey(sessionKey);
    }

    public AggregatorSink getAggregatorSink() {
        return this.sink;
    }

    public void setAggregatorSink(AggregatorSink sink, Object sinkParameters) {
        this.sink = sink;
        if (this.sink != null) {
            this.sink.setSource(this);
            this.sinkParameters = sinkParameters;
        }
    }

    public String addAggregation(Object parameters, AggregatorServiceGroupEntryResource entry) throws AggregatorParamTypeNotSupportedException, AggregatorException, Exception {
        if (!this.initialized) {
            throw new AggregatorException("Not Initialized");
        }
        AggregatorConfig config = (AggregatorConfig)parameters;
        MessageElement[] any = config.get_any();
        if (any == null) {
            throw new AggregatorException("Got null any from AggregatorConfig");
        }
        AggregatorPollType aggrParams = null;
        for (int i = 0; i < any.length && aggrParams == null; ++i) {
            try {
                aggrParams = this.deserializeParameter(any[i]);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"Exception deserializing parameters: ", (Throwable)e);
            }
        }
        if (aggrParams == null) {
            throw new AggregatorParamTypeNotSupportedException();
        }
        QueryTimerListener queryTimerListener = new QueryTimerListener(aggrParams, entry, config);
        Timer timer = this.timerManager.schedule((TimerListener)queryTimerListener, 0L, (long)aggrParams.getPollIntervalMillis());
        queryTimerListener.setTimer(timer);
        String sessionKey = queryTimerListener.getSessionKey();
        this.sessions.put(sessionKey, queryTimerListener);
        return sessionKey;
    }

    public void removeAggregation(String sessionKey) throws AggregatorException, Exception {
        QueryTimerListener queryTimerListener = (QueryTimerListener)this.sessions.remove(sessionKey);
        if (queryTimerListener == null) {
            logger.debug((Object)(sessionKey + ": Timer not found"));
            return;
        }
        queryTimerListener.getTimer().cancel();
    }

    public void terminate() {
        if (!this.initialized) {
            return;
        }
        Iterator keys = this.sessions.keySet().iterator();
        while (keys.hasNext()) {
            try {
                this.removeAggregation((String)keys.next());
            }
            catch (Exception e) {
                logger.error((Object)("Exception during removeAggregation: " + e));
            }
        }
        this.getAggregatorSink().terminate();
        this.initialized = false;
    }

    public abstract AnyContentType poll(AggregatorPollType var1, EndpointReferenceType var2, AggregatorConfig var3);

    public abstract AggregatorPollType deserializeParameter(MessageElement var1) throws DeserializationException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class QueryTimerListener
    implements TimerListener {
        private final AggregatorPollType parameters;
        private final AggregatorServiceGroupEntryResource entry;
        private final AggregatorConfig config;
        private Timer timer;
        public final String sessionKey = "PollAggr-" + this.hashCode();

        public QueryTimerListener(AggregatorPollType parameters, AggregatorServiceGroupEntryResource entry, AggregatorConfig config) {
            this.parameters = parameters;
            this.entry = entry;
            this.config = config;
        }

        public String getSessionKey() {
            return this.sessionKey;
        }

        public void setTimer(Timer t) {
            this.timer = t;
        }

        public Timer getTimer() {
            return this.timer;
        }

        public AggregatorPollType getParameters() {
            return this.parameters;
        }

        public AggregatorServiceGroupEntryResource getEntry() {
            return this.entry;
        }

        public void timerExpired(Timer timer) {
            AggregatorSink sink = PollingAggregatorSource.this.getAggregatorSink();
            if (sink == null) {
                logger.debug((Object)"AggregatorSink is null, query event cancelled");
                try {
                    PollingAggregatorSource.this.removeAggregation(this.sessionKey);
                }
                catch (Exception e) {
                    logger.warn((Object)e.toString());
                }
                return;
            }
            EndpointReferenceType epr = this.entry.getMemberEPR();
            AnyContentType response = null;
            response = PollingAggregatorSource.this.poll(this.parameters, epr, this.config);
            if (response == null) {
                logger.debug((Object)"Poll operation returned null - will not deliver null response to AggregatorSink");
            } else {
                try {
                    sink.deliver(response, this.entry);
                }
                catch (Exception e) {
                    logger.error((Object)("Delivery failure: " + e));
                }
            }
        }
    }
}

