/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.utils;

import java.io.StringReader;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.descriptor.AuthMethod;
import org.globus.wsrf.impl.security.descriptor.AuthMethodParserCallback;
import org.globus.wsrf.impl.security.descriptor.GSIAuthMethodParserImpl;
import org.globus.wsrf.impl.security.descriptor.GSISecureMsgParserImpl;
import org.globus.wsrf.impl.security.descriptor.GSITransportParserImpl;
import org.globus.wsrf.impl.security.descriptor.NoneAuthMethod;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.impl.security.descriptor.util.ElementHandler;
import org.globus.wsrf.impl.security.descriptor.util.ElementParser;
import org.globus.wsrf.impl.security.descriptor.util.ElementParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class AuthMethodParser
implements ElementHandler {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.descriptor.errors");
    public static final QName QNAME = new QName("http://www.globus.org", "auth-method");
    protected AuthMethodParserCallback callback;
    public static final String AUTH_GSI_SEC_MSG = "GSISecureMessage";
    public static final String AUTH_GSI_SEC_CONV = "GSISecureConversation";
    public static final String AUTH_GSI_TRANSPORT = "GSITransport";
    public static final String AUTH_NONE = "none";

    public AuthMethodParser(AuthMethodParserCallback callback) {
        this.callback = callback;
    }

    public void parse(Element elem) throws ElementParserException {
        ElementParser.checkElement((Element)elem, (QName)QNAME);
        Vector<Object> methods = new Vector<Object>();
        boolean none = false;
        for (Node currentChild = elem.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            QName qName;
            if (currentChild.getNodeType() != 1) continue;
            String name = currentChild.getLocalName();
            if (name.equalsIgnoreCase(AUTH_GSI_SEC_CONV)) {
                if (none) {
                    throw new SecurityDescriptorException(i18n.getMessage("cannotMix"));
                }
                qName = new QName("http://www.globus.org", name);
                GSIAuthMethodParserImpl gsiParser = new GSIAuthMethodParserImpl(qName);
                gsiParser.parse((Element)currentChild);
                methods.add(gsiParser.getMethod());
                continue;
            }
            if (name.equalsIgnoreCase(AUTH_GSI_SEC_MSG)) {
                if (none) {
                    throw new SecurityDescriptorException(i18n.getMessage("cannotMix"));
                }
                qName = new QName("http://www.globus.org", name);
                GSISecureMsgParserImpl secMsgParser = new GSISecureMsgParserImpl(qName);
                secMsgParser.parse((Element)currentChild);
                methods.add(secMsgParser.getMethod());
                continue;
            }
            if (name.equalsIgnoreCase(AUTH_GSI_TRANSPORT)) {
                if (none) {
                    throw new SecurityDescriptorException(i18n.getMessage("cannotMix"));
                }
                qName = new QName("http://www.globus.org", name);
                GSITransportParserImpl transParser = new GSITransportParserImpl(qName);
                transParser.parse((Element)currentChild);
                methods.add(transParser.getMethod());
                continue;
            }
            if (name.equalsIgnoreCase(AUTH_NONE)) {
                if (methods.size() > 0) {
                    throw new SecurityDescriptorException(i18n.getMessage("cannotMix"));
                }
                none = true;
                methods.add(NoneAuthMethod.getInstance());
                continue;
            }
            throw new SecurityDescriptorException(i18n.getMessage("badAuthMethod", (Object)name));
        }
    }

    public static String getAuthMethodsAsString(List methods) {
        StringBuffer buf = new StringBuffer();
        int size = methods.size();
        for (int i = 0; i < size; ++i) {
            AuthMethod method = (AuthMethod)methods.get(i);
            buf.append(method.getName());
            if (i + 1 >= size) continue;
            buf.append(i18n.getMessage("methodOr"));
        }
        return buf.toString();
    }

    public static Element stringToElement(String nodeAsString) throws Exception {
        Document xml = AuthMethodParser.string2Document(nodeAsString);
        Element element = xml.getDocumentElement();
        return element;
    }

    public static Document string2Document(String xmlString) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(xmlString)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return doc;
    }

    public static void main(String[] args) throws Exception {
        String prova = "<auth-metho xmlns=\"http://www.globus.org\"><GSITransport><protection-level><integrity/><privacy/></protection-level></GSITransport></auth-metho>";
        Element auth = AuthMethodParser.stringToElement(prova);
        AuthMethodParser parser = new AuthMethodParser(null);
        parser.parse(auth);
    }
}

