/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.reader;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.proxy.IReaderProxy;
import gr.uoa.di.madgik.grs.proxy.ProxyFactory;
import gr.uoa.di.madgik.grs.reader.ForwardReaderIterator;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderInvalidArgumentException;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.utils.ProgressiveTimeoutGenerator;
import java.net.URI;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class ForwardReader<T extends Record>
implements IRecordReader<T>,
Iterable<T> {
    public static final int DefaultIteratorTimeout = 10;
    public static final TimeUnit DefaultIteratorTimeUnit = TimeUnit.SECONDS;
    private IBuffer buffer = null;
    private IReaderProxy proxy = null;
    private Object immediateNotificationObject = new Object();
    private long iteratorTimeout = 10L;
    private TimeUnit iteratorTimeUnit = DefaultIteratorTimeUnit;
    private long currentRecordIndex = -1L;

    public ForwardReader(URI locator) throws GRS2ReaderException {
        try {
            this.proxy = ProxyFactory.getProxy(locator);
            this.buffer = this.proxy.getBuffer();
            this.immediateNotificationObject = this.buffer.getReaderImmediateNotificationObject();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to initialize the reader", ex);
        }
    }

    public ForwardReader(URI locator, int capacity) throws GRS2ReaderException {
        try {
            this.proxy = ProxyFactory.getProxy(locator);
            this.proxy.overrideBufferCapacity(capacity);
            this.buffer = this.proxy.getBuffer();
            this.immediateNotificationObject = this.buffer.getReaderImmediateNotificationObject();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to initialize the reader", ex);
        }
    }

    @Override
    public RecordDefinition[] getRecordDefinitions() throws GRS2ReaderException {
        try {
            return this.buffer.getRecordDefinitions();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve the record definitions", ex);
        }
    }

    @Override
    public long getInactivityTimeout() throws GRS2ReaderException {
        try {
            return this.buffer.getInactivityTimeout();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve buffer's inactivity timeout", ex);
        }
    }

    @Override
    public TimeUnit getInactivityTimeUnit() throws GRS2ReaderException {
        try {
            return this.buffer.getInactivityTimeUnit();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve buffer's inactivity time unit", ex);
        }
    }

    @Override
    public void setIteratorTimeout(long iteratorTimeout) {
        this.iteratorTimeout = iteratorTimeout;
    }

    @Override
    public long getIteratorTimeout() {
        return this.iteratorTimeout;
    }

    @Override
    public void setIteratorTimeUnit(TimeUnit iteratorTimeUnit) {
        this.iteratorTimeUnit = iteratorTimeUnit;
    }

    @Override
    public TimeUnit getIteratorTimeUnit() {
        return this.iteratorTimeUnit;
    }

    @Override
    public int getCapacity() throws GRS2ReaderException {
        try {
            return this.buffer.getCapacity();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve capacity", ex);
        }
    }

    @Override
    public int getConcurrentPartialCapacity() throws GRS2ReaderException {
        try {
            return this.buffer.getConcurrentPartialCapacity();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve concurrent partial capacity", ex);
        }
    }

    @Override
    public synchronized IBuffer.Status getStatus() {
        return this.buffer.getStatus();
    }

    @Override
    public synchronized void close() throws GRS2ReaderException {
        try {
            if (this.buffer.getStatus() == IBuffer.Status.Dispose) {
                return;
            }
            this.buffer.close();
            this.buffer.dispose();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to close reader", ex);
        }
    }

    @Override
    public synchronized long totalRecords() throws GRS2ReaderException {
        try {
            return this.buffer.totalRecords();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve total record count", ex);
        }
    }

    @Override
    public synchronized int availableRecords() throws GRS2ReaderException {
        try {
            return this.buffer.availableRecords();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve available record count", ex);
        }
    }

    @Override
    public long currentRecord() throws GRS2ReaderException {
        if (this.currentRecordIndex == -1L) {
            throw new GRS2ReaderException("no records retrieved");
        }
        return this.currentRecordIndex;
    }

    @Override
    public synchronized T get() throws GRS2ReaderException {
        try {
            Record item = this.buffer.get();
            if (item != null) {
                ++this.currentRecordIndex;
            }
            return (T)item;
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve record", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized T get(long timeout, TimeUnit unit) throws GRS2ReaderException {
        try {
            ProgressiveTimeoutGenerator ptg = new ProgressiveTimeoutGenerator(unit.toMillis(timeout));
            Record item = null;
            while (this.buffer.getStatus() != IBuffer.Status.Dispose && (this.buffer.getStatus() != IBuffer.Status.Close || this.buffer.availableRecords() != 0) && (item = this.buffer.get()) == null && ptg.hasNext()) {
                Object object = this.immediateNotificationObject;
                synchronized (object) {
                    try {
                        this.immediateNotificationObject.wait(ptg.next());
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            if (item != null) {
                ++this.currentRecordIndex;
            }
            return (T)item;
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve record", ex);
        }
    }

    @Override
    public long seek(long len) throws GRS2ReaderException {
        try {
            T rec;
            if (len == 0L) {
                return 0L;
            }
            if (len < 0L) {
                throw new GRS2ReaderInvalidArgumentException("seek length must be non negative");
            }
            int newLen = 0;
            for (long i = 0L; i < len && (rec = this.get(this.getIteratorTimeout(), this.getIteratorTimeUnit())) != null; ++i) {
                ++newLen;
            }
            this.currentRecordIndex += (long)newLen;
            return newLen;
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to seek", ex);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ForwardReaderIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean waitAvailable(long timeout, TimeUnit unit) throws GRS2ReaderException {
        try {
            long expirationTime = System.currentTimeMillis() + unit.toMillis(timeout);
            boolean item = false;
            while (this.buffer.getStatus() != IBuffer.Status.Dispose && (this.buffer.getStatus() != IBuffer.Status.Close || this.buffer.availableRecords() != 0)) {
                long timeLeft;
                if (this.buffer.availableRecords() > 0) {
                    item = true;
                }
                if (item || (timeLeft = expirationTime - System.currentTimeMillis()) <= 0L) break;
                Object object = this.immediateNotificationObject;
                synchronized (object) {
                    try {
                        this.immediateNotificationObject.wait(timeLeft);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            return item;
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to seek", ex);
        }
    }

    @Override
    public synchronized void emit(BufferEvent event) throws GRS2ReaderException, GRS2ReaderInvalidArgumentException {
        if (event == null) {
            throw new GRS2ReaderInvalidArgumentException("event cannot be null");
        }
        try {
            event.setSource(BufferEvent.EventSource.Reader);
            this.buffer.emit(event);
        }
        catch (GRS2BufferException e) {
            throw new GRS2ReaderException("unable to emit event", e);
        }
    }

    @Override
    public synchronized BufferEvent receive() throws GRS2ReaderException {
        try {
            return this.buffer.receive(BufferEvent.EventSource.Writer);
        }
        catch (GRS2BufferException e) {
            throw new GRS2ReaderException("unable to receive event", e);
        }
    }
}

