/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.reader;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.reader.RandomReader;
import gr.uoa.di.madgik.grs.record.GRS2ExceptionWrapper;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.exception.GRS2UncheckedException;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class RandomReaderIterator<T extends Record>
implements ListIterator<T> {
    private RandomReader<T> reader = null;
    private boolean timeoutExpired = false;

    protected RandomReaderIterator(RandomReader<T> reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.reader.canCallNext()) {
                return true;
            }
            if (this.reader.getStatus() == IBuffer.Status.Dispose || this.reader.getStatus() == IBuffer.Status.Close && this.reader.availableRecords() == 0) {
                return false;
            }
            if (this.reader.availableRecords() == 0) {
                if (this.timeoutExpired) {
                    return false;
                }
                boolean bl = this.timeoutExpired = !this.reader.waitAvailable(this.reader.getIteratorTimeout(), this.reader.getIteratorTimeUnit());
                if (this.timeoutExpired) {
                    this.reader.close();
                }
            }
            return !this.timeoutExpired;
        }
        catch (GRS2ReaderException e) {
            return false;
        }
    }

    @Override
    public T next() {
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T rec = this.reader.get(this.reader.getIteratorTimeout(), this.reader.getIteratorTimeUnit());
            if (rec instanceof GRS2ExceptionWrapper) {
                GRS2UncheckedException ex = new GRS2UncheckedException("writer error", ((GRS2ExceptionWrapper)rec).getEx());
                throw ex;
            }
            return rec;
        }
        catch (GRS2ReaderException e) {
            return null;
        }
    }

    @Override
    public boolean hasPrevious() {
        return this.reader.canCallPrevious();
    }

    @Override
    public T previous() {
        try {
            this.reader.seek(-2L);
            return this.reader.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int nextIndex() {
        throw new IllegalStateException("Operation not supported");
    }

    @Override
    public int previousIndex() {
        throw new IllegalStateException("Operation not supported");
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Operation not supported");
    }

    @Override
    public void set(T o) {
        throw new IllegalStateException("Operation not supported");
    }

    @Override
    public void add(T o) {
        throw new IllegalStateException("Operation not supported");
    }
}

