/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.store.event;

import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.store.buffer.CacheBufferStore;
import gr.uoa.di.madgik.grs.store.event.GRS2EventStoreAccessException;
import gr.uoa.di.madgik.grs.store.event.GRS2EventStoreException;
import gr.uoa.di.madgik.grs.store.event.IEventStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.UUID;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

public class CacheEventStore
implements IEventStore {
    private static final int KeepInMemoryDef = 1000;
    private static final MemoryStoreEvictionPolicy EvictionPolicyDef = MemoryStoreEvictionPolicy.FIFO;
    private CacheManager manager = CacheBufferStore.manager;
    private Cache cache = null;
    private UUID id = UUID.randomUUID();
    private String name = "gRSEventStoreCache" + this.id;
    private long eventCount = 0L;

    public CacheEventStore(int keepInMemory, MemoryStoreEvictionPolicy evictionPolicy) {
        this.cache = new Cache(this.name, keepInMemory, evictionPolicy, true, null, true, 0L, 0L, false, 0L, null);
        this.cache.setName(this.name);
        this.manager.addCache(this.cache);
        this.eventCount = 0L;
    }

    public CacheEventStore(int keepInMemory) {
        this(keepInMemory, EvictionPolicyDef);
    }

    public CacheEventStore() {
        this(1000, EvictionPolicyDef);
    }

    @Override
    public long getEventCount() {
        return this.eventCount;
    }

    @Override
    public synchronized void dispose() throws GRS2EventStoreException {
        try {
            this.cache.dispose();
            this.cache = null;
            this.manager.removeCache(this.name);
        }
        catch (Exception e) {
            throw new GRS2EventStoreException("Could not dispose persistency manager resources", e);
        }
    }

    @Override
    public synchronized void persist(BufferEvent event) throws GRS2EventStoreException {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bOut);
            out.writeUTF(event.getClass().getName());
            event.deflate(out);
            this.cache.putQuiet(new Element((Serializable)((Object)Long.valueOf(this.eventCount).toString()), (Serializable)bOut.toByteArray()));
            ++this.eventCount;
        }
        catch (Exception e) {
            throw new GRS2EventStoreAccessException("Could not persist event", e);
        }
    }

    @Override
    public synchronized BufferEvent retrieveByIndex(long eventIndex) throws GRS2EventStoreException {
        try {
            Element element = this.cache.getQuiet((Serializable)Long.valueOf(eventIndex));
            if (element == null) {
                return null;
            }
            byte[] bIn = (byte[])element.getObjectValue();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bIn));
            String eventType = in.readUTF();
            BufferEvent event = (BufferEvent)Class.forName(eventType).newInstance();
            event.inflate(in);
            return event;
        }
        catch (Exception e) {
            throw new GRS2EventStoreAccessException("Could not retrieve event", e);
        }
    }
}

