/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.PersistenceCallback;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceIdentifier;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.Subscription;
import org.globus.wsrf.impl.ResourceHomeImpl;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.notification.SubscriptionCreationException;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.properties.QueryExpressionType;

public class SubscriptionHome
extends ResourceHomeImpl {
    private static Log logger = LogFactory.getLog((String)SubscriptionHome.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    private Constructor resourceConstructor;

    public synchronized void initialize() throws Exception {
        super.initialize();
        this.resourceConstructor = this.resourceClass.getConstructor(EndpointReferenceType.class, EndpointReferenceType.class, Calendar.class, Object.class, QueryExpressionType.class, QueryExpressionType.class, ResourceKey.class, String.class, TopicExpressionType.class, Boolean.TYPE, Boolean.TYPE, ClientSecurityDescriptor.class, ResourceSecurityDescriptor.class);
    }

    public ResourceKey create(EndpointReferenceType consumerReference, EndpointReferenceType producerReference, Calendar initialTerminationTime, Object subscriptionPolicy, QueryExpressionType precondition, QueryExpressionType selector, ResourceKey producerKey, String producerHomeLocation, TopicExpressionType topicPathExpression, boolean useNotify, ClientSecurityDescriptor notificationSecurityDescriptor, ResourceSecurityDescriptor resourceSecurityDescriptor) throws SubscriptionCreationException {
        Subscription subscriptionResource = null;
        try {
            subscriptionResource = this.createSubscription(consumerReference, producerReference, initialTerminationTime, subscriptionPolicy, precondition, selector, producerKey, producerHomeLocation, topicPathExpression, useNotify, notificationSecurityDescriptor, resourceSecurityDescriptor);
        }
        catch (Exception e) {
            throw new SubscriptionCreationException(i18n.getMessage("subscriptionCreateFailed"), e);
        }
        if (subscriptionResource instanceof PersistenceCallback) {
            try {
                ((PersistenceCallback)((Object)subscriptionResource)).store();
            }
            catch (ResourceException e) {
                throw new SubscriptionCreationException(i18n.getMessage("subscriptionCreateFailed"), e);
            }
        }
        SimpleResourceKey key = new SimpleResourceKey(this.keyTypeName, ((ResourceIdentifier)((Object)subscriptionResource)).getID());
        this.add(key, subscriptionResource);
        return key;
    }

    protected Subscription createSubscription(EndpointReferenceType consumerReference, EndpointReferenceType producerReference, Calendar initialTerminationTime, Object subscriptionPolicy, QueryExpressionType precondition, QueryExpressionType selector, ResourceKey producerKey, String producerHomeLocation, TopicExpressionType topicPathExpression, boolean useNotify, ClientSecurityDescriptor notificationSecurityDescriptor, ResourceSecurityDescriptor resourceSecurityDescriptor) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return (Subscription)this.resourceConstructor.newInstance(consumerReference, producerReference, initialTerminationTime, subscriptionPolicy, precondition, selector, producerKey, producerHomeLocation, topicPathExpression, Boolean.FALSE, useNotify ? Boolean.TRUE : Boolean.FALSE, notificationSecurityDescriptor, resourceSecurityDescriptor);
    }
}

