/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.encryption;

import java.security.cert.X509Certificate;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.message.WSEncryptBody;
import org.globus.wsrf.impl.security.authentication.ContextCrypto;
import org.globus.wsrf.impl.security.authentication.wssec.GSSConfig;
import org.globus.wsrf.impl.security.util.EnvelopeConverter;
import org.w3c.dom.Document;

public class X509WSEncryptedSOAPEnvelopeBuilder
extends WSEncryptBody {
    private static Log logger = LogFactory.getLog((String)X509WSEncryptedSOAPEnvelopeBuilder.class.getName());
    protected static ContextCrypto crypto = ContextCrypto.getInstance();

    public X509WSEncryptedSOAPEnvelopeBuilder(X509Certificate cert) {
        this.setUseThisCert(cert);
        this.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
    }

    public SOAPEnvelope build(SOAPEnvelope envelope) throws Exception {
        return this.buildMessage(envelope).getSOAPPart().getEnvelope();
    }

    public SOAPMessage buildMessage(SOAPEnvelope env) throws Exception {
        logger.debug((Object)"Begin encryption...");
        Document doc = EnvelopeConverter.getInstance().toDocument(env);
        SOAPMessage message = EnvelopeConverter.getInstance().toSOAPMessage(this.build(doc, crypto));
        logger.debug((Object)"Encryption complete");
        return message;
    }

    static {
        GSSConfig.init();
    }
}

