/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import javax.xml.rpc.handler.MessageContext;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.descriptor.AuthMethod;

public class GSITransportAuthMethod
implements AuthMethod {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.descriptor.errors");
    static final int BOTH_TYPE = 0;
    static final int INTEGRITY_TYPE = 1;
    static final int PRIVACY_TYPE = 2;
    private int type;
    public static final GSITransportAuthMethod BOTH = new GSITransportAuthMethod(0);
    public static final GSITransportAuthMethod PRIVACY = new GSITransportAuthMethod(2);
    public static final GSITransportAuthMethod INTEGRITY = new GSITransportAuthMethod(1);

    public GSITransportAuthMethod(int type) {
        this.type = type;
    }

    public boolean isAuthenticated(MessageContext ctx) {
        switch (this.type) {
            case 0: {
                return Constants.SIGNATURE.equals(ctx.getProperty("org.globus.security.transport.type")) || Constants.ENCRYPTION.equals(ctx.getProperty("org.globus.security.transport.type"));
            }
            case 1: {
                return Constants.SIGNATURE.equals(ctx.getProperty("org.globus.security.transport.type"));
            }
            case 2: {
                return Constants.ENCRYPTION.equals(ctx.getProperty("org.globus.security.transport.type"));
            }
        }
        return false;
    }

    public String getName() {
        switch (this.type) {
            case 0: {
                return i18n.getMessage("gsiTransportMethod");
            }
            case 1: {
                return i18n.getMessage("gsiTransportMethodSig");
            }
            case 2: {
                return i18n.getMessage("gsiTransportMethodEnc");
            }
        }
        return "GSI transport";
    }

    public int getProtectionType() {
        return this.type;
    }
}

