/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators.common;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Scheduler;
import org.gcube.common.vremanagement.deployer.impl.resources.BasePackage;
import org.gcube.common.vremanagement.deployer.impl.resources.KeyData;

public abstract class BaseScheduler
implements Scheduler {
    protected final GCUBELog logger = new GCUBELog(this.getClass());
    protected Map<KeyData, Set<File>> scripts = Collections.synchronizedMap(new HashMap());

    @Override
    public void add(BasePackage target) throws DeployException {
        HashSet<File> tempScripts = new HashSet<File>();
        for (String script : this.getScriptsToSchedule(target)) {
            tempScripts.add(new File(script));
        }
        if (!this.scripts.containsKey(target.getKey())) {
            this.scripts.put(target.getKey(), tempScripts);
        } else {
            this.scripts.get(target.getKey()).addAll(tempScripts);
        }
    }

    @Override
    public void remove(BasePackage target) throws DeployException {
        this.scripts.remove(target.getKey());
    }

    @Override
    public void run(KeyData key) throws DeployException {
        if (!this.scripts.containsKey(key)) {
            return;
        }
        for (File script : this.scripts.get(key)) {
            Process p;
            this.logger.debug((Object)(this.getClass().getName() + " is going to execute " + script.getAbsolutePath() + " as script for " + key.getPackageName() + "..."));
            try {
                p = Runtime.getRuntime().exec("chmod 777 " + script.getAbsolutePath(), new String[0], script.getParentFile());
                p.waitFor();
                p.destroy();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec(script.getPath(), null, script.getParentFile());
                p.waitFor();
                p.destroy();
            }
            catch (Exception ioe) {
                this.logger.error((Object)ioe);
                throw new DeployException("InstallScheduler is unable to execute the script " + script.getAbsolutePath() + " for package " + key.getPackageName());
            }
        }
    }

    protected abstract List<String> getScriptsToSchedule(BasePackage var1);

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

