/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.contexts;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.utils.logging.GCUBELog;

public class LocalInstanceContext {
    private GCUBELog logger = new GCUBELog(LocalInstanceContext.class);
    private Map<String, GCUBERunningInstance> instances = new HashMap<String, GCUBERunningInstance>();
    private static LocalInstanceContext context = new LocalInstanceContext();
    private File storageLocation = new File(GHNContext.getContext().getVirtualPlatformsLocation() + File.separator + ".instances");

    private LocalInstanceContext() {
        try {
            this.loadInstances();
        }
        catch (Exception e) {
            this.logger.warn("Failed to load the local instances, starting from an empty list", e);
        }
    }

    public static LocalInstanceContext getContext() {
        return context;
    }

    public synchronized void registerInstance(GCUBERunningInstance instance) throws Exception {
        this.instances.put(instance.getID(), instance);
        instance.store(new FileWriter(new File(this.storageLocation + File.separator + instance.getID() + ".xml")));
    }

    public synchronized void unregisterInstance(GCUBERunningInstance instance) {
        this.instances.remove(instance.getID());
        new File(this.storageLocation + File.separator + instance.getID() + ".xml").delete();
    }

    public synchronized GCUBERunningInstance getInstance(String id) throws Exception {
        if (this.instances.containsKey(id)) {
            return this.instances.get(id);
        }
        throw new Exception("Instance not found");
    }

    public synchronized GCUBERunningInstance getInstance(String clazz, String name) throws Exception {
        for (GCUBERunningInstance ri : this.instances.values()) {
            if (!ri.getServiceClass().equalsIgnoreCase(clazz) || !ri.getServiceName().equalsIgnoreCase(name)) continue;
            return ri;
        }
        throw new Exception("Instance not found");
    }

    public synchronized Collection<GCUBERunningInstance> getAllInstances() {
        return Collections.unmodifiableCollection(this.instances.values());
    }

    public synchronized List<GCUBERunningInstance> getAllInstancesForPlatform(PlatformDescription platform) {
        ArrayList<GCUBERunningInstance> ret = new ArrayList<GCUBERunningInstance>();
        for (GCUBERunningInstance ri : this.instances.values()) {
            if (!ri.getPlatform().getName().equals(platform.getName()) || ri.getPlatform().getVersion() != platform.getVersion() || ri.getPlatform().getMinorVersion() != platform.getMinorVersion()) continue;
            ret.add(ri);
        }
        return ret;
    }

    private void loadInstances() throws Exception {
        File[] serializedInstances;
        if (!this.storageLocation.exists()) {
            if (!this.storageLocation.mkdirs()) {
                throw new Exception("Unable to create the storage location");
            }
            return;
        }
        for (File serializedInstance : serializedInstances = this.storageLocation.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".xml");
            }
        })) {
            try {
                GCUBERunningInstance instance = GHNContext.getImplementation(GCUBERunningInstance.class);
                instance.load(new FileReader(serializedInstance));
                this.instances.put(instance.getID(), instance);
            }
            catch (Exception e) {
                this.logger.warn("Failed to laod from " + serializedInstance.getAbsolutePath(), e);
            }
        }
    }
}

