/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.registrations.handlers;

import java.util.concurrent.Future;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.context.ISPublisherContext;
import org.gcube.common.informationsystem.publisher.impl.registrations.handlers.ISPublisherHandler;

public abstract class BaseISPublisherHandler
implements ISPublisherHandler {
    protected static final GCUBELog logger = new GCUBELog(BaseISPublisherHandler.class);
    private Future<?> future;

    @Override
    public void run() {
        logger.trace((Object)("Running " + this.getClass().getSimpleName() + "on resource " + this.getResourceID() + " asynchronously"));
        try {
            this.execute();
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred when executing the registration handler", (Throwable)e);
        }
    }

    @Override
    public void execute() throws Exception {
        int maxAttempts = 3;
        try {
            maxAttempts = (Integer)ISPublisherContext.getContext().getProperty("RESOURCE_PUBLICATION_MAX_ATTEMPTS");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (maxAttempts == -1) {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.submitRequest();
                    break;
                }
                catch (Exception e) {
                    logger.warn((Object)"Execution failed ", (Throwable)e);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {}
                }
            }
        } else {
            int attempts = 0;
            while (attempts++ < maxAttempts && !Thread.currentThread().isInterrupted()) {
                try {
                    this.submitRequest();
                    break;
                }
                catch (Exception e) {
                    logger.warn((Object)"Execution failed ", (Throwable)e);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {}
                }
            }
            if (attempts == maxAttempts) {
                throw new Exception("Max attempts reached, failed to execute the request on resource " + this.getResourceID());
            }
        }
    }

    protected abstract void submitRequest() throws Exception;

    @Override
    public abstract String getResourceID();

    @Override
    public Future<?> getFutureTask() {
        return this.future;
    }

    @Override
    public void setFutureTask(Future<?> future) {
        this.future = future;
    }
}

