/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.util.List;
import java.util.Properties;
import javax.xml.rpc.Stub;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.core.shutdown.ShutdownPortType;
import org.globus.wsrf.core.shutdown.service.ShutdownServiceAddressingLocator;
import org.globus.wsrf.utils.FaultHelper;

public class ShutdownClient
extends BaseClient {
    private static final String FOOTER = "Where:\n  'soft' - lets threads die naturally (default)\n  'hard' - forces JVM shutdown\n";

    public static void main(String[] args) throws Exception {
        boolean hard;
        ShutdownClient client;
        block9: {
            Properties defaultOptions = new Properties();
            defaultOptions.put(BaseClient.SERVICE_URL.getOpt(), "https://localhost:8443/wsrf/services/ShutdownService");
            defaultOptions.put(BaseClient.PROTECTION.getOpt(), "sig");
            defaultOptions.put(BaseClient.AUTHZ.getOpt(), "none");
            client = new ShutdownClient();
            client.setCustomUsage("[soft | hard]");
            client.setHelpFooter(FOOTER);
            hard = false;
            try {
                CommandLine line = client.parse(args, defaultOptions);
                List options = line.getArgList();
                if (options == null || options.isEmpty() || options.size() != 1) break block9;
                String arg = (String)options.get(0);
                if (arg.equalsIgnoreCase("soft")) {
                    hard = false;
                    break block9;
                }
                if (arg.equalsIgnoreCase("hard")) {
                    hard = true;
                    break block9;
                }
                throw new Exception("Invalid argument: " + arg);
            }
            catch (ParseException e) {
                System.err.println("Error: " + e.getMessage());
                System.exit(1);
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
                System.exit(1);
            }
        }
        ShutdownServiceAddressingLocator locator = new ShutdownServiceAddressingLocator();
        try {
            ShutdownPortType port = locator.getShutdownPortTypePort(client.getEPR());
            client.setOptions((Stub)((Object)port));
            port.shutdown(hard);
        }
        catch (Exception e) {
            if (client.isDebugMode()) {
                FaultHelper.printStackTrace(e);
            } else {
                System.err.println("Error: " + FaultHelper.getMessage(e));
            }
            System.exit(2);
        }
    }
}

